package jp.osoite.tomu.xml.jaxb.wrapper;

import java.math.BigInteger;
import java.util.List;
import jp.osoite.tomu.xml.jaxb.object.SfeerRequestSet;
import jp.osoite.tomu.xml.jaxb.object.TomuMessage;

/**
 *
 * @author shima
 */
public class RequestSfeerWrapper extends TomuMessageWrapper {

    private SfeerRequestSet sfeerReq;
    private long[] tempIds;
    private long[] pedIds;
    private Location[] locations;

    public RequestSfeerWrapper(TomuMessage msg) {
        super(msg);
        sfeerReq = msg.getRequest().getSfeerRequestSet();
        init();
    }

    private void init() {
        List<BigInteger> idList = sfeerReq.getTemperatureSet().getStaticSensorID();
        tempIds = new long[idList.size()];
        int counter = 0;
        for (BigInteger bigInt : idList) {
            tempIds[counter++] = bigInt.longValue();
        }
        idList = sfeerReq.getPedestrianSet().getStaticSensorID();
        pedIds = new long[idList.size()];
        counter = 0;
        for (BigInteger bigInt : idList) {
            pedIds[counter++] = bigInt.longValue();
        }
        List<jp.osoite.tomu.xml.jaxb.object.Location> locList = sfeerReq.getImageSet().getLocation();
        locations = new Location[locList.size()];
        counter = 0;
        for (jp.osoite.tomu.xml.jaxb.object.Location loc : locList) {
            locations[counter++] = new Location(loc.getLat().doubleValue(), loc.getLon().doubleValue(), loc.getRadius().intValue());
        }
    }

    public long[] getTemperatureSensorIdList() {
        return tempIds;
    }

    public long[] getPedestrianSensorIdList() {
        return pedIds;
    }

    public Location[] getLocationList(){
        return locations;
    }
}
