package jp.osoite.tomu.xml.jaxb.wrapper;

/**
 *
 * @author shima
 */
public class AreaInitValues {

    private int areaId;
    private TemperatureInitValue tVal;
    private PedestrianInitValue pVal;

    public AreaInitValues(int areaId) {
        this.areaId = areaId;
        this.tVal = null;
        this.pVal = null;
    }

    public int getAreaId(){
        return areaId;
    }

    public void setTemperatureInitValue(TemperatureInitValue tVal) {
        this.tVal = tVal;
    }

    public TemperatureInitValue getTemperatureInitValue() {
        return tVal;
    }

    public void setPedestrianInitValue(PedestrianInitValue pVal) {
        this.pVal = pVal;
    }

    public PedestrianInitValue getPedestrianInitValue() {
        return pVal;
    }

    public class TemperatureInitValue {

        private long sensorId;
        private double crrValue;
        private double maxValue;
        private double minValue;
        private double avgValue;
        private double[] fiveMinValues;

        public TemperatureInitValue(long sensorId,
                double crrVal,
                double max,
                double min,
                double avg,
                double[] fmv) {
            this.sensorId = sensorId;
            this.crrValue = crrVal;
            this.maxValue = max;
            this.minValue = min;
            this.avgValue = avg;
            this.fiveMinValues = fmv;
        }

        public double getAverage() {
            return avgValue;
        }

        public double getCurrent() {
            return crrValue;
        }

        public double[] getFiveMinValues() {
            return fiveMinValues;
        }

        public double getMax() {
            return maxValue;
        }

        public double getMin() {
            return minValue;
        }

        public long getSensorId() {
            return sensorId;
        }
    }

    public class PedestrianInitValue {

        private long sensorId;
        private int crrFlowValue;
        private int crrRegValue;
        private double avgFlowValue;

        public PedestrianInitValue(long sensorId, int flow, int reg, double avg) {
            this.sensorId = sensorId;
            this.crrFlowValue = flow;
            this.crrRegValue = reg;
            this.avgFlowValue = avg;
        }

        public double getAverageFlow() {
            return avgFlowValue;
        }

        public int getFlow() {
            return crrFlowValue;
        }

        public int getResidence() {
            return crrRegValue;
        }

        public long getSensorId() {
            return sensorId;
        }
    }
}
