package jp.osoite.tomu.xml.jaxb.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import jp.osoite.tomu.xml.jaxb.object.*;

/**
 * デバッグプリント用のクラスです．
 * @author shima
 */
public final class TomuMessagePrinter {

    private static long SEQ = 0;

    private TomuMessagePrinter() {
    }

    public static synchronized void print(TomuMessage tomuObj) {
        System.out.println("=========(Print: " + (++SEQ) + ")===================");
        Head head = tomuObj.getHead();
        printHead(head);
        if (head.getMsgType().equals(TomuMessageType.APPS_RESPONSE.toString())) {
            printAppsResponse(tomuObj);
        } else if (head.getMsgType().equals(TomuMessageType.SOURCE_UPLOAD.toString())) {
            printSensorUpload(tomuObj);
        } else if (head.getMsgType().equals(TomuMessageType.APPS_REQUEST.toString())) {
            SfeerRequestSet sfeerReq = tomuObj.getRequest().getSfeerRequestSet();
            if (sfeerReq != null) {
                printSfeerRequest(sfeerReq, tomuObj.getRequest().getSeq().longValue());
            }
        } else if (head.getMsgType().equals(TomuMessageType.APPS_INIT_REQUEST.toString())) {
            Sfeer sfeer = tomuObj.getInitRequest().getSfeer();
            if (sfeer != null) {
                printSfeerInitRequest(sfeer);
            }
        } else if (head.getMsgType().equals(TomuMessageType.APPS_INIT_RESPONSE.toString())) {
            Sfeer sfeer = tomuObj.getInitResponse().getSfeer();
            if (sfeer != null) {
                printSfeerInitResponse(sfeer);
            }
        }
    }

    private static void printHead(Head head) {
        System.out.println("MsgID : " + head.getMsgId());
        System.out.println("MsgType : " + head.getMsgType());
        System.out.println("MsgDest : " + head.getMsgDest());
        System.out.println("MsgSRC : " + head.getMsgSrc());
    }

    private static void printAppsResponse(TomuMessage tomuObj) {
        SensorDataSet dataSet = tomuObj.getResponse().getSensorDataSet();
        System.out.println("Seq : " + dataSet.getSeq());
        try {
            List<StaticSensorData> staticList = dataSet.getStaticSensorData();
            for (StaticSensorData data : staticList) {
                printStaticSensor(data);
            }
        } catch (Exception e) {
        }
        try {
            List<DynamicSensorData> dynamicList = dataSet.getDynamicSensorData();
            for (DynamicSensorData data : dynamicList) {
                printDynamicSensor(data);
            }
        } catch (Exception e) {
        }
    }

    private static void printSensorUpload(TomuMessage tomuObj) {
        Upload upload = tomuObj.getUpload();
        System.out.println("Seq : " + upload.getSeq());
        SensorSourceDataSet ssrs = upload.getSensorSourceDataSet();
        try {
            List<StaticSensorData> list = ssrs.getStaticSensorData();
            for (StaticSensorData ssd : list) {
                printStaticSensor(ssd);
            }
        } catch (Exception e) {
        }
        try {
            List<DynamicSensorData> list = ssrs.getDynamicSensorData();
            for (DynamicSensorData dsd : list) {
                printDynamicSensor(dsd);
            }
        } catch (Exception e) {
        }
        try {
            List<KitokitoSensorData> list = ssrs.getKitokitoSensorData();
            for (KitokitoSensorData data : list) {
                printKitokitoSensor(data);
            }
        } catch (Exception e) {
        }
    }

    private static void printStaticSensor(StaticSensorData data) {
        System.out.println("-----StaticSensor-----");
        System.out.println("SensorType : " + data.getType());
        System.out.println("SensedTime : " + data.getSensedTime());
        System.out.println("SensorID : " + data.getStaticSensorID());
        System.out.println("<Value>");
        Value value = data.getValue();
        if (data.getType().equals("TEMP")) {
            System.out.println("Temparature : " + value.getTempValue());
        } else if (data.getType().equals("CO2")) {
            System.out.println("CO2 : " + value.getCO2Value());
        } else if (data.getType().equals("HUMIDITY")) {
            System.out.println("Humidity : " + value.getHumValue());
        } else if (data.getType().contains("PEDESTRIAN")) {
            StreetPedestrianFlowValue spfv = value.getStreetPedestrianFlowValue();
            System.out.println("MeasurementTimeSec : " + spfv.getMeasurementTimeSec());
            System.out.println("Residence : " + spfv.getResidence());
            ChiefAxis cAxis = spfv.getChiefAxis();
            Plus plus = cAxis.getPlus();
            System.out.println("#ChiefAxis Plus#");
            System.out.println("  Num :" + plus.getNum());
            System.out.println("  Compass :" + plus.getCompass());
            System.out.println("  AvgSpeed :" + plus.getAverageSpeed().getMeterperSecond().doubleValue());
            Minus minus = cAxis.getMinus();
            System.out.println("#ChiefAxis Minus#");
            System.out.println("  Num :" + minus.getNum());
            System.out.println("  Compass :" + minus.getCompass());
            System.out.println("  AvgSpeed :" + minus.getAverageSpeed().getMeterperSecond().doubleValue());
            if (data.getType().equals("INTER_PEDESTRIAN")) {
                SubAxis sAxis = spfv.getSubAxis();
                plus = sAxis.getPlus();
                System.out.println("#SubAxis Plus#");
                System.out.println("  Num :" + plus.getNum());
                System.out.println("  Compass :" + plus.getCompass());
                System.out.println("  AvgSpeed :" + plus.getAverageSpeed().getMeterperSecond().doubleValue());
                minus = sAxis.getMinus();
                System.out.println("#SubAxis Minus#");
                System.out.println("  Num :" + minus.getNum());
                System.out.println("  Compass :" + minus.getCompass());
                System.out.println("  AvgSpeed :" + minus.getAverageSpeed().getMeterperSecond().doubleValue());
            }
        }
    }

    private static void printDynamicSensor(DynamicSensorData data) {
        System.out.println("-----DynamicSensor-----");
        System.out.println("SensorType : " + data.getType());
        System.out.println("SensedTime : " + data.getSensedTime());
        System.out.println("SensorName : " + data.getSensorName());
        System.out.println("URL : " + data.getUrlValue());
        System.out.println("URL(thumbnail) : " + data.getThumbnailUrlValue());
        System.out.println("Direction : " + data.getDirection());
        Location loc = data.getLocation();
        System.out.println("Location : (Lat)" + loc.getLat() + ",(Lon)" + loc.getLon());
    }

    private static void printKitokitoSensor(KitokitoSensorData data) {
        System.out.println("-----KitokitoSensor-----");
        System.out.println("SensorType : " + data.getType());
        System.out.println("SensedTime : " + data.getSensedTime());
        System.out.println("SensorID : " + data.getSensorID());
        System.out.println("URL : " + data.getImageUrl());
        System.out.println("URL(thumbnail) : " + data.getThumbnailUrl());
        System.out.println("Direction : " + data.getDirection());
        Location loc = data.getLocation();
        System.out.println("Location : (Lat)" + loc.getLat() + ",(Lon)" + loc.getLon());
    }

    private static void printSfeerRequest(SfeerRequestSet reqSet, long seq) {
        System.out.println("-----SfeerRequest-----");
        System.out.println("Seq : " + seq);
        TemperatureSet tSet = reqSet.getTemperatureSet();
        List<BigInteger> idList = tSet.getStaticSensorID();
        if (!idList.isEmpty()) {
            System.out.println("#Temp Sensors#");
            for (BigInteger id : idList) {
                System.out.println("ID : " + id);
            }
        }
        PedestrianSet pSet = reqSet.getPedestrianSet();
        idList = pSet.getStaticSensorID();
        if (!idList.isEmpty()) {
            System.out.println("#Pedestrian Sensors#");
            for (BigInteger id : idList) {
                System.out.println("ID : " + id);
            }
        }
        ImageSet iSet = reqSet.getImageSet();
        List<Location> list = iSet.getLocation();
        if (!list.isEmpty()) {
            System.out.println("#Image Locations#");
            for (Location loc : list) {
                System.out.println("Location : (lat)" + loc.getLat() + " (lon)" + loc.getLon() + " (Radius)" + loc.getRadius());
            }
        }
    }

    private static void printSfeerInitRequest(Sfeer sfeer) {
        System.out.println("-----SfeerInitRequest-----");
        List<Area> list = sfeer.getAreaSet().getArea();
        for (Area area : list) {
            System.out.println("#Area " + area.getAreaId() + "#");
            Location loc = area.getLocation();
            System.out.println("Location : (lat)" + loc.getLat() + " (lon)" + loc.getLon() + " (Radius)" + loc.getRadius());
            TimeSpan span = area.getTimeSpan();
            System.out.println("TimeSpan : " + span.getBegin() + "～" + span.getEnd());
        }
    }

    private static void printSfeerInitResponse(Sfeer sfeer) {
        System.out.println("-----SfeerInitResponse-----");
        List<Area> list = sfeer.getAreaSet().getArea();
        for (Area area : list) {
            InitTemperature initTemp = area.getInitTemperature();
            if (initTemp != null) {
                System.out.println("#Temperature Sensor#");
                System.out.println("SensorID : " + initTemp.getStaticSensorID());
                System.out.println("CurrentValue : " + initTemp.getCurrentTempValue());
                System.out.println("MaxValue : " + initTemp.getMaxTempValue());
                System.out.println("MinValue : " + initTemp.getMinTempValue());
                System.out.println("AvgValue : " + initTemp.getAvgTempValue());
                List<BigDecimal> valueList = initTemp.getFiveMinuteTempData().getTempValue();
                if (!valueList.isEmpty()) {
                    System.out.println("5min vals : ");
                    for (BigDecimal val : valueList) {
                        System.out.print(val + ", ");
                    }
                    System.out.println();
                }
            }
            InitPedestrian initPed = area.getInitPedestrian();
            if (initPed != null) {
                System.out.println("#Pedestrian Sensor#");
                System.out.println("SensorID : " + initPed.getStaticSensorID());
                System.out.println("CurrentFlow : " + initPed.getCurrentFlowValue());
                System.out.println("CurrentReg : " + initPed.getCurrentResidentValue());
                System.out.println("AvgFlow : " + initPed.getAvgFlowValue());
            }
        }
    }
}