package jp.osoite.tomu.xml.jaxb.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

/**
 *
 * @author shima
 */
public final class TimeConverter {

    private static final String DATE_SYNTAX = "yyyy-MM-dd HH:mm:ss";
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat(DATE_SYNTAX);

    private TimeConverter() {
    }

    /**
     * long値の時刻データをyyyy-MM-dd HH:mm:ssの形式に出力します．
     * @param time UNIX Time
     * @return yyyy-MM-dd HH:mm:ssの形式のString
     */
    public static String convertToString(long time) {
        Date date = new Date(time);
        return DATE_FORMAT.format(date);
    }

    /**
     * yyyy-MM-dd HH:mm:ss形式で表された時刻をlong値に変換します．
     * @param time yyyy-MM-dd HH:mm:ss形式で表されたString
     * @return 対応するUNIX Time．失敗した場合は0．
     */
    public static long convertToLong(String time) {
        long result = 0;
        try {
            result = DATE_FORMAT.parse(time).getTime();
        } catch (ParseException ex) {
        }
        return result;
    }
}
