package jp.osoite.tomu.xml.jaxb.util;

import java.util.List;
import jp.osoite.tomu.sensor.pedestrian.InterPedestrianFlowValue;
import jp.osoite.tomu.sensor.pedestrian.PedestrianFlowValue;
import jp.osoite.tomu.xml.jaxb.object.ChiefAxis;
import jp.osoite.tomu.xml.jaxb.object.SensorSourceDataSet;
import jp.osoite.tomu.xml.jaxb.object.StaticSensorData;
import jp.osoite.tomu.xml.jaxb.object.StreetPedestrianFlowValue;
import jp.osoite.tomu.xml.jaxb.object.SubAxis;
import jp.osoite.tomu.xml.jaxb.object.TomuMessage;
import jp.osoite.tomu.xml.jaxb.object.Value;
import jp.osoite.tomu.xml.jaxb.wrapper.Axis;

/**
 * 2010/5/20以降破棄予定クラス
 * @author shima
 */
public class ISensorValueConverter {

    public static PedestrianFlowValue convertToPedestrianFlowValue(TomuMessage mes) {
        String mesType = mes.getHead().getMsgType();
        if (mesType.equals(TomuMessageType.SOURCE_UPLOAD.toString())) {
            SensorSourceDataSet ssds = mes.getUpload().getSensorSourceDataSet();
            List<StaticSensorData> list = ssds.getStaticSensorData();
            for (StaticSensorData ssd : list) {
                Value value = ssd.getValue();
                if (ssd.getType().contains("PEDESTRIAN")) {
                    StreetPedestrianFlowValue spfv = value.getStreetPedestrianFlowValue();
                    ChiefAxis cAxis = spfv.getChiefAxis();
                    if (ssd.getType().equals("PEDESTRIAN")) {
                        PedestrianFlowValue ps = new PedestrianFlowValue(spfv.getMeasurementTimeSec().longValue(),
                                new Axis(cAxis),
                                spfv.getResidence().intValue(),
                                ssds.getFrequency().getSec().intValue());
                        ps.setSensorid(ssd.getStaticSensorID().longValue());
                        return ps;
                    } else if (ssd.getType().equals("INTER_PEDESTRIAN")) {
                        SubAxis sAxis = spfv.getSubAxis();
                        InterPedestrianFlowValue interps = new InterPedestrianFlowValue(spfv.getMeasurementTimeSec().longValue(),
                                new Axis(cAxis),
                                new Axis(sAxis),
                                spfv.getResidence().intValue(),
                                ssds.getFrequency().getSec().intValue());
                        interps.setSensorid(ssd.getStaticSensorID().longValue());
                        return interps;
                    }
                }
            }
            throw new NullPointerException("PEDESTRIAN Value is null");
        }
        return null;
    }
}
