package jp.osoite.tomu.sensor.tscan.socks;

import java.net.*;
import java.io.*;
import java.util.*;
import java.util.concurrent.CopyOnWriteArrayList;

/**
 *
 * @author shima
 */
public class StringTransportNode {

    private Socket socket;
    private InputThread inputThread;
    private BufferedReader input;
    private PrintWriter output;
    private List<StringReceiveListener> listeners;

    public StringTransportNode(String srvip, int srvport) throws IOException {
        socket = new Socket(srvip, srvport);
        socket.setSoTimeout(0);
        output = new PrintWriter(socket.getOutputStream());
        input = new BufferedReader(new InputStreamReader(socket.getInputStream()));
        inputThread = new InputThread();
        new Thread(inputThread).start();
        listeners = new CopyOnWriteArrayList<StringReceiveListener>();
    }

    public void addMessageReceiveListener(StringReceiveListener listener) {
        listeners.add(listener);
    }

    public void removeMessageReceiveListener(StringReceiveListener listener) {
        listeners.remove(listener);
    }

    private void notifyMessageReceiveListener(String mes) {
        for (StringReceiveListener listener : listeners) {
            listener.receive(mes);
        }
    }

    public void send(String mes) throws IOException {
        output.println(mes);
        output.flush();
    }

    public void stop() {
        try {
            socket.close();
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            inputThread.isRunning = false;
        }
    }

    private class InputThread implements Runnable {
        volatile boolean isRunning;
        public void run() {
            isRunning = true;
            while (isRunning) {
                try {
                    notifyMessageReceiveListener(input.readLine());
                } catch (Exception e) {
                }
            }
        }
    }
}
