package jp.osoite.tomu.itree.demo;

import java.io.*;
import java.util.logging.Level;
import java.util.logging.Logger;
import jp.osoite.tomu.itree.util.Constants;
import jp.osoite.tomu.itree.core.ITree;
import jp.osoite.tomu.itree.core.ITreeCore;

public class ITreeTest extends Thread{


    	public static void main(String[] args) {
            ITreeTest it=new ITreeTest();
            it.start();
            it.initTreeDemo();
            
        }

        public void run(){

            while(true){
            try {
                Thread.sleep(1000);
            } catch (InterruptedException ex) {
                Logger.getLogger(ITreeTest.class.getName()).log(Level.SEVERE, null, ex);
            }
            }
        }
    
	public void initTreeDemo() {
		int lineNum = 0;
		String[] columns = null;
		
		/* 
		 * ######################################
		 * ### Test of Creating ITree Object. ###
		 * ######################################
		 * test.rtr is a disk strage for the ITree. 
		 * Setting of dimension is 2 since TomuDB manages locations of sensors.
		 */
		ITree TestOfITree = new ITreeCore("test.rtr", 128, Constants.CACHESIZE, 2);

		/* 
		 * #######################################
		 * ### Test of Inserting ITree Object. ###
		 * #######################################
		 * Sensors which is used in TScan was inserted in the test.
		 * loclistOfTscan.csv is the location data file of TScan sensors. 
		 */
		try{		
			FileReader fr = new FileReader("loclistOfTscan.csv");
            BufferedReader br = new BufferedReader(fr);
        
            String tmp_str;
            while((tmp_str = br.readLine()) != null){
            	lineNum++;
            	if (tmp_str.length() <= 0)
            		continue;
            	columns = tmp_str.split(",");
            	if (0 < columns.length) {
            		TestOfITree.insertSensorID(Long.parseLong(columns[0]), Double.parseDouble(columns[1]), Double.parseDouble(columns[2]), 
            				Double.parseDouble(columns[1]), Double.parseDouble(columns[2]));
            	}
            }
            br.close();     
        }
        catch(IOException e){
            e.printStackTrace();
            System.exit(1);
        }
        /*
         * The following location is Institute of Industrial Science, the University of Tokyo. 
         */
        TestOfITree.insertSensorID(1, 35.660146, 139.677595, 35.660146, 139.677595);
        
		/* 
		 * ######################################################################
		 * ### Test of Checking whether the sensor is available in the ITree. ###
		 * ######################################################################
		 */
        System.out.println("[ Test of isAvailableSensorID(1) ]");
		if(TestOfITree.isAvailableSensorID(1)){
			System.out.println("sensorID 1 is available");
		}
		System.out.println("");
		
		/* 
		 * ########################################################################
		 * ### Test of Searching sensors based on a specified range and returns ### 
		 * ### the results as the array of long objects.                        ###
		 * ########################################################################
		 */
		long[] results = new long[10];
		/*
		 * Range is specified around Tatebayashi station.
		 */
		results = TestOfITree.searchSensorIDList(36.24475774281345, 36.24628061943219, 139.52847003936768, 139.53091621398926);
		System.out.println("[ Test of searchSensorIDList(36.24475774281345, 36.24628061943219, 139.52847003936768, 139.53091621398926) ]");
		for(int i = 0; i < results.length; i++){
			System.out.print(results[i] + " ");
		}
		System.out.println("\n");
		
		/* 
		 * ########################################################################
		 * ### Test of searching sensors based on a specified range and returns ###
		 * ### a string object as a CSV format.                                 ###
		 * ########################################################################
		 */
		System.out.println("[ Test of searchSensorIDinCommaList(36.24475774281345, 36.24628061943219, 139.52847003936768, 139.53091621398926) ]");
        System.out.println(TestOfITree.searchSensorIDinCommaList(36.24475774281345, 36.24628061943219, 139.52847003936768, 139.53091621398926));
		System.out.println("");
		
		/* 
		 * ########################################################################
		 * ### Test of returns all sensorID that the ITree manages as the array ###
		 * ### of long objects.                                                 ###
		 * ########################################################################
		 */
		results = TestOfITree.getAllTreeElements();
		System.out.println("[ Test of getAllTreeElements() ]");
		for(int i = 0; i < results.length; i++){
			System.out.print(results[i] + " ");
		}
		System.out.println("\n");

		/* 
		 * ########################################################################
		 * ### Test of printing all sensorID that the ITree manages to stdout.  ###
		 * ########################################################################
		 */
		System.out.print("[ Test of printAllTreeElements() ]\n");
		TestOfITree.printAllTreeElements();
		System.out.println("\n");
		
		/* 
		 * ########################################################################
		 * ### Test of deleting a sensor from the ITree based on a specified a  ###
		 * ### sensorID of the sensor.                                          ###
		 * ########################################################################
		 */
		System.out.print("[ Test of deleteSensorID(1) ]\n");
    	if(TestOfITree.deleteSensorID(1)){
    		System.out.println("SensorID 1 could delete form the tree.");
    	}
    	System.out.println("");
    	
		/* 
		 * ##################################################################
		 * ### Test of returning just the number of sensors in the ITree. ###
		 * ##################################################################
		 */
    	System.out.print("[ Test No.1 of getNumOfElement() ]\n");
    	System.out.println("Currnet Number of Sensors in the I-Tree : " + TestOfITree.getNumOfElement());
    	System.out.println("");
    	
		/* 
		 * ####################################################
		 * ### Test of deleting all sensors from the ITree. ###
		 * ####################################################
		 */
    	System.out.print("[ Test of deleteAllSensorIDs() ]\n");
    	TestOfITree.deleteAllSensorIDs();
    	System.out.println("");
    	
		/* 
		 * ##################################################################
		 * ### Test of returning just the number of sensors in the ITree. ###
		 * ##################################################################
		 */
    	System.out.print("[ Test No.2 of getNumOfElement() ]\n");
    	System.out.println("Currnet Number of Sensors in the I-Tree : " + TestOfITree.getNumOfElement());
    	System.out.println("");
	}
}
