package jp.osoite.tomu.itree.core;
////////////////////////////////////////////////////////////////////////
// ITree Interface
////////////////////////////////////////////////////////////////////////

public interface ITree{
    /**
     * The method insert a sensor based on sensorID and range of the sensor into ITree.
     * A sensorID is a long Object.
     * A range of a sensor is represented by a upper-right point(dobule lat_1, double lon_1) 
     * and lower-left point(double lat_2, double lon_2).
     */
    public boolean insertSensorID(long sensorID, double lat_1, double lon_1, double lat_2, double lon_2);

    /**
     * The method checks whether the sensor of the sensorID is available in the ITree.
     * A sensorID is a logn Object.
     */
    public boolean isAvailableSensorID(long sensorID);

    /**
     * The method searchs sensors based on a specified range(double lat_1, double lon_1, double lat_2, double lon_2)
     * and returns a string object as a CSV format.
     *　# This is a debug method, then is going to move the util.
     */
    public String searchSensorIDinCommaList(double lat_1, double lon_1, double lat_2, double lon_2);

    /**
     * The method searchs sensors based on a specified range(double lat_1, double lon_1, double lat_2, double lon_2)
     * and returns the results as the array of long objects.
     */
    public long[] searchSensorIDList(double lat_1, double lon_1, double lat_2, double lon_2);

    /**
     * The method returns all sensorID that the ITree manages as the array of long objects.
     */
    public long[] getAllTreeElements();

    /**
     * The method prints all sensorID that the ITree manages to stdout.
     * This is a debug method, then is going to move the util.
     */
    public void printAllTreeElements();

    /**
     * The method deletes a sensor from the ITree based on a specified a sensorID of the sensor.
     */
    public boolean deleteSensorID(long sensorID);

    /**
     *  The method deletes all sensors from the ITree.
     */
    public void deleteAllSensorIDs();

    /**
     * The method returns just the number of sensors in the ITree.
     * This is a debug method, then is going to move the util.
     */
    public int getNumOfElement();
}
