#include "TomuAccessLenString.h"

#ifndef DBBUG_LOG_TOMUMESSAGEDATA // For Dump a Created Tomu Message.
//#define DBBUG_LOG_TOMUMESSAGEDATA
#endif


class CTomuMessageData {
public:
	CTomuMessageData(void);

	//// Methods ////
public:

	void setMsgType(char* MsgType_Data);
	void setMsgID(unsigned long long MsgID_Data);
	void setMsgDest(char* MsgDest_Data);
	void setMsgSrc(char* MsgSrc_Data);

	void setTypeStaticSensorData(unsigned int Type_Data);
	void setSensedTime(unsigned long long SensedTime_Data);
	void setStaticSensorID(unsigned long long StaticSensorID_Data);
	void setMeasurementTimeSec(unsigned long long MeasurementTimeSec_Data);
	void setChiefAxis(int Plus_Compass, unsigned int Plus_Num, double Plus_AvgSpeed, int Minus_Compass, unsigned int Minus_Num, double Minus_AvgSpeed);
	void setSubAxis(int Plus_Compass, unsigned int Plus_Num, double Plus_AvgSpeed, int Minus_Compass, unsigned int Minus_Num, double Minus_AvgSpeed);
	void setResidence(unsigned int Residence_Data);
	void setFrequencySec(unsigned long long FrequencySec_Data);

	void getMsgID(unsigned long long* MsgID_Data);
	void getStaticSensorID(unsigned long long* StaticSensorID_Data);

	unsigned long long getSeqNum();

	void compile();
	void incrementSeq();

	int getTomuMessageTEXT(char* TomuMessage_Data, size_t SizeOfTomuMessage_Data);

	//// Members ////
private:
	unsigned int SequenceNumber;

private:
	char XMLDataTomuMessage[LEN_TEXT_4K];

	char TomuMessage_MsgType[LEN_TEXT_1K];
	unsigned long long TomuMessage_MsgID;
	char TomuMessage_MsgDest[LEN_TEXT_1K];
	char TomuMessage_MsgSrc[LEN_TEXT_1K];

	unsigned long long TomuMessage_Seq;

	unsigned int TomuMessage_Type;
	
	//long TomuMessage_SensedTime;
	unsigned long long TomuMessage_SensedTime;
	unsigned long long TomuMessage_StaticSensorID;

	unsigned long long TomuMessage_MeasurementTimeSec;

	int TomuMessage_ChiefAxis_PlusTag_Compass;
	unsigned int TomuMessage_ChiefAxis_PlusTag_Num;
	double TomuMessage_ChiefAxis_PlusTag_AvgSpeed;
	int TomuMessage_ChiefAxis_MinusTag_Compass;
	unsigned int TomuMessage_ChiefAxis_MinusTag_Num;
	double TomuMessage_ChiefAxis_MinusTag_AvgSpeed;

	int TomuMessage_SubAxis_PlusTag_Compass;
	unsigned int TomuMessage_SubAxis_PlusTag_Num;
	double TomuMessage_SubAxis_PlusTag_AvgSpeed;
	int TomuMessage_SubAxis_MinusTag_Compass;
	unsigned int TomuMessage_SubAxis_MinusTag_Num;
	double TomuMessage_SubAxis_MinusTag_AvgSpeed;

	unsigned int TomuMessage_Residence;

	unsigned long long TomuMessage_FrequencySec;

public:
	static const unsigned int InterPedestrian = 0;
	static const unsigned int Pedestrian = 1;

};
