#include "stdafx.h"

#include <stdlib.h>
#include <stdio.h> // Need to modify C++ iostream
#include <time.h>

#include "TomuMessageData.h"


#ifndef TOMU_CHAR
#define TOMU_CHAR
#define DOT "#dot;"
#define HTTP "#hll9;"
#endif

int rangedRand( int range_min, int range_max)
{
	// Generate random numbers in the half-closed interval
	// [range_min, range_max). In other words,
	// range_min <= random number < range_max
	int u = (int)((double)rand() / (RAND_MAX + 1) * (range_max - range_min)) + range_min;
	return u;
}


CTomuMessageData::CTomuMessageData(void)
{
	//time_t ltime; // 32bit OS ɂāAVisual C++ 2005 ȍ~́A64bit(long^)
	              // ȑÓA32bit(int32^)
	//time(&ltime);
	char MsgIDTEXT[LEN_STR];
	char StaticSensorIDTEXT[LEN_STR];

	// Use time 64bit version (OS ver(32/64bit) independent)
	__time64_t ltime;
	_time64(&ltime);
	sprintf_s(MsgIDTEXT, sizeof(MsgIDTEXT), "%ld", ltime);

	this->SequenceNumber = 0;
	this->TomuMessage_Seq = 0;

	this->setMsgType("SOURCE_UPLOAD");
	//this->setMsgID("201003251424001");
	//this->setMsgID(MsgIDTEXT);
	//this->setMsgID((long)ltime); // Windows UNIX Time Per Sec.
	this->setMsgID((unsigned long long)ltime * 1000 + rangedRand(0,999)); // Windows UNIX Time Per Sec.
	this->setMsgDest("srctomu@gmail#dot;com");
	this->setMsgSrc("tomucore@gmail#dot;com");

	_time64(&ltime);
	sprintf_s(StaticSensorIDTEXT, sizeof(StaticSensorIDTEXT), "%I64u", ltime);

	//this->setStaticSensorID("201003221542235");
	//this->setStaticSensorID((long)ltime);
	this->setStaticSensorID((long)ltime + rangedRand(0,999));
	
	return;

}

void CTomuMessageData::setMsgType(char* MsgType_Data)
{
	sprintf_s(this->TomuMessage_MsgType,sizeof(this->TomuMessage_MsgType),MsgType_Data);

}

//void CTomuMessageData::setMsgID(char* MsgID_Data)
void CTomuMessageData::setMsgID(unsigned long long MsgID_Data)
{
	//sprintf_s(this->TomuMessage_MsgID,sizeof(this->TomuMessage_MsgID),MsgID_Data);
	this->TomuMessage_MsgID = MsgID_Data;

}

void CTomuMessageData::setMsgDest(char* MsgDest_Data)
{
	sprintf_s(this->TomuMessage_MsgDest,sizeof(this->TomuMessage_MsgDest),MsgDest_Data);

}

void CTomuMessageData::setMsgSrc(char* MsgSrc_Data)
{
	sprintf_s(this->TomuMessage_MsgSrc,sizeof(this->TomuMessage_MsgSrc),MsgSrc_Data);

}

void CTomuMessageData::setTypeStaticSensorData(unsigned int Type_Data)
{
	//if(Type_Data == this->InterPedestrian) {
	//	sprintf_s(this->TomuMessage_Type, sizeof(this->TomuMessage_Type), "INTER_PEDESTRIAN");
	//} else if(Type_Data == this->Pedestrian) {
	//	sprintf_s(this->TomuMessage_Type, sizeof(this->TomuMessage_Type), "PEDESTRIAN");	
	//} else {
	//	sprintf_s(this->TomuMessage_Type, sizeof(this->TomuMessage_Type), "");		
	//}
	if(Type_Data == this->InterPedestrian || Type_Data == this->Pedestrian) {
		this->TomuMessage_Type = Type_Data;
	}

}

//void CTomuMessageData::setSensedTime(unsigned int tYear, unsigned int tMonth, unsigned int tDay, unsigned int tHour, unsigned int tMinute, unsigned int tSecond)
//void CTomuMessageData::setSensedTime(long SensedTime_Data)
void CTomuMessageData::setSensedTime(unsigned long long SensedTime_Data)
{
	//sprintf_s(this->TomuMessage_SensedTime, sizeof(this->TomuMessage_SensedTime), "%04d-%02d-%02d %02d:%02d:%02d", tYear, tMonth, tDay, tHour, tMinute, tSecond);
	this->TomuMessage_SensedTime = SensedTime_Data;
}

//void CTomuMessageData::setStaticSensorID(char* StaticSensorID_Data) 
void CTomuMessageData::setStaticSensorID(unsigned long long StaticSensorID_Data) 
{
	//sprintf_s(this->TomuMessage_StaticSensorID, sizeof(this->TomuMessage_StaticSensorID), "%s", StaticSensorID_Data);
	this->TomuMessage_StaticSensorID = StaticSensorID_Data;
}

//void CTomuMessageData::setMeasurementTimeSec(unsigned int MeasurementTimeSec_Data)
void CTomuMessageData::setMeasurementTimeSec(unsigned long long MeasurementTimeSec_Data)
{
	this->TomuMessage_MeasurementTimeSec = MeasurementTimeSec_Data;
}

//void CTomuMessageData::setChiefAxis(double Plus_Compass, unsigned int Plus_Num, double Plus_AvgSpeed, double Minus_Compass, unsigned int Minus_Num, double Minus_AvgSpeed)
void CTomuMessageData::setChiefAxis(int Plus_Compass, unsigned int Plus_Num, double Plus_AvgSpeed, int Minus_Compass, unsigned int Minus_Num, double Minus_AvgSpeed)
{
	this->TomuMessage_ChiefAxis_PlusTag_Compass = Plus_Compass;
	this->TomuMessage_ChiefAxis_PlusTag_Num = Plus_Num;
	this->TomuMessage_ChiefAxis_PlusTag_AvgSpeed = Plus_AvgSpeed;
	this->TomuMessage_ChiefAxis_MinusTag_Compass = Minus_Compass;
	this->TomuMessage_ChiefAxis_MinusTag_Num = Minus_Num;
	this->TomuMessage_ChiefAxis_MinusTag_AvgSpeed = Minus_AvgSpeed;

}

//void CTomuMessageData::setSubAxis(double Plus_Compass, unsigned int Plus_Num, double Plus_AvgSpeed, double Minus_Compass, unsigned int Minus_Num, double Minus_AvgSpeed)
void CTomuMessageData::setSubAxis(int Plus_Compass, unsigned int Plus_Num, double Plus_AvgSpeed, int Minus_Compass, unsigned int Minus_Num, double Minus_AvgSpeed)
{
	this->TomuMessage_SubAxis_PlusTag_Compass = Plus_Compass;
	this->TomuMessage_SubAxis_PlusTag_Num = Plus_Num;
	this->TomuMessage_SubAxis_PlusTag_AvgSpeed = Plus_AvgSpeed;
	this->TomuMessage_SubAxis_MinusTag_Compass = Minus_Compass;
	this->TomuMessage_SubAxis_MinusTag_Num = Minus_Num;
	this->TomuMessage_SubAxis_MinusTag_AvgSpeed = Minus_AvgSpeed;
}

void CTomuMessageData::setResidence(unsigned int Residence_Data)
{
	this->TomuMessage_Residence = Residence_Data;
}

void CTomuMessageData::setFrequencySec(unsigned long long FrequencySec_Data)
{
	this->TomuMessage_FrequencySec = FrequencySec_Data;
}

void CTomuMessageData::getMsgID(unsigned long long* MsgID_Data)
{
	if(MsgID_Data != NULL) {
		*MsgID_Data = this->TomuMessage_MsgID;
	}

}

void CTomuMessageData::getStaticSensorID(unsigned long long* StaticSensorID_Data)
{
	if(StaticSensorID_Data != NULL) {
		*StaticSensorID_Data = this->TomuMessage_StaticSensorID;
	}

}

unsigned long long CTomuMessageData::getSeqNum()
{
	return this->TomuMessage_Seq;
}




void CTomuMessageData::compile()
{

	char XMLTomuMessage[LEN_TEXT_4K];


	// BEGIN : Head
	char XMLHead[LEN_TEXT_1K];

	char XMLMsgType[LEN_STR];
	char XMLMsgID[LEN_STR];
	char XMLMsgDest[LEN_STR];
	char XMLMsgSrc[LEN_STR];
	char StringMsgType[LEN_STR];
	char StringMsgID[LEN_STR];
	char StringMsgDest[LEN_STR];
	char StringMsgSrc[LEN_STR];
	// END   : Head


	// BEGIN : Upload
	char XMLUpload[LEN_TEXT_2K];

	char XMLSeq[LEN_STR];
	char StringSeq[LEN_STR];

	// BEGIN : Upload - SensorSourceDataResponse
	char XMLSensorSourceDataResponse[LEN_TEXT_2K];

	// BEGIN : Upload - SensorSourceDataResponse - StaticSensorData
	char XMLStaticSensorData[LEN_TEXT_2K];

	char XMLType[LEN_STR];
	char XMLSensedTime[LEN_STR];
	char XMLStaticSensorID[LEN_STR];
	char StringType[LEN_STR];
	char StringSensedTime[LEN_STR];
	char StringStaticSensorID[LEN_STR];

	char XMLValue[LEN_TEXT_2K];


	char XMLFrequency[LEN_STR];
	char XMLFrequencySec[LEN_STR];
	char StringFrequencySec[LEN_STR];


	// BEGIN : Upload - SensorSourceDataResponse - StaticSensorData - Value - StreetPedestrianFlowValue
	char XMLStreetPedestrianFlowValue[LEN_TEXT_2K];

	char XMLMeasurementTimeSec[LEN_STR];
	char StringMeasurementTimeSec[LEN_STR];

	char XMLChiefAxis_PlusTag_Compass[LEN_STR];
	char XMLChiefAxis_PlusTag_Num[LEN_STR];
	char XMLChiefAxis_PlusTag_AvgSpeed[LEN_STR];
	char XMLChiefAxis_PlusTag[LEN_TEXT_1K];
	char XMLChiefAxis_MinusTag_Compass[LEN_STR];
	char XMLChiefAxis_MinusTag_Num[LEN_STR];
	char XMLChiefAxis_MinusTag_AvgSpeed[LEN_STR];
	char XMLChiefAxis_MinusTag[LEN_TEXT_1K];
	char XMLChiefAxis[LEN_TEXT_1K];
	char StringChiefAxis_PlusTag_Compass[LEN_STR];
	char StringChiefAxis_PlusTag_Num[LEN_STR];
	char StringChiefAxis_PlusTag_AvgSpeed[LEN_STR];
	char StringChiefAxis_MinusTag_Compass[LEN_STR];
	char StringChiefAxis_MinusTag_Num[LEN_STR];
	char StringChiefAxis_MinusTag_AvgSpeed[LEN_STR];

	char XMLSubAxis_PlusTag_Compass[LEN_STR];
	char XMLSubAxis_PlusTag_Num[LEN_STR];
	char XMLSubAxis_PlusTag_AvgSpeed[LEN_STR];
	char XMLSubAxis_PlusTag[LEN_TEXT_1K];
	char XMLSubAxis_MinusTag_Compass[LEN_STR];
	char XMLSubAxis_MinusTag_Num[LEN_STR];
	char XMLSubAxis_MinusTag_AvgSpeed[LEN_STR];
	char XMLSubAxis_MinusTag[LEN_TEXT_1K];
	char XMLSubAxis[LEN_TEXT_1K];
	char StringSubAxis_PlusTag_Compass[LEN_STR];
	char StringSubAxis_PlusTag_Num[LEN_STR];
	char StringSubAxis_PlusTag_AvgSpeed[LEN_STR];
	char StringSubAxis_MinusTag_Compass[LEN_STR];
	char StringSubAxis_MinusTag_Num[LEN_STR];
	char StringSubAxis_MinusTag_AvgSpeed[LEN_STR];

	char XMLResidence[LEN_STR];
	char StringResidence[LEN_STR];
	// END   : Upload - SensorSourceDataResponse - StaticSensorData - Value - StreetPedestrianFlowValue
	// END   : Upload - SensorSourceDataResponse - StaticSensorData
	// END   : Upload - SensorSourceDataResponse
	// END   : Upload

	const char* TEXT_InterPedestrian = "INTER_PEDESTRIAN";
	const char* TEXT_Pedestrian = "PEDESTRIAN";

	//double Inum, Fnum; // p
	char RealNumber[LEN_STR];
	int i;
	int ElementDot;

	// Make MsgID (from Current UNIX Time)
	char MsgIDTEXT[LEN_STR];

	// Use time 64bit version (OS ver(32/64bit) independent)
	__time64_t ltime;
	_time64(&ltime);
	sprintf_s(MsgIDTEXT, sizeof(MsgIDTEXT), "%ld", ltime);

	//this->setMsgID(MsgIDTEXT);
	this->setMsgID((unsigned long long)ltime * 1000 + rangedRand(0,999));

	// Make String_Value
	sprintf_s(StringMsgType, sizeof(StringMsgType), "%s", this->TomuMessage_MsgType);
	//sprintf_s(StringMsgID, sizeof(StringMsgID), "%s", this->TomuMessage_MsgID);
	//sprintf_s(StringMsgID, sizeof(StringMsgID), "%ld", this->TomuMessage_MsgID);
	sprintf_s(StringMsgID, sizeof(StringMsgID), "%I64u", this->TomuMessage_MsgID);
	//sprintf_s(StringMsgID, sizeof(StringMsgID), "%ld000", this->TomuMessage_MsgID);
	sprintf_s(StringMsgDest, sizeof(StringMsgDest), "%s", this->TomuMessage_MsgDest);
	sprintf_s(StringMsgSrc, sizeof(StringMsgSrc), "%s", this->TomuMessage_MsgSrc);

	//sprintf_s(StringSeq, sizeof(StringSeq), "%d", this->TomuMessage_Seq);
	//sprintf_s(StringSeq, sizeof(StringSeq), "%ld", this->TomuMessage_Seq);
	sprintf_s(StringSeq, sizeof(StringSeq), "%I64u", this->TomuMessage_Seq);

	if(this->TomuMessage_Type == this->InterPedestrian) {
		sprintf_s(StringType, sizeof(StringType), "%s", TEXT_InterPedestrian);
	} else if(this->TomuMessage_Type == this->Pedestrian) {
		sprintf_s(StringType, sizeof(StringType), "%s", TEXT_Pedestrian);	
	} else {
		sprintf_s(StringType, sizeof(StringType), "");	
	
	}
	//sprintf_s(StringType, sizeof(StringType), "%s", this->TomuMessage_Type);

	//sprintf_s(StringSensedTime, sizeof(StringSensedTime), "%s", this->TomuMessage_SensedTime);
	//sprintf_s(StringSensedTime, sizeof(StringSensedTime), "%ld", this->TomuMessage_SensedTime);
	sprintf_s(StringSensedTime, sizeof(StringSensedTime), "%I64u", this->TomuMessage_SensedTime);
	//sprintf_s(StringSensedTime, sizeof(StringSensedTime), "%ld000", this->TomuMessage_SensedTime);
	//sprintf_s(StringStaticSensorID, sizeof(StringStaticSensorID), "%s", this->TomuMessage_StaticSensorID);
	//sprintf_s(StringStaticSensorID, sizeof(StringStaticSensorID), "%ld", this->TomuMessage_StaticSensorID);
	sprintf_s(StringStaticSensorID, sizeof(StringStaticSensorID), "%I64u", this->TomuMessage_StaticSensorID);
	//sprintf_s(StringStaticSensorID, sizeof(StringStaticSensorID), "%ld000", this->TomuMessage_StaticSensorID);

	//sprintf_s(StringMeasurementTimeSec, sizeof(StringMeasurementTimeSec), "%d", this->TomuMessage_MeasurementTimeSec);
	//sprintf_s(StringMeasurementTimeSec, sizeof(StringMeasurementTimeSec), "%ld", this->TomuMessage_MeasurementTimeSec);
	sprintf_s(StringMeasurementTimeSec, sizeof(StringMeasurementTimeSec), "%I64u", this->TomuMessage_MeasurementTimeSec);
	//sprintf_s(StringMeasurementTimeSec, sizeof(StringMeasurementTimeSec), "%ld000", this->TomuMessage_MeasurementTimeSec);

	//sprintf_s(StringFrequencySec, sizeof(StringFrequencySec), "%ld", this->TomuMessage_FrequencySec);
	sprintf_s(StringFrequencySec, sizeof(StringFrequencySec), "%I64u", this->TomuMessage_FrequencySec);


	sprintf_s(StringChiefAxis_PlusTag_Compass, sizeof(StringChiefAxis_PlusTag_Compass), "%d", this->TomuMessage_ChiefAxis_PlusTag_Compass);

	sprintf_s(StringChiefAxis_PlusTag_Num, sizeof(StringChiefAxis_PlusTag_Num), "%d", this->TomuMessage_ChiefAxis_PlusTag_Num);

	//sprintf_s(StringChiefAxis_PlusTag_AvgSpeed, sizeof(StringChiefAxis_PlusTag_AvgSpeed), "%lf", this->TomuMessage_ChiefAxis_PlusTag_AvgSpeed);
	sprintf_s(RealNumber, sizeof(RealNumber), "%lf", this->TomuMessage_ChiefAxis_PlusTag_AvgSpeed);
	ElementDot = -1;
	for(i=0; i<(int)(strlen(RealNumber)); i++) {
		StringChiefAxis_PlusTag_AvgSpeed[i] = RealNumber[i];
		if(RealNumber[i] == '.') {
			ElementDot = i;
			break;
		}
	}
	if(ElementDot != -1) {
		StringChiefAxis_PlusTag_AvgSpeed[i] = '#';
		StringChiefAxis_PlusTag_AvgSpeed[i+1] = 'd';
		StringChiefAxis_PlusTag_AvgSpeed[i+2] = 'o';
		StringChiefAxis_PlusTag_AvgSpeed[i+3] = 't';
		StringChiefAxis_PlusTag_AvgSpeed[i+4] = ';';

		for(i++;i<(int)(strlen(RealNumber));i++) {
			StringChiefAxis_PlusTag_AvgSpeed[i+4] = RealNumber[i];
		}
		StringChiefAxis_PlusTag_AvgSpeed[i+4] = '\0';
	}
	else {
		StringChiefAxis_PlusTag_AvgSpeed[i] = '\0';
	}

	sprintf_s(StringChiefAxis_MinusTag_Compass, sizeof(StringChiefAxis_MinusTag_Compass), "%d", this->TomuMessage_ChiefAxis_MinusTag_Compass);

	sprintf_s(StringChiefAxis_MinusTag_Num, sizeof(StringChiefAxis_MinusTag_Num), "%d", this->TomuMessage_ChiefAxis_MinusTag_Num);

	//sprintf_s(StringChiefAxis_MinusTag_AvgSpeed, sizeof(StringChiefAxis_MinusTag_AvgSpeed), "%lf", this->TomuMessage_ChiefAxis_MinusTag_AvgSpeed);
	sprintf_s(RealNumber, sizeof(RealNumber), "%lf", this->TomuMessage_ChiefAxis_MinusTag_AvgSpeed);
	ElementDot = -1;
	for(i=0; i<(int)(strlen(RealNumber)); i++) {
		StringChiefAxis_MinusTag_AvgSpeed[i] = RealNumber[i];
		if(RealNumber[i] == '.') {
			ElementDot = i;
			break;
		}
	}
	if(ElementDot != -1) {
		StringChiefAxis_MinusTag_AvgSpeed[i] = '#';
		StringChiefAxis_MinusTag_AvgSpeed[i+1] = 'd';
		StringChiefAxis_MinusTag_AvgSpeed[i+2] = 'o';
		StringChiefAxis_MinusTag_AvgSpeed[i+3] = 't';
		StringChiefAxis_MinusTag_AvgSpeed[i+4] = ';';

		for(i++;i<(int)(strlen(RealNumber));i++) {
			StringChiefAxis_MinusTag_AvgSpeed[i+4] = RealNumber[i];
		}
		StringChiefAxis_MinusTag_AvgSpeed[i+4] = '\0';
	}
	else {
		StringChiefAxis_MinusTag_AvgSpeed[i] = '\0';
	}

	if(this->TomuMessage_Type == this->InterPedestrian) {

		sprintf_s(StringSubAxis_PlusTag_Compass, sizeof(StringSubAxis_PlusTag_Compass), "%d", this->TomuMessage_SubAxis_PlusTag_Compass);

		sprintf_s(StringSubAxis_PlusTag_Num, sizeof(StringSubAxis_PlusTag_Num), "%d", this->TomuMessage_SubAxis_PlusTag_Num);

		//sprintf_s(StringSubAxis_PlusTag_AvgSpeed, sizeof(StringSubAxis_PlusTag_AvgSpeed), "%lf", this->TomuMessage_SubAxis_PlusTag_AvgSpeed);
		sprintf_s(RealNumber, sizeof(RealNumber), "%lf", this->TomuMessage_SubAxis_PlusTag_AvgSpeed);
		ElementDot = -1;
		for(i=0; i<(int)(strlen(RealNumber)); i++) {
			StringSubAxis_PlusTag_AvgSpeed[i] = RealNumber[i];
			if(RealNumber[i] == '.') {
				ElementDot = i;
				break;
			}
		}
		if(ElementDot != -1) {
			StringSubAxis_PlusTag_AvgSpeed[i] = '#';
			StringSubAxis_PlusTag_AvgSpeed[i+1] = 'd';
			StringSubAxis_PlusTag_AvgSpeed[i+2] = 'o';
			StringSubAxis_PlusTag_AvgSpeed[i+3] = 't';
			StringSubAxis_PlusTag_AvgSpeed[i+4] = ';';

			for(i++;i<(int)(strlen(RealNumber));i++) {
				StringSubAxis_PlusTag_AvgSpeed[i+4] = RealNumber[i];
			}
			StringSubAxis_PlusTag_AvgSpeed[i+4] = '\0';
		}
		else {
			StringSubAxis_PlusTag_AvgSpeed[i] = '\0';
		}

		sprintf_s(StringSubAxis_MinusTag_Compass, sizeof(StringSubAxis_MinusTag_Compass), "%d", this->TomuMessage_SubAxis_MinusTag_Compass);

		sprintf_s(StringSubAxis_MinusTag_Num, sizeof(StringSubAxis_MinusTag_Num), "%d", this->TomuMessage_SubAxis_MinusTag_Num);

		//sprintf_s(StringSubAxis_MinusTag_AvgSpeed, sizeof(StringSubAxis_MinusTag_AvgSpeed), "%lf", this->TomuMessage_SubAxis_MinusTag_AvgSpeed);
		sprintf_s(RealNumber, sizeof(RealNumber), "%lf", this->TomuMessage_SubAxis_MinusTag_AvgSpeed);
		ElementDot = -1;
		for(i=0; i<(int)(strlen(RealNumber)); i++) {
			StringSubAxis_MinusTag_AvgSpeed[i] = RealNumber[i];
			if(RealNumber[i] == '.') {
				ElementDot = i;
				break;
			}
		}
		if(ElementDot != -1) {
			StringSubAxis_MinusTag_AvgSpeed[i] = '#';
			StringSubAxis_MinusTag_AvgSpeed[i+1] = 'd';
			StringSubAxis_MinusTag_AvgSpeed[i+2] = 'o';
			StringSubAxis_MinusTag_AvgSpeed[i+3] = 't';
			StringSubAxis_MinusTag_AvgSpeed[i+4] = ';';

			for(i++;i<(int)(strlen(RealNumber));i++) {
				StringSubAxis_MinusTag_AvgSpeed[i+4] = RealNumber[i];
			}
			StringSubAxis_MinusTag_AvgSpeed[i+4] = '\0';
		}
		else {
			StringSubAxis_MinusTag_AvgSpeed[i] = '\0';
		}
	}

	sprintf_s(StringResidence, sizeof(StringResidence), "%d", this->TomuMessage_Residence);



	// TomuMessage Head -> MsgType, MsgID, MsgDest, MsgSrc
	sprintf_s(XMLMsgType, sizeof(XMLMsgType), "<MsgType>%s</MsgType>", StringMsgType);
	sprintf_s(XMLMsgID, sizeof(XMLMsgID), "<MsgId>%s</MsgId>", StringMsgID);
	sprintf_s(XMLMsgDest, sizeof(XMLMsgDest), "<MsgDest>%s</MsgDest>", StringMsgDest);
	sprintf_s(XMLMsgSrc, sizeof(XMLMsgSrc), "<MsgSrc>%s</MsgSrc>", StringMsgSrc);
	sprintf_s(XMLHead, sizeof(XMLHead), "<Head>%s%s%s%s</Head>", XMLMsgType, XMLMsgID, XMLMsgDest, XMLMsgSrc);


	// TomuMessage Upload -> Seq, SensorSourceDataResponse
	sprintf_s(XMLSeq, sizeof(XMLSeq), "<Seq>%s</Seq>", StringSeq);

	sprintf_s(XMLType, sizeof(XMLType), "<Type>%s</Type>", StringType);
	sprintf_s(XMLSensedTime, sizeof(XMLSensedTime), "<SensedTime>%s</SensedTime>", StringSensedTime);
	sprintf_s(XMLStaticSensorID, sizeof(XMLStaticSensorID), "<StaticSensorID>%s</StaticSensorID>", StringStaticSensorID);


	sprintf_s(XMLMeasurementTimeSec, sizeof(XMLMeasurementTimeSec), "<MeasurementTimeSec>%s</MeasurementTimeSec>", StringMeasurementTimeSec);

	sprintf_s(XMLChiefAxis_PlusTag_Compass, sizeof(XMLChiefAxis_PlusTag_Compass), "<Compass>%s</Compass>", StringChiefAxis_PlusTag_Compass);
	sprintf_s(XMLChiefAxis_PlusTag_Num, sizeof(XMLChiefAxis_PlusTag_Num), "<Num>%s</Num>", StringChiefAxis_PlusTag_Num);
	//sprintf_s(XMLChiefAxis_PlusTag_AvgSpeed, sizeof(XMLChiefAxis_PlusTag_AvgSpeed), "<AvgSpeed>%s</AvgSpeed>", StringChiefAxis_PlusTag_AvgSpeed);
	//sprintf_s(XMLChiefAxis_PlusTag_AvgSpeed, sizeof(XMLChiefAxis_PlusTag_AvgSpeed), "<AverageSpeed>%s</AverageSpeed>", StringChiefAxis_PlusTag_AvgSpeed);
	sprintf_s(XMLChiefAxis_PlusTag_AvgSpeed, sizeof(XMLChiefAxis_PlusTag_AvgSpeed), "<AverageSpeed><MeterperSecond>%s</MeterperSecond></AverageSpeed>", StringChiefAxis_PlusTag_AvgSpeed);
	sprintf_s(XMLChiefAxis_PlusTag, sizeof(XMLChiefAxis_PlusTag), "<Plus>%s%s%s</Plus>", XMLChiefAxis_PlusTag_Compass, XMLChiefAxis_PlusTag_Num, XMLChiefAxis_PlusTag_AvgSpeed);
	sprintf_s(XMLChiefAxis_MinusTag_Compass, sizeof(XMLChiefAxis_MinusTag_Compass), "<Compass>%s</Compass>", StringChiefAxis_MinusTag_Compass);
	sprintf_s(XMLChiefAxis_MinusTag_Num, sizeof(XMLChiefAxis_MinusTag_Num), "<Num>%s</Num>", StringChiefAxis_MinusTag_Num);
	//sprintf_s(XMLChiefAxis_MinusTag_AvgSpeed, sizeof(XMLChiefAxis_MinusTag_AvgSpeed), "<AvgSpeed>%s</AvgSpeed>", StringChiefAxis_MinusTag_AvgSpeed);
	//sprintf_s(XMLChiefAxis_MinusTag_AvgSpeed, sizeof(XMLChiefAxis_MinusTag_AvgSpeed), "<AverageSpeed>%s</AverageSpeed>", StringChiefAxis_MinusTag_AvgSpeed);
	sprintf_s(XMLChiefAxis_MinusTag_AvgSpeed, sizeof(XMLChiefAxis_MinusTag_AvgSpeed), "<AverageSpeed><MeterperSecond>%s</MeterperSecond></AverageSpeed>", StringChiefAxis_MinusTag_AvgSpeed);
	sprintf_s(XMLChiefAxis_MinusTag, sizeof(XMLChiefAxis_MinusTag), "<Minus>%s%s%s</Minus>", XMLChiefAxis_MinusTag_Compass, XMLChiefAxis_MinusTag_Num, XMLChiefAxis_MinusTag_AvgSpeed);
	sprintf_s(XMLChiefAxis, sizeof(XMLChiefAxis), "<ChiefAxis>%s%s</ChiefAxis>", XMLChiefAxis_PlusTag, XMLChiefAxis_MinusTag);



	if(this->TomuMessage_Type == this->InterPedestrian) {

		sprintf_s(XMLSubAxis_PlusTag_Compass, sizeof(XMLSubAxis_PlusTag_Compass), "<Compass>%s</Compass>", StringSubAxis_PlusTag_Compass);
		sprintf_s(XMLSubAxis_PlusTag_Num, sizeof(XMLSubAxis_PlusTag_Num), "<Num>%s</Num>", StringSubAxis_PlusTag_Num);
		//sprintf_s(XMLSubAxis_PlusTag_AvgSpeed, sizeof(XMLSubAxis_PlusTag_AvgSpeed), "<AvgSpeed>%s</AvgSpeed>", StringSubAxis_PlusTag_AvgSpeed);
		//sprintf_s(XMLSubAxis_PlusTag_AvgSpeed, sizeof(XMLSubAxis_PlusTag_AvgSpeed), "<AverageSpeed>%s</AverageSpeed>", StringSubAxis_PlusTag_AvgSpeed);
		sprintf_s(XMLSubAxis_PlusTag_AvgSpeed, sizeof(XMLSubAxis_PlusTag_AvgSpeed), "<AverageSpeed><MeterperSecond>%s</MeterperSecond></AverageSpeed>", StringSubAxis_PlusTag_AvgSpeed);

		sprintf_s(XMLSubAxis_PlusTag, sizeof(XMLSubAxis_PlusTag), "<Plus>%s%s%s</Plus>", XMLSubAxis_PlusTag_Compass, XMLSubAxis_PlusTag_Num, XMLSubAxis_PlusTag_AvgSpeed);
		sprintf_s(XMLSubAxis_MinusTag_Compass, sizeof(XMLSubAxis_MinusTag_Compass), "<Compass>%s</Compass>", StringSubAxis_MinusTag_Compass);
		sprintf_s(XMLSubAxis_MinusTag_Num, sizeof(XMLSubAxis_MinusTag_Num), "<Num>%s</Num>", StringSubAxis_MinusTag_Num);
		//sprintf_s(XMLSubAxis_MinusTag_AvgSpeed, sizeof(XMLSubAxis_MinusTag_AvgSpeed), "<AvgSpeed>%s</AvgSpeed>", StringSubAxis_MinusTag_AvgSpeed);
		//sprintf_s(XMLSubAxis_MinusTag_AvgSpeed, sizeof(XMLSubAxis_MinusTag_AvgSpeed), "<AverageSpeed>%s</AverageSpeed>", StringSubAxis_MinusTag_AvgSpeed);
		sprintf_s(XMLSubAxis_MinusTag_AvgSpeed, sizeof(XMLSubAxis_MinusTag_AvgSpeed), "<AverageSpeed><MeterperSecond>%s</MeterperSecond></AverageSpeed>", StringSubAxis_MinusTag_AvgSpeed);
		sprintf_s(XMLSubAxis_MinusTag, sizeof(XMLSubAxis_MinusTag), "<Minus>%s%s%s</Minus>", XMLSubAxis_MinusTag_Compass, XMLSubAxis_MinusTag_Num, XMLSubAxis_MinusTag_AvgSpeed);
		sprintf_s(XMLSubAxis, sizeof(XMLSubAxis), "<SubAxis>%s%s</SubAxis>", XMLSubAxis_PlusTag, XMLSubAxis_MinusTag);
	}

	sprintf_s(XMLResidence, sizeof(XMLResidence), "<Residence>%s</Residence>", StringResidence);


	if(this->TomuMessage_Type == this->InterPedestrian) {
		sprintf_s(XMLStreetPedestrianFlowValue, sizeof(XMLStreetPedestrianFlowValue), "<StreetPedestrianFlowValue>%s%s%s%s</StreetPedestrianFlowValue>", XMLMeasurementTimeSec, XMLChiefAxis, XMLSubAxis, XMLResidence);
	} else if (this->TomuMessage_Type == this->Pedestrian) {
		sprintf_s(XMLStreetPedestrianFlowValue, sizeof(XMLStreetPedestrianFlowValue), "<StreetPedestrianFlowValue>%s%s%s</StreetPedestrianFlowValue>", XMLMeasurementTimeSec, XMLChiefAxis, XMLResidence);	
	}
	sprintf_s(XMLValue, sizeof(XMLValue), "<Value>%s</Value>", XMLStreetPedestrianFlowValue);

	sprintf_s(XMLStaticSensorData, sizeof(XMLStaticSensorData), "<StaticSensorData>%s%s%s%s</StaticSensorData>", XMLType, XMLSensedTime, XMLStaticSensorID, XMLValue);

	sprintf_s(XMLFrequencySec, sizeof(XMLFrequencySec), "<Sec>%s</Sec>", StringFrequencySec);
	sprintf_s(XMLFrequency, sizeof(XMLFrequency), "<Frequency>%s</Frequency>", XMLFrequencySec);

	//sprintf_s(XMLSensorSourceDataResponse, sizeof(XMLSensorSourceDataResponse), "<SensorSourceDataResponse>%s</SensorSourceDataResponse>", XMLStaticSensorData);
	sprintf_s(XMLSensorSourceDataResponse, sizeof(XMLSensorSourceDataResponse), "<SensorSourceDataResponse>%s%s</SensorSourceDataResponse>", XMLStaticSensorData, XMLFrequency);

	sprintf_s(XMLUpload, sizeof(XMLUpload), "<Upload>%s%s</Upload>", XMLSeq, XMLSensorSourceDataResponse);

	const char* XMLTEXT_Header = "<\?xml version=\"1#dot;0\" encoding=\"UTF-8\" standalone=\"yes\"\?>";
	sprintf_s(XMLTomuMessage, sizeof(XMLTomuMessage), "<TomuMessage>%s%s</TomuMessage>", XMLHead,XMLUpload);
	//sprintf_s(XMLTomuMessage, sizeof(XMLTomuMessage), "%s<TomuMessage>%s%s</TomuMessage>", XMLTEXT_Header, XMLHead,XMLUpload);

	strcpy_s(this->XMLDataTomuMessage, sizeof(XMLTomuMessage), XMLTomuMessage);


#ifdef DBBUG_LOG_TOMUMESSAGEDATA
	FILE* fp;

	if(fopen_s(&fp, "log.xml","w") == 0) { // Success!
		fprintf(fp,"%s",XMLTomuMessage);
		fclose(fp);
	}
#endif
}

void CTomuMessageData::incrementSeq() 
{
	this->SequenceNumber ++;
	this->TomuMessage_Seq ++;

}

int CTomuMessageData::getTomuMessageTEXT(char* TomuMessage_Data, size_t SizeOfTomuMessage_Data)
{
	if(SizeOfTomuMessage_Data < strlen(this->XMLDataTomuMessage) + 1) {
		return -1;
	} else {
		strcpy_s(TomuMessage_Data, sizeof(this->XMLDataTomuMessage), this->XMLDataTomuMessage);
	}

	return 0;
}


