// TomuDBAccessFromStereoCamera.cpp : DLL AvP[VpɃGNX|[g֐`܂B
//
#include "stdafx.h"

#include "TomuDBAccessFromStereoCamera.h"

#include "TomuMessageData.h"
#include "TomuAccessByGloox.h"

CTomuMessageData StereoCameraData;
CTomuAccessByGloox TomuAccess;

// ́AGNX|[gꂽNX̃RXgN^łB
// NX`ɊւĂ TomuDBAccessFromStereoCamera.h QƂĂB
CTomuDBAccessFromStereoCamera::CTomuDBAccessFromStereoCamera()
{
	return;
}



	//// Session Start/Stop Method ////
int CTomuDBAccessFromStereoCamera::startSession()
{
	return TomuAccess.startSession();
}

int CTomuDBAccessFromStereoCamera::stopSession()
{
	return TomuAccess.stopSession();
}

void CTomuDBAccessFromStereoCamera::setType_InterPedestrian()
{
	StereoCameraData.setTypeStaticSensorData(StereoCameraData.InterPedestrian);
}

void CTomuDBAccessFromStereoCamera::setType_Pedestrian()
{
	StereoCameraData.setTypeStaticSensorData(StereoCameraData.Pedestrian);
}

//void CTomuDBAccessFromStereoCamera::setSensedTime(unsigned int tYear, unsigned int tMonth, unsigned int tDay, unsigned int tHour, unsigned int tMinute, unsigned int tSecond)
//void CTomuDBAccessFromStereoCamera::setSensedTime(long SensedTime_Data)
void CTomuDBAccessFromStereoCamera::setSensedTime(unsigned long long SensedTime_Data)
{
	//StereoCameraData.setSensedTime(tYear, tMonth, tDay, tHour, tMinute, tSecond);
	StereoCameraData.setSensedTime(SensedTime_Data);
}

//void CTomuDBAccessFromStereoCamera::setStaticSensorID(char* StaticSensorID_Data) 
void CTomuDBAccessFromStereoCamera::setStaticSensorID(unsigned long long StaticSensorID_Data)
{
	StereoCameraData.setStaticSensorID(StaticSensorID_Data);
}

//void CTomuDBAccessFromStereoCamera::setMeasurementTimeSec(unsigned int MeasurementTimeSec_Data)
void CTomuDBAccessFromStereoCamera::setMeasurementTimeSec(unsigned long long MeasurementTimeSec_Data)
{
	StereoCameraData.setMeasurementTimeSec(MeasurementTimeSec_Data);
}

//void CTomuDBAccessFromStereoCamera::setChiefAxis(double Plus_Compass, unsigned int Plus_Num, double Plus_AvgSpeed, double Minus_Compass, unsigned int Minus_Num, double Minus_AvgSpeed)
void CTomuDBAccessFromStereoCamera::setChiefAxis(int Plus_Compass, unsigned int Plus_Num, double Plus_AvgSpeed, int Minus_Compass, unsigned int Minus_Num, double Minus_AvgSpeed)
{
	StereoCameraData.setChiefAxis(Plus_Compass, Plus_Num, Plus_AvgSpeed, Minus_Compass, Minus_Num, Minus_AvgSpeed);
}

//void CTomuDBAccessFromStereoCamera::setSubAxis(double Plus_Compass, unsigned int Plus_Num, double Plus_AvgSpeed, double Minus_Compass, unsigned int Minus_Num, double Minus_AvgSpeed)
void CTomuDBAccessFromStereoCamera::setSubAxis(int Plus_Compass, unsigned int Plus_Num, double Plus_AvgSpeed, int Minus_Compass, unsigned int Minus_Num, double Minus_AvgSpeed)
{
	StereoCameraData.setSubAxis(Plus_Compass, Plus_Num, Plus_AvgSpeed, Minus_Compass, Minus_Num, Minus_AvgSpeed);
}

void CTomuDBAccessFromStereoCamera::setResidence(unsigned int Residence_Data)
{
	StereoCameraData.setResidence(Residence_Data);
}

void CTomuDBAccessFromStereoCamera::setFrequencySec(unsigned long long FrequencySec_Data)
{
	StereoCameraData.setFrequencySec(FrequencySec_Data);
}


void CTomuDBAccessFromStereoCamera::store()
{

	char fname[] = "ConfigData.txt";
	const int len_account_column = 256;
	char buffer[len_account_column];

	char logXMLInfo[len_account_column];


	FILE* fp;
	bool FlagFailedReadAccountInfo = false;

	bool FlagLogXML = false;

	if(fopen_s(&fp, fname, "r") == 0) // Success!
	{
		if( FlagFailedReadAccountInfo == false ) {
			if( fgets(buffer, sizeof(buffer), fp) != NULL) {
			} else {
				FlagFailedReadAccountInfo = true;			
				//return;				
			}
		}
		if( FlagFailedReadAccountInfo == false ) {
			if( fgets(buffer, sizeof(buffer), fp) != NULL) {
			} else {
				FlagFailedReadAccountInfo = true;			
				//return;				
			}
		}
		if( FlagFailedReadAccountInfo == false ) {
			if( fgets(buffer, sizeof(buffer), fp) != NULL) {
			} else {
				FlagFailedReadAccountInfo = true;
				//return;							
			}
		}
		if( FlagFailedReadAccountInfo == false ) {
			if( fgets(buffer, sizeof(buffer), fp) != NULL) {
			} else {
				FlagFailedReadAccountInfo = true;
				//return;							
			}
		}
		if( FlagFailedReadAccountInfo == false ) {
			if( fgets(buffer, sizeof(buffer), fp) != NULL) {
			} else {
				FlagFailedReadAccountInfo = true;
				//return;							
			}
		}
		if( FlagFailedReadAccountInfo == false ) {
			if( fgets(buffer, sizeof(buffer), fp) != NULL) {
				sscanf_s(buffer, "%s", logXMLInfo, sizeof(logXMLInfo));
				if(strcmp(logXMLInfo, "LOG_XML") == 0) {
					FlagLogXML = true;
				}

			} else {
				FlagFailedReadAccountInfo = true;
				//return;							
			}
		}

		fclose(fp);
		
	} else {
		FlagFailedReadAccountInfo = true;
		//return;
	}



	char XMLTomuMessage[LEN_TEXT_4K];

	StereoCameraData.compile();
	StereoCameraData.getTomuMessageTEXT(XMLTomuMessage, sizeof(XMLTomuMessage));
	TomuAccess.send(XMLTomuMessage);

	if(FlagLogXML == true) {
		char logXMLFile[256];
		unsigned long long MsgID_Data;
		unsigned long long StaticSensorID_Data;
		StereoCameraData.getMsgID(&MsgID_Data);
		StereoCameraData.getStaticSensorID(&StaticSensorID_Data);
		sprintf_s(logXMLFile, sizeof(logXMLFile), "TomuMessage_%I64u_%I64u.xml", StaticSensorID_Data, MsgID_Data);
		//sprintf_s(logXMLFile, sizeof(logXMLFile), "TomuMessage_%I64u_%I64u.xml", MsgID_Data, StaticSensorID_Data);
		if(fopen_s(&fp, logXMLFile, "w") == 0) // Success!
		{
			fprintf(fp, "%s", XMLTomuMessage);
			fclose(fp);
		}

	}

	StereoCameraData.incrementSeq();

	return;
}








unsigned long long CTomuDBAccessFromStereoCamera::getSeqNum()
{
	return StereoCameraData.getSeqNum();
}

//void CTomuDBAccessFromStereoCamera::ping()
//{
//	TomuAccess.ping();
//}
