#include "TomuAccessLenString.h"

#ifndef TOMU_ACCESS_BY_GLOOX
#define TOMU_ACCESS_BY_GLOOX
#include <gloox/client.h>
#include <gloox/messagehandler.h>
#include <gloox/message.h>
#include <gloox/connectionlistener.h>
#include <gloox/messagesession.h>

#pragma comment(lib, "gloox 1.0.lib")

using namespace gloox;
#endif

#ifndef DEBUG_COMMUNICATION_GLOOX
#define DEBUG_COMMUNICATION_GLOOX
#define NODEBUG_MODE 0
#define DEBUG_MODE 1
#define DEBUG_CONSOLE_MODE 1
#define DEBUG_LOG_MODE 2
#define DEBUG_CONSOLE_LOG_MODE 3 
#define DEBUG_LOG_FILENAME "debug_log.txt"
#endif

void gloox_thread_session_start(LPVOID pParam);

class Bot : public gloox::ConnectionListener
{
public:
	// Constructor
	Bot(const std::string& Account, const std::string& Passwd, const std::string& DestAccount, const std::string& MessageDATA, const bool FlagDebugMode_DATA) : client_(gloox::JID(Account), Passwd) {
		const char* messageData_cptr = MessageDATA.c_str();
		strcpy_s(MessageTEXT, sizeof(MessageTEXT), messageData_cptr);
		this->FlagDebugMode = FlagDebugMode_DATA;

		client_.registerConnectionListener(this);
		client_.setServer("talk.google.com");
		session_ = new gloox::MessageSession(&client_, gloox::JID(DestAccount));

		if(this->FlagDebugMode == DEBUG_MODE) {
			printf("SESSION Start!\n");
		}
		if( client_.connect() == false ) {
			if(this->FlagDebugMode == DEBUG_MODE) {
				printf("SESSION failed!\n");
			}
			client_.disconnect();
		}
    }


    virtual void onConnect() {

        session_->send(MessageTEXT, "SOURCE_UPLOAD");
		if(this->FlagDebugMode == DEBUG_MODE) {
			printf("DATA send!\n");
			printf("%s\n", MessageTEXT);
		}
        client_.disconnect();
		if(this->FlagDebugMode == DEBUG_MODE) {
			printf("SESSION Stop!\n");
		}
    }   

    virtual void onDisconnect(gloox::ConnectionError reason) { } 
    virtual bool onTLSConnect(const gloox::CertInfo &info) { return true; }

private:
    gloox::Client client_;
    gloox::MessageSession* session_;

	char MessageTEXT[LEN_TEXT_4K];
	bool FlagDebugMode;

};

class BotSession : public gloox::ConnectionListener, gloox::MessageHandler
{
public:
	// Constructor
	BotSession() {
		FlagCreatedSession = false;
        //client_.registerConnectionListener(this);
        //client_.setServer("talk.google.com");			
	}

	//BotSession(const std::string& Account, const std::string& Passwd, const std::string& DestAccount, const std::string& MessageDATA, const bool FlagDebugMode_DATA) : client_(gloox::JID(Account), Passwd) {
		//const char* messageData_cptr = MessageDATA.c_str();
		//strcpy_s(MessageTEXT, sizeof(MessageTEXT), messageData_cptr);
		//this->FlagDebugMode = FlagDebugMode_DATA;

  //      client_.registerConnectionListener(this);
  //      client_.setServer("talk.google.com");
  //      session_ = new gloox::MessageSession(&client_, gloox::JID(DestAccount));
		//FlagCreatedSession = false;
    //}

	//int startSession() {	
	//	if(this->FlagDebugMode == DEBUG_MODE) {
	//		printf("SESSION Start!\n");
	//	}
	//	if( client_.connect() == false ) {
	//		if(this->FlagDebugMode == DEBUG_MODE) {
	//			printf("SESSION failed!\n");
	//		}
	//		client_.disconnect();
	//		FlagCreatedSession = false;
	//		return -1;
	//	}

	//	return 0;
	//}

	int startSession(const std::string& Account, const std::string& Passwd, const std::string& DestAccount, const int DebugMode) {

		client_ = new gloox::Client(gloox::JID(Account), Passwd);
		
		this->FlagDebugMode = DebugMode;

        client_->registerConnectionListener(this);
        client_->setServer("talk.google.com");

		session_ = new gloox::MessageSession(client_, gloox::JID(DestAccount));
		FlagCreatedSession = false;

		//if(this->FlagDebugMode == DEBUG_MODE) {
		if(this->FlagDebugMode == DEBUG_MODE || this->FlagDebugMode == DEBUG_CONSOLE_LOG_MODE) {
			printf("SESSION Start!\n");
		}
		if(this->FlagDebugMode == DEBUG_LOG_MODE || this->FlagDebugMode == DEBUG_CONSOLE_LOG_MODE) {
			fopen_s(&fp, DEBUG_LOG_FILENAME, "a");
			fprintf(fp, "SESSION Start!\n");
			fclose(fp);
		}


		if( client_->connect() == false ) {
			//if(this->FlagDebugMode == DEBUG_MODE) {
			if(this->FlagDebugMode == DEBUG_MODE || this->FlagDebugMode == DEBUG_CONSOLE_LOG_MODE) {
				printf("SESSION failed!\n");
			}
			if(this->FlagDebugMode == DEBUG_LOG_MODE || this->FlagDebugMode == DEBUG_CONSOLE_LOG_MODE) {
				fopen_s(&fp, DEBUG_LOG_FILENAME, "a");
				fprintf(fp, "SESSION failed!\n");
				fclose(fp);
			}
			client_->disconnect();
			FlagCreatedSession = false;
			return -1;
		}

		return 0;
	}


	int stopSession() {
		if(client_ != NULL) {
			client_->disconnect();
			delete client_;
			FlagCreatedSession = false;		
		} else {
			FlagCreatedSession = false;				
		}

		//if(this->FlagDebugMode == DEBUG_MODE) {
		if(this->FlagDebugMode == DEBUG_MODE || this->FlagDebugMode == DEBUG_CONSOLE_LOG_MODE) {
			printf("SESSION stop!\n");
		}
		if(this->FlagDebugMode == DEBUG_LOG_MODE || this->FlagDebugMode == DEBUG_CONSOLE_LOG_MODE) {
			fopen_s(&fp, DEBUG_LOG_FILENAME, "a");
			fprintf(fp, "SESSION stop!\n");
			fclose(fp);
		}
		return 0;	
	}

	int send(char* messageText) {
		if(FlagCreatedSession == true) {

			session_->send(messageText, "SOURCE_UPLOAD");
			//if(this->FlagDebugMode == DEBUG_MODE) {
			if(this->FlagDebugMode == DEBUG_MODE || this->FlagDebugMode == DEBUG_CONSOLE_LOG_MODE) {
				printf("DATA sent!\n");
				printf("%s\n", messageText);
			}
			if(this->FlagDebugMode == DEBUG_LOG_MODE || this->FlagDebugMode == DEBUG_CONSOLE_LOG_MODE) {
				fopen_s(&fp, DEBUG_LOG_FILENAME, "a");
				fprintf(fp, "DATA sent!\n");
				fprintf(fp, "%s\n", messageText);
				fclose(fp);
			}
			return 0;
		} else {
			//if(this->FlagDebugMode == DEBUG_MODE) {
			if(this->FlagDebugMode == DEBUG_MODE || this->FlagDebugMode == DEBUG_CONSOLE_LOG_MODE) {
				printf("DATA cannot be sent!\n");
				printf("%s\n", messageText);
			}
			if(this->FlagDebugMode == DEBUG_LOG_MODE || this->FlagDebugMode == DEBUG_CONSOLE_LOG_MODE) {
				fopen_s(&fp, DEBUG_LOG_FILENAME, "a");
				fprintf(fp, "DATA cannot be sent!\n");
				fprintf(fp, "%s\n", messageText);
				fclose(fp);
			}
			return -1;			
		}
	}

	virtual void handleMessage(const gloox::Message& msg, gloox::MessageSession *session) {
        //char* message = utf8_to_str_alloc(msg.body().c_str());
        //displayMessage(message);
        //free(message);
    }


    virtual void onConnect() {
		//if(this->FlagDebugMode == DEBUG_MODE) {
		if(this->FlagDebugMode == DEBUG_MODE || this->FlagDebugMode == DEBUG_CONSOLE_LOG_MODE) {
			printf("SESSION created!\n");
		}
		if(this->FlagDebugMode == DEBUG_LOG_MODE || this->FlagDebugMode == DEBUG_CONSOLE_LOG_MODE) {
			fopen_s(&fp, DEBUG_LOG_FILENAME, "a");
			fprintf(fp, "SESSION created!\n");
			fclose(fp);
		}
		FlagCreatedSession = true;

  //      session_->send(MessageTEXT, "SOURCE_UPLOAD");
		//if(this->FlagDebugMode == DEBUG_MODE) {
		//	printf("DATA send!\n");
		//	printf("%s\n", MessageTEXT);
		//}
  //      client_.disconnect();
		//if(this->FlagDebugMode == DEBUG_MODE) {
		//	printf("SESSION Stop!\n");
		//}
    }   

    virtual void onDisconnect(gloox::ConnectionError reason) { } 
    virtual bool onTLSConnect(const gloox::CertInfo &info) { return true; }

private:
    gloox::Client* client_;
    gloox::MessageSession* session_;

	//char MessageTEXT[LEN_TEXT_4K];
	int FlagDebugMode;
	bool FlagCreatedSession;


	FILE* fp;
};

class CTomuAccessByGloox
{
public:
	CTomuAccessByGloox(void);
	~CTomuAccessByGloox();
	//CTomuAccessByGloox(const std::string& Account, const std::string& Passwd, const std::string& DestAccount, const std::string& MessageDATA, const bool FlagDebugMode_DATA) : bot_session(Account, Passwd, DestAccount, MessageDATA, FlagDebugMode_DATA);
public:
	int startSession();
	int stopSession();
	//int setDebugMode(int DebugMode);
	int send(char* XMLMessage);
	//void ping();
private:
	bool FlagAccessMode;
	bool FlagValidConfigData;

	HANDLE	hThread;

	DWORD threadId;

	//void mainloop();
	//void thread_loop(LPVOID pParam);
	//void thread_loop(void);


	////XbhPAQI҂
	//WaitForMultipleObjects(2,hThread,TRUE,INFINITE);

	////nhN[Y
	//CloseHandle(hThread[0]);
	//CloseHandle(hThread[1]);
	//CloseHandle(hMutex);

	//return 0;





};
