/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package jp.osoite.tomu.net.socks;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Iterator;
import jp.osoite.tomu.core.main.SensorVals;
import jp.osoite.tomu.usml.Config;

/**
 *
 * @author tailor
 */
public class SocketClientSenderOnceLoop implements Runnable{


    
    //public static final String HOSTNAME = "localhost";
    //public static final String HOSTNAME = "192.168.12.9";
    //public static final String HOSTNAME = "192.168.11.2";
    public static final String HOSTNAME = Config.getInstance().getSOCK_FOWARDING_HOST_NAME();
    public static final boolean isForwardPacket=true;
    //192.168.12.9

    //public static final int HOSTPORT = 5555;
    public static final int HOSTPORT = Config.getInstance().getSOCK_FOWARDING_HOST_PORT();
    private SensorVals sVal;

    public SocketClientSenderOnceLoop(SensorVals sVal){
        this.sVal=sVal;
    }


    public void run(){
        if(sVal!=null)
            fire(sVal);
        else
            System.err.println("sval is null at SocketClientSenderOnceLoop");
    }


    public void fire(SensorVals sval){

    try{
      Socket socket = new Socket(HOSTNAME,HOSTPORT);

        ArrayList  alist;
        int MAX=10;

        RemoteMsgBox[] intarray = new RemoteMsgBox[MAX];


        for (int i = 0; i < MAX; i++) {
			intarray[i] = new RemoteMsgBox(""+i+":");
		}

        //List list = Arrays.asList(intarray);
        alist = new ArrayList();

        RemoteMsgBox sobj=new RemoteMsgBox("@once 1");

        //String sql=(new SensorVals()).getSQLInsertStmt("data");
        //sobj.setStmt(sql);
        sobj.setSVal((sval));
        alist.add(sobj);

        Iterator itr = alist.iterator();
		while (itr.hasNext()) {
			RemoteMsgBox sendingobj=(RemoteMsgBox)itr.next();
            System.out.println("send:"+sendingobj.getStmt());
		}

      ObjectOutputStream oos = new ObjectOutputStream( socket.getOutputStream() );
      oos.writeObject(alist);

      ObjectInputStream ois = new ObjectInputStream( socket.getInputStream() );
      alist = (ArrayList)( ois.readObject() );


      //for(String line : alist){
      //  System.out.println(line);
      //}

        itr = alist.iterator();
		while (itr.hasNext()) {
			RemoteMsgBox ansobj=(RemoteMsgBox)itr.next();
            System.out.println("@once ans:"+ansobj.getStmt());
		}


        socket.close();
    }catch(java.net.ConnectException e){
        System.out.println("connection err at :"+HOSTPORT);
        //e.printStackTrace();
    }
    catch(Exception e){
      e.printStackTrace();
    }
  }


    private void fireLoop(){

    try{
      Socket socket = new Socket(HOSTNAME,HOSTPORT);

        ArrayList  alist;
        int MAX=10;

        RemoteMsgBox[] intarray = new RemoteMsgBox[MAX];


        for (int i = 0; i < MAX; i++) {
			intarray[i] = new RemoteMsgBox(""+i+":");
		}

        //List list = Arrays.asList(intarray);
        alist = new ArrayList();

        RemoteMsgBox sobj=new RemoteMsgBox("@1");

        //String sql=(new SensorVals()).getSQLInsertStmt("data");
        //sobj.setStmt(sql);
        sobj.setSVal((new SensorVals("0014.4F01.0000.7221")));
        alist.add(sobj);

        alist.add(new RemoteMsgBox("@2"));

        Iterator itr = alist.iterator();
		while (itr.hasNext()) {
			RemoteMsgBox sendingobj=(RemoteMsgBox)itr.next();
            System.out.println("send:"+sendingobj.getStmt());
		}

      ObjectOutputStream oos = new ObjectOutputStream( socket.getOutputStream() );
      oos.writeObject(alist);

      ObjectInputStream ois = new ObjectInputStream( socket.getInputStream() );
      alist = (ArrayList)( ois.readObject() );


      //for(String line : alist){
      //  System.out.println(line);
      //}

        itr = alist.iterator();
		while (itr.hasNext()) {
			RemoteMsgBox ansobj=(RemoteMsgBox)itr.next();
            System.out.println("ans:"+ansobj.getStmt());
		}


        socket.close();
    }catch(java.net.ConnectException e){
        e.printStackTrace();
    }
    catch(Exception e){
      e.printStackTrace();
    }
  }

    /**
     * @return the sVal
     */
    public SensorVals getSVal() {
        return sVal;
    }

    /**
     * @param sVal the sVal to set
     */
    public void setSVal(SensorVals sVal) {
        this.sVal = sVal;
    }
}
