/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package jp.osoite.tomu.net.socks;

/**
 *
 * @author tailor
 */
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.io.ObjectOutputStream;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import jp.osoite.tomu.core.main.IConnection;
import jp.osoite.tomu.core.main.MainController;
import jp.osoite.tomu.core.main.SensorVals;

public class SockMultiThreadServer implements IConnection {

    public static final int SOCK_SERV_PORT = 5555;
    public ServerSocket serverSocket;
    int threadCount = 0;
    final List freeThreads = new ArrayList();
    //private static final int PORT = 5556;
    //private static final int CORE_THREADS = 10,  MAX_THREADS = 30;
    private static final int CORE_THREADS = 5,  MAX_THREADS = 20;

    public SockMultiThreadServer() {
    }

    public static void main(String argv[]) {

        new Thread(new SockMultiThreadServer()).start();

    }

    private void startThread() {
        WorkerThread worker = new WorkerThread();
        ++this.threadCount;
        worker.start();
    }

    class WorkerThread extends Thread {

        private Socket socket;

        // \Pbg蓖Ă
        public synchronized void assign(Socket socket) {
            this.socket = socket;
            this.notify(); // \bhwaitőҋ@̏ĊJ
        }

        public synchronized void run() {
            for (;;) { // xėp̂ŁA[v
                // ̃Xbhҋ@̃XbhƂēo^
                synchronized (SockMultiThreadServer.this) {
                    SockMultiThreadServer.this.freeThreads.add(this);
                    SockMultiThreadServer.this.notify();
                }
                try {
                    this.wait(); // \bhnotifyĂ΂܂őҋ@
                } catch (InterruptedException e) {
                    // 荞݂͎gȂ̂Ŗ
                }

                try {
                    try {
                        SockMultiThreadServer.this.process(this.socket);
                    } finally {
                        // \PbgĂȂΕ
                        if (!this.socket.isClosed()) {
                            this.socket.close();
                        }
                    }
                } catch (Throwable e) {
                    // O^G[ꍇ
                    e.printStackTrace();
                }
                // K[xbWERN^x邽߂ɁA
                // gȂϐnull
                this.socket = null;
            }
        }
    }

    void process(Socket s) throws Exception {
        // \Pbgɑ΂鏈
        ArrayList alist;
        int MAX = 10;
        RemoteMsgBox[] intarray = new RemoteMsgBox[MAX];
        for (int i = 0; i < MAX; i++) {
            intarray[i] = new RemoteMsgBox("" + i);
        }
        List list = Arrays.asList(intarray);
        alist = new ArrayList(list);

        ObjectInputStream ois = new ObjectInputStream(s.getInputStream());


        alist = (ArrayList) (ois.readObject());


        Iterator itr2 = alist.iterator();

        while (itr2.hasNext()) {
            RemoteMsgBox sobj = (RemoteMsgBox) itr2.next();



            if (sobj.getSval() != null) {
                SensorVals sval = sobj.getSval();
                sval.print();
                MainController.getInstance().addSensorVals(sval);

            }

            sobj.setStmt(sobj.getStmt() + "_hoge");
            System.out.println("receive:" + sobj);
        }//while end

        // ԐM
        ObjectOutputStream oos = new ObjectOutputStream(s.getOutputStream());
        oos.writeObject(alist);

        // \Pbg폜
        s.close();

    }

    public synchronized void run() {
        // RAEXbh𐶐
        while (this.threadCount < CORE_THREADS) {
            this.startThread();
        }
        try {
            // T[oE\Pbg쐬
            //this.serverSocket = new ServerSocket(PORT);
            this.serverSocket = new ServerSocket(SOCK_SERV_PORT);
            MyIPChecker.myip();

            for (;;) {
                // NCAg҂󂯂
                Socket socket = this.serverSocket.accept();
                // ҋ@̃XbhȂԃ[v
                while (this.freeThreads.isEmpty()) {
                    // ől܂ŃXbh݂̐
                    if (this.threadCount < MAX_THREADS) {
                        this.startThread();
                    }
                    try {
                        // ҋ@̃Xbhǉ܂őҋ@
                        this.wait();
                    } catch (InterruptedException e) {
                        // ignore
                    }
                }
                // ҋ@̃Xbh1oă\Pbg蓖Ă
                WorkerThread thread;
                thread = (WorkerThread) this.freeThreads.remove(this.freeThreads.size() - 1);
                thread.assign(socket);
            }
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void run2() {
        System.out.println("SockMultiThreadServer is starting");
        try {
            // T[o[\Pbg̐
            serverSocket = new ServerSocket(SOCK_SERV_PORT);
            MyIPChecker.myip();

            //MainController.getInstance().append("Socke Server is started...\n");

            int j = 0;
            // C[v
            while (true) {
                j++;
                ArrayList alist;
                int MAX = 10;
                RemoteMsgBox[] intarray = new RemoteMsgBox[MAX];
                for (int i = 0; i < MAX; i++) {
                    intarray[i] = new RemoteMsgBox("" + i);
                }
                List list = Arrays.asList(intarray);
                alist = new ArrayList(list);


                try {
                    System.out.println(j + ":NCAg̐ڑ|[g5555ő҂܂");
                    Socket s = serverSocket.accept();

                    //ArrayList<String> alist = new ArrayList<String>();

                    // M
                    if (!s.isClosed()) {
                        ObjectInputStream ois = new ObjectInputStream(s.getInputStream());


                        alist = (ArrayList) (ois.readObject());


                        Iterator itr2 = alist.iterator();

                        while (itr2.hasNext()) {
                            RemoteMsgBox sobj = (RemoteMsgBox) itr2.next();



                            if (sobj.getSval() != null) {
                                SensorVals sval = sobj.getSval();
                                sval.print();
                                MainController.getInstance().addSensorVals(sval);

                            }

                            sobj.setStmt(sobj.getStmt() + "_hoge");
                            System.out.println("receive:" + sobj);
                        }//while end

                        // ԐM
                        ObjectOutputStream oos = new ObjectOutputStream(s.getOutputStream());
                        oos.writeObject(alist);

                        // \Pbg폜
                        s.close();
                    } else {

                        Thread.sleep(10);

                    }

                } catch (Exception ex) {
                    System.err.println("err at while loop in server");
                    ex.printStackTrace();
                }




            }//while end
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void closeOp() {
        if (this.serverSocket != null) {
            System.err.print("colose at sock serv");
            try {
                serverSocket.close();
            } catch (IOException ex) {
                System.err.print("close sock err");
                ex.printStackTrace();
            //Logger.getLogger(SockMultiThreadServer.class.getName()).log(Level.SEVERE, null, ex);
            }

        }

    }
}

