/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package jp.osoite.tomu.net.localfiles;

import com.sun.spot.util.IEEEAddress;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JLabel;
import javax.swing.JTextArea;
import jp.osoite.tomu.core.main.MainController;
import jp.osoite.tomu.core.main.SensorVals;
import jp.osoite.tomu.usml.Config;

public class ReadCSV implements Runnable{

    private long firsttimer = 0;
    private long prevtimer = 0;
    private long sltimer;
    File csv;
    int speed=Config.getInstance().getDrawSpeedFromFile();
    //int speed=1;
    JTextArea jtext=null;
    public static void main(String[] args) {
        ReadCSV reader = new ReadCSV();
        reader.dojob(new File("C:\\SunSPOT\\writers.csv")); // CSV??タファイル);
    }
    ReadCSV() {
        csv=new File("C:\\SunSPOT\\writers.csv");
    }

    ReadCSV(JTextArea jtext) {
          this.jtext=jtext;
    }

    public void run(){
        dojob(csv);
    }
    public void dojob(File csv) {

        try {
            this.csv = csv;

            BufferedReader br = new BufferedReader(new FileReader(csv));

            String line = "";
            long durchecktimer=System.currentTimeMillis();
            long dur=0;
            while ((line = br.readLine()) != null) {
                durchecktimer=System.currentTimeMillis();
                StringTokenizer st = new StringTokenizer(line, ",");
                int idx = 0;

                int counter=0;
                String id="";
                
                String type = "";
                String timestamp = "";
                long timer=0;
                int light=0;
                double temp=0;
                double ax=0;
                double ay=0;
                double az=0;
                double tx=0;
                double ty=0;
                double tz=0;
                int rssi=0;
                double move=0;
                double batt=0;
                int feq=0;

                while (st.hasMoreTokens()) {
                    idx++;
                    
                    String val = st.nextToken();

                    switch (idx) {
                        case 1:
                            type = "counter";
                            counter=Integer.parseInt(val);
                            break;
                        case 2:
                            type = "id";
                            id=val;
                            break;
                        case 3:
                            type = "timestamp";
                            timestamp=val;
                            break;
                        case 4:
                            type = "timer";
                            timer = Long.parseLong(val);
                            if (firsttimer == 0) {
                                firsttimer = timer;
                            }
                            sltimer = timer - prevtimer;

                            prevtimer = timer;
                            break;
                        case 5:
                            type = "light";
                            light=Integer.parseInt(val);
                            break;
                        case 6:
                            type = "temp";
                            temp=Double.parseDouble(val);
                            break;
                        case 7:
                            type = "ax";
                            ax=Double.parseDouble(val);
                            break;
                        case 8:
                            type = "ay";
                            ay=Double.parseDouble(val);
                            break;
                        case 9:
                            type = "az";
                            az=Double.parseDouble(val);
                            break;
                        case 10:
                            type = "tx";
                            tx=Double.parseDouble(val);
                            break;
                        case 11:
                            type = "ty";
                            ty=Double.parseDouble(val);
                            break;
                        case 12:
                            type = "tz";
                            tz=Double.parseDouble(val);
                            break;
                        case 13:
                            type = "move";
                            move=Double.parseDouble(val);
                            break;
                        case 14:
                            type = "rssi";
                            rssi=Integer.parseInt(val);
                            break;
                        case 15:
                            type = "batt";
                            batt=Double.parseDouble(val);
                            break;
                        case 16:
                            type = "feq";
                            feq=Integer.parseInt(val);
                            break;
                        default:
                            type = "default";
                            break;
                    }

                    System.out.print(type + "=" + val + "\t");


                }
                String sensorname=id;
                long fromAddr=0;
                int sensedCounter=0;

                fromAddr=IEEEAddress.toLong(id);

                SensorVals sval=new SensorVals(timer,fromAddr,sensorname,sensedCounter,temp,ax,ay,az,tx,ty,tz,light,batt,feq,rssi);
                try {
                    MainController.getInstance().addSensorVals(sval);
                } catch (Exception ex) {
                    Logger.getLogger(ReadCSV.class.getName()).log(Level.SEVERE, null, ex);
                }

                

                System.out.println();


                dur=System.currentTimeMillis()-durchecktimer;

                //System.out.println("sltimer"+sltimer);
                //System.out.println("prevtimer"+prevtimer);
                //System.out.println("durtimer:" + dur);
                jtext.append("timer"+timer+":"+sval.toStringByAllIntVal()+"\n");

                if (prevtimer != 0 && sltimer < 10 * 10000) {
                    
                    try {
                        //Thread.sleep(100);
                        //Thread.sleep(sltimer-dur);
                        Thread.sleep((sltimer-dur)/speed);
                    } catch (InterruptedException ex) {
                        Logger.getLogger(ReadCSV.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
                durchecktimer=System.currentTimeMillis();

            }
            br.close();

        } catch (FileNotFoundException e) {
            // Fileオブジェクト生成時の例外捕?            e.printStackTrace();
        } catch (IOException e) {
            // BufferedReaderオブジェクト?クローズ時?例外捕?            e.printStackTrace();
        }
    }

    void setCSV(File file) {
        csv=file;
    }
}