package jp.osoite.tomu.core.gui;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JPanel;
import jp.osoite.tomu.core.main.SensorVals;
import jp.osoite.tomu.usml.Config;

/**
 *
 * @author tailor
 */
public class GuiDWGraphPanel extends JPanel {

    private int MAX_TYPES_OF_SENSORS=11;
    double vscale;
    double tscale;
    int y0;
    int yn;
    int x0;
    int xn;
    final int margin = 5;

    private GuiDataWindow gdw;

    public GuiDWGraphPanel(GuiDataWindow gdw){
        this.gdw=gdw;
    }


 public void setUpGraph(Graphics2D g2) {

    int w = this.getWidth();
    int h = this.getHeight();

    int left = 0 + 10;       // get size of pane
    int top = 0 + 10;
    int right = left + w - 20;
    int bottom = top + h - 20;

    y0 = bottom - 20;                   // leave some room for margins
    yn = top;
    x0 = left + 33;
    xn = right;
    vscale = (yn - y0) / 800.0;      // light values range from 0 to 800
    tscale = 1.0 / 2000.0;           // 1 pixel = 2 seconds = 2000 milliseconds

    // draw X axis = time
    g2.setColor(Color.BLACK);
    g2.drawLine(x0, yn, x0, y0);
    g2.drawLine(x0, y0, xn, y0);
    int tickInt = 60 / 2;
    
    for (int xt = x0 + tickInt; xt < xn; xt += tickInt) {   // tick every 1 minute
        g2.drawLine(xt, y0 + margin, xt, y0 - margin);
        int min = (xt - x0) / (60 / 2);
        g2.drawString(Integer.toString(min), xt - (min < 10 ? 3 : 7) , y0 + 20);
    }

    // draw Y axis = sensor reading
    g2.setColor(Color.BLUE);
    for (int vt = 2*800; vt > 0; vt -= 200) {         // tick every 200
        int v = y0 + (int)(vt * vscale);
        g2.drawLine(x0 - margin, v, x0 + margin, v);
        g2.drawString(Integer.toString(vt), x0 - 38 , v + margin);
    }

 }
  public void paintComponent(Graphics g) {

    super.paintComponent(g);
    Graphics2D g2 = (Graphics2D)g;
    this.setUpGraph(g2);
    // graph sensor values
    int xp = -1;

        Color bkc=this.getBackground();
         for (int i = 0; i < gdw.getIndex(); i++) {
            int x = x0 + (int)((gdw.time[i] - gdw.time[0]) * tscale);

            /*
            int v1s = y0 + (int)(gdw.val1[i] * vscale);
            int v2s = y0 + (int)(gdw.val2[i] * vscale);
            int v3s = y0 + (int)(gdw.val3[i] * vscale);
            int v4s = y0 + (int)(gdw.val4[i] * vscale);
            */

            for(int j=0;j<MAX_TYPES_OF_SENSORS;j++){
                gdw.objs[j][i].setVscale(vscale,y0);
                gdw.objs[j][i].setGraphics2D(g2);                
            }

                /*
            gdw.objMovements[i].setVscale(vscale,y0);
            gdw.objMovements[i].setGraphics2D(g2);

            gdw.objAccelX[i].setVscale(vscale,y0);
            gdw.objAccelX[i].setGraphics2D(g2);
            gdw.objAccelY[i].setVscale(vscale,y0);
            gdw.objAccelY[i].setGraphics2D(g2);
            gdw.objAccelZ[i].setVscale(vscale,y0);
            gdw.objAccelZ[i].setGraphics2D(g2);
            gdw.objTiltX[i].setVscale(vscale,y0);
            gdw.objTiltX[i].setGraphics2D(g2);
            gdw.objTiltY[i].setVscale(vscale,y0);
            gdw.objTiltY[i].setGraphics2D(g2);
            gdw.objTiltZ[i].setVscale(vscale,y0);
            gdw.objTiltZ[i].setGraphics2D(g2);


            gdw.objTemps[i].setVscale(vscale,y0);
            gdw.objTemps[i].setGraphics2D(g2);

            gdw.objBatts[i].setVscale(vscale,y0);
            gdw.objBatts[i].setGraphics2D(g2);

            gdw.objLights[i].setVscale(vscale,y0);
            gdw.objLights[i].setGraphics2D(g2);
            */

            if (xp > 0 ) {
                if(i>0){

               for(int j=0;j<MAX_TYPES_OF_SENSORS;j++){
                gdw.objs[j][i-1].setBackgroundColor(bkc);
                gdw.objs[j][i-1].eraseLabel(xp);
               }

               /*
                gdw.objLights[i-1].setBackgroundColor(bkc);
                gdw.objLights[i-1].eraseLabel(xp);

                gdw.objMovements[i-1].setBackgroundColor(bkc);
                gdw.objMovements[i-1].eraseLabel(xp);

                gdw.objAccelX[i-1].setBackgroundColor(bkc);
                gdw.objAccelX[i-1].eraseLabel(xp);
                gdw.objAccelY[i-1].setBackgroundColor(bkc);
                gdw.objAccelY[i-1].eraseLabel(xp);
                gdw.objAccelZ[i-1].setBackgroundColor(bkc);
                gdw.objAccelZ[i-1].eraseLabel(xp);
                gdw.objTiltX[i-1].setBackgroundColor(bkc);
                gdw.objTiltX[i-1].eraseLabel(xp);
                gdw.objTiltY[i-1].setBackgroundColor(bkc);
                gdw.objTiltY[i-1].eraseLabel(xp);
                gdw.objTiltZ[i-1].setBackgroundColor(bkc);
                gdw.objTiltZ[i-1].eraseLabel(xp);

                gdw.objBatts[i-1].setBackgroundColor(bkc);
                gdw.objBatts[i-1].eraseLabel(xp);

                gdw.objTemps[i-1].setBackgroundColor(bkc);
                gdw.objTemps[i-1].eraseLabel(xp);
                */


                for(int j=0;j<MAX_TYPES_OF_SENSORS;j++){
                    if(gdw.sensorsVisible[j]){
                        gdw.objs[j][i].drawLineofVS(xp, gdw.objs[j][i-1].getVScale(), x);
                        gdw.objs[j][i].drawLabel(x);
                    }
                }


               /*
                gdw.objLights[i].drawLineofVS(xp, gdw.objLights[i-1].getVScale(), x);
                gdw.objLights[i].drawLabel(x);
                */
               if(Config.getInstance().isSTASTICS_CALC_ENABLE()){
                    gdw.objs[SensorVals.INT_LIGHT][i].drawLineofLBScale(xp, gdw.objs[SensorVals.INT_LIGHT][i-1].getLowband(), x);
                    gdw.objs[SensorVals.INT_LIGHT][i].drawLineofHBScale(xp, gdw.objs[SensorVals.INT_LIGHT][i-1].getHighband(), x);
               }
                //gdw.objLights[i].drawLineofLBScale(xp, gdw.objLights[i-1].getLowband(), x);
                //gdw.objLights[i].drawLineofHBScale(xp, gdw.objLights[i-1].getHighband(), x);
                //gdw.objLights[i].drawLineofAvg(xp, gdw.objLights[i-1].getAvg(), x);

                /*
                gdw.objMovements[i].drawLineofVS(xp, gdw.objMovements[i-1].getVScale(), x);
                gdw.objMovements[i].drawLabel(x);
                */
                if(Config.getInstance().isSTASTICS_CALC_ENABLE()){
                    gdw.objs[SensorVals.INT_MOVE][i].setBandColor(Color.red);
                    gdw.objs[SensorVals.INT_MOVE][i].drawLineofLBScale(xp, gdw.objs[SensorVals.INT_MOVE][i-1].getLowband(), x);
                    gdw.objs[SensorVals.INT_MOVE][i].drawLineofHBScale(xp, gdw.objs[SensorVals.INT_MOVE][i-1].getHighband(), x);
                }

                //gdw.objMovements[i].setBandColor(Color.gray);
                //gdw.objMovements[i].drawLineofLBScale(xp, gdw.objMovements[i-1].getLowband(), x);
                //gdw.objMovements[i].drawLineofHBScale(xp, gdw.objMovements[i-1].getHighband(), x);

                /*
                gdw.objAccelX[i].drawLineofVS(xp, gdw.objAccelX[i-1].getVScale(), x);
                gdw.objAccelX[i].drawLabel(x);
                gdw.objAccelY[i].drawLineofVS(xp, gdw.objAccelY[i-1].getVScale(), x);
                gdw.objAccelY[i].drawLabel(x);
                gdw.objAccelZ[i].drawLineofVS(xp, gdw.objAccelZ[i-1].getVScale(), x);
                gdw.objAccelZ[i].drawLabel(x);
                gdw.objTiltX[i].drawLineofVS(xp, gdw.objTiltX[i-1].getVScale(), x);
                gdw.objTiltX[i].drawLabel(x);
                gdw.objTiltY[i].drawLineofVS(xp, gdw.objTiltY[i-1].getVScale(), x);
                gdw.objAccelY[i].drawLabel(x);
                gdw.objTiltZ[i].drawLineofVS(xp, gdw.objTiltZ[i-1].getVScale(), x);
                gdw.objTiltZ[i].drawLabel(x);

                gdw.objBatts[i].drawLineofVS(xp, gdw.objBatts[i-1].getVScale(), x);
                gdw.objBatts[i].drawLabel(x);
                
                gdw.objTemps[i].drawLineofVS(xp, gdw.objTemps[i-1].getVScale(), x);
                gdw.objTemps[i].drawLabel(x);
                //System.out.println("popo low"+gdw.objTemps[i].getHighband());
                //System.out.println("popo high"+gdw.objTemps[i].getHighband());
                 * */

                if(Config.getInstance().isSTASTICS_CALC_ENABLE()){
                    gdw.objs[SensorVals.INT_TEMP][i].setBandColor(Color.YELLOW);
                    gdw.objs[SensorVals.INT_TEMP][i].drawLineofLBScale(xp, gdw.objs[SensorVals.INT_TEMP][i-1].getLowband(), x);
                    gdw.objs[SensorVals.INT_TEMP][i].drawLineofHBScale(xp, gdw.objs[SensorVals.INT_TEMP][i-1].getHighband(), x);
                }

                
                //gdw.objTemps[i].setBandColor(Color.YELLOW);
                //gdw.objTemps[i].drawLineofLBScale(xp, gdw.objTemps[i-1].getLowband(), x);
                //gdw.objTemps[i].drawLineofHBScale(xp, gdw.objTemps[i-1].getHighband(), x);



                }else if(i==0){

                  for(int j=0;j<MAX_TYPES_OF_SENSORS;j++){
                   if(gdw.sensorsVisible[j]){
                    gdw.objs[j][i].drawLineofVS(xp, gdw.objs[j][i].getVScale(), x);
                    gdw.objs[j][i].drawLabel(x);
                   }
                  }
                  

                    /*
                gdw.objLights[i].drawLineofVS(xp, gdw.objLights[i].getVScale(), x);
                gdw.objLights[i].drawLabel(x);

                gdw.objMovements[i].drawLineofVS(xp, gdw.objMovements[i].getVScale(), x);
                gdw.objMovements[i].drawLabel(x);

                gdw.objAccelX[i].drawLineofVS(xp, gdw.objAccelX[i].getVScale(), x);
                gdw.objAccelX[i].drawLabel(x);
                gdw.objAccelY[i].drawLineofVS(xp, gdw.objAccelY[i].getVScale(), x);
                gdw.objAccelY[i].drawLabel(x);
                gdw.objAccelZ[i].drawLineofVS(xp, gdw.objAccelZ[i].getVScale(), x);
                gdw.objAccelZ[i].drawLabel(x);
                gdw.objTiltX[i].drawLineofVS(xp, gdw.objAccelX[i].getVScale(), x);
                gdw.objTiltX[i].drawLabel(x);
                gdw.objTiltY[i].drawLineofVS(xp, gdw.objAccelY[i].getVScale(), x);
                gdw.objTiltY[i].drawLabel(x);
                gdw.objTiltZ[i].drawLineofVS(xp, gdw.objAccelZ[i].getVScale(), x);
                gdw.objTiltZ[i].drawLabel(x);

                
                gdw.objBatts[i].drawLineofVS(xp, gdw.objBatts[i].getVScale(), x);
                gdw.objBatts[i].drawLabel(x);
                gdw.objTemps[i].drawLineofVS(xp, gdw.objTemps[i].getVScale(), x);
                gdw.objTemps[i].drawLabel(x);
*/
                        
                    }

            }

                /*
                g2.setColor(Color.red);
                g2.drawLine(xp, v1p, x, v1s);
                g2.drawString(gdw.str1, x+margin, v1s);

                g2.setColor(Color.blue);
                g2.drawLine(xp, v2p, x, v2s);
                g2.drawString(gdw.str2, x+margin, v2s);

                g2.setColor(Color.black);
                g2.drawLine(xp, v3p, x, v3s);
                g2.drawString(gdw.str3, x+margin, v3s);
                
                g2.setColor(Color.pink);
                g2.drawLine(xp, v4p, x, v4s);
                g2.drawString(gdw.str4, x+margin, v4s);
                 */
                
                //g2.setColor(gdw.objs[i].getColor());
                //g2.drawLine(xp, v5p, x, v5s);
                //g2.drawLine(xp, gdw.objs[i-1].getValueResetSize(), x, gdw.objs[i].getValueResetSize());
                //g2.drawString(gdw.objs[i].getStr(), x+margin, v5s);
                //g2.drawString(gdw.objs[i].getStr(), x+margin, gdw.objs[i].getValueResetSize());




            xp = x;
            
         }
        
  }
}