/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package jp.osoite.tomu.core.db.mysql;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.TimeZone;

public class DBStatisticsHelper {

    private static String stmtStatistics1 = "";
    private static String stmtStatistics2 = "";
    private static String stmtStatistics3 = "";
    private static String stmtStatistics3_create= "";
    private static String stmtStatistics4 = "";
    private static String stmtStatistics5 = "";
    private static String stmtStatistics6 = "";
    private static String stmtStatistics7 = "";
    private static String stmtStatistics8 = "";
    private static String stmtStatistics9 = "";
    private static String stmtStatistics9_autosaving = "";



    public static String getStmt9AutoSaving(String sensorname) {
        SimpleDateFormat sdf1 = new SimpleDateFormat("yyyyMMdd_HHmmss");//yyyyMMdd_HHmmss_Z
        TimeZone tz1 = TimeZone.getTimeZone("Asia/Tokyo");
        Calendar cal1 = Calendar.getInstance(tz1);
        String tailstr = "_" + sensorname.substring(15) + "_" + sdf1.format(cal1.getTime());//sdf1.format(date1);//System.currentTimeMillis();
        stmtStatistics9_autosaving = "Create table auto"  + tailstr +" as SELECT * FROM data where sensorid=\'" + sensorname + "\' ORDER BY 1";//ORDER BY 1 LIMIT 5,30
        return stmtStatistics9_autosaving;
    }
    public static String getStmt9BkupTxt(String sensorname) {
        
        SimpleDateFormat sdf1 = new SimpleDateFormat("yyyyMMdd_HHmmss");//yyyyMMdd_HHmmss_Z
        TimeZone tz1 = TimeZone.getTimeZone("Asia/Tokyo");
        Calendar cal1 = Calendar.getInstance(tz1);
        
        String tailstr = "_" + sensorname.substring(15) + "_" + sdf1.format(cal1.getTime());//sdf1.format(date1);//System.currentTimeMillis();
        stmtStatistics9 = "SELECT * FROM data where sensorid=\'" + sensorname + "\' ORDER BY 1 INTO OUTFILE \'c:/SunSPOT/jikkne" + tailstr + ".csv\' FIELDS TERMINATED BY \',\'";//ORDER BY 1 LIMIT 5,30

        return stmtStatistics9;

    }

    public DBStatisticsHelper() {
    }

    /**
     * @return the stmtStatistics1
     */
    private static String getStmtQuery1(int bandwidth) {
        stmtStatistics1 = "select @bandwidth:=" + bandwidth + " as bandwidth";
        return stmtStatistics1;
    }

    public static String getStmt2PreCreateView(String viewname) {
        //IF NOT EXISTS
        stmtStatistics3 = "CREATE VIEW " + viewname + " AS select * from data as a LIMIT 1";
        return stmtStatistics3;
    }

    public static String getStmt2CreateDataTable(String datatablename) {
        /*
        stmtStatistics3_create = "CREATE TABLE IF NOT EXISTS " + datatablename +
                        "(`counter` bigint(20) NOT NULL auto_increment," +
                        "`sensorid` char(20) NOT NULL," +
                        "`timestamp` timestamp NOT NULL default CURRENT_TIMESTAMP," +
                        "`timer` long NOT NULL ," + //default"+defTimer+"
                        "`light` int(11) ," + //NOT NULL
                        "`temp` double ," +
                        "`ax` double ," +
                        "`ay` double ," +
                        "`az` double ," +
                        "`movement` int(11) ," +
                        "`battery` double ," +
                        "`frequency` int(11) ," +//NOT NULL
                        "PRIMARY KEY  (`counter`))" +
                        " ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1";;
         * */
        stmtStatistics3_create = "CREATE TABLE IF NOT EXISTS " + datatablename +
                        "(`counter` bigint(20) NOT NULL auto_increment," +
                        "`sensorid` char(20) NOT NULL," +
                        "`timestamp` timestamp NOT NULL default CURRENT_TIMESTAMP," +
                        "`timer` long NOT NULL ," + //default"+defTimer+"
                        "`light` int(11) ," + //NOT NULL
                        "`temp` double ," +
                        "`ax` double ," +
                        "`ay` double ," +
                        "`az` double ," +
                        "`tx` double ," +
                        "`ty` double ," +
                        "`tz` double ," +
                        "`movement` int(11) ," +
                         "`rssi` int(11) ," +
                        "`battery` double ," +
                        "`frequency` int(11) ," +//NOT NULL
                        "PRIMARY KEY  (`counter`))" +
                        " ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1";;
        return stmtStatistics3_create;
    }


    public static String getStmt2DropView(String viewname) {
        stmtStatistics2 = "Drop View " + viewname + " ;";//IF EXISTS
        return stmtStatistics2;
    }

    /**
     * @return the stmtStatistics3
     */
    public static String getStmt3CreateViewLimited(String sensorname, int limitnum) {
        //IF NOT EXISTS
        stmtStatistics3 = "CREATE VIEW v AS select * from data as a where a.sensorid=\'" + sensorname + "\' ORDER BY counter DESC LIMIT " + limitnum;
        return stmtStatistics3;
    }

    /**
     * @return the stmtStatistics4
     */
    public static String getStmtQuery4VariableSetting() {
        stmtStatistics4 = "select count(*) as cont, " +
                "@sensorid:=sensorid as sensorid," +
                "@lasttimestamp:=max(timestamp) as lasttimestamp," +
                "@lasttimer:=max(timer) as lasttimer," +
                "@lightavg:=avg(light) as lightavg," +
                "@lightstd:=std(light) as lightstd," +
                "@axavg:=avg(ax) as axavg," +
                "@axstd:=std(ax) as axstd," +
                "@ayavg:=avg(ay) as ayavg," +
                "@aystd:=std(ay) as aystd," +
                "@azavg:=avg(az) as azavg," +
                "@azstd:=std(az) as azstd," +
                "@movementavg:=avg(movement) as movementavg," +
                "@movementstd:=std(movement) as movementstd," +
                "@tempavg:=avg(temp) as tempavg," +
                "@tempstd:=std(temp) as tempstd " +
                "from v";

        //System.out.println("stmtStatistics4:"+stmtStatistics4);
        return stmtStatistics4;
    }

    /**
     * @return the stmtStatistics5
     */
    public static String getStmt5DropStatistics() {
        //stmtStatistics5="drop table if exists statistics;";
        stmtStatistics5 = "drop table if exists statistics;";
        return stmtStatistics5;
    }

    /**
     * @return the stmtStatistics6
     */
    public static String getStmt6createStatistics() {
        stmtStatistics6 = "create table if not exists statistics (" +
                "sensorid char(20) NOT NULL," +
                "lasttimestamp timestamp NOT NULL default CURRENT_TIMESTAMP," +
                "lasttimer long NOT NULL ," +
                "light_low_band double," +
                "lightavg double," +
                "light_high_band double," +
                "movement_low_band double," +
                "movementavg double," +
                "movement_high_band double," +
                "temp_low_band double," +
                "tempavg double," +
                "temp_high_band double)";
        return stmtStatistics6;
    }

    /**
     * @return the stmtStatistics7
     */
    public static String getStmt7insertStatistics(double bandwidth) {
        /*
        stmtStatistics7="insert into statistics " +
        "select " +
        "@sensorid as sensorid," +
        "@lasttimestamp as lasttimestamp," +
        "@lasttimer as lasttimer," +
        "(@lightavg - " + bandwidth +"*@lightstd) as light_low_band," +
        "@lightavg as lightavg," +
        "(@lightavg + " + bandwidth +"*@lightstd) as light_high_band," +
        "(@movementavg - " + bandwidth +"*@movementstd) as movement_low_band," +
        " @movementavg as movementavg," +
        "(@movementavg + " + bandwidth + "*@movementstd) as movement_high_band," +
        "(@tempavg - " + bandwidth +"*@tempstd) as temp_low_band," +
        "@tempavg as tempavg," +
        "(@tempavg + " + bandwidth + "*@tempstd) as temp_high_band";
         * */

        stmtStatistics7 = "insert into statistics " +
                "select " +
                "@sensorid as sensorid," +
                "@lasttimestamp as lasttimestamp," +
                "@lasttimer as lasttimer," +
                "(@lightavg - 2*@lightstd) as light_low_band," +
                "@lightavg as lightavg," +
                "(@lightavg + 2*@lightstd) as light_high_band," +
                "(@movementavg - 2*@movementstd) as movement_low_band," +
                " @movementavg as movementavg," +
                "(@movementavg + 2*@movementstd) as movement_high_band," +
                "(@tempavg - 2*@tempstd) as temp_low_band," +
                "@tempavg as tempavg," +
                "(@tempavg + 2*@tempstd) as temp_high_band";


        return stmtStatistics7;
    }

    public static String getStmt8select1Statistics(String sensorname) {

        stmtStatistics8 = "select " +
                "sensorid," +
                "lasttimestamp," +
                "lasttimer," +
                "light_low_band," +
                "lightavg," +
                "light_high_band," +
                "movement_low_band," +
                "movementavg," +
                "movement_high_band," +
                "temp_low_band," +
                "tempavg," +
                "temp_high_band " +
                " from statistics " +
                " where sensorid=\'" + sensorname + "\' ORDER BY lasttimer DESC LIMIT 1 ";

        /*
        stmtStatistics8="select " +
        " * " +
        "from statistics " +
        "where sensirid=\'"+sensorname
        +"\'";
         * */
        return stmtStatistics8;


    }
}
