package jp.osoite.tomu.core.db;

import jp.osoite.tomu.core.db.mysql.*;
import java.sql.BatchUpdateException;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import jp.osoite.tomu.core.main.SensorVals;
import jp.osoite.tomu.core.gui.GuiSmallObj;
import jp.osoite.tomu.usml.Config;

public class DBConnectionModule {

    public static final int NUMBER_OF_STANDALISATION = 15;
    // Broadcast port on which we listen for sensor samples
    //private static final int DATA_SINK_PORT = 67;
    //?
    private static DBConnectionModule dbmodule = new DBConnectionModule();

    //private boolean FLAG_DROP_TABLE=false;
    private boolean FLAG_DROP_TABLE = true;

    // This demo assumes a mySQL database has been installed on the
    // local host at the default port (3306), has a database called
    // Test and can be manipulated using the default administrator
    // settings (empty password for user 'root'). The JDBC driver
    // needed to communicate with this database is specified in JDBC_DRIVER.
    // If your setup is based on a different database and driver, you'll
    // need to modify these settings appropriately.
    // Obviously, an empty password should never be used for anything more
    // serious than a test setup.
    /*
    private static final String DATABASE_URL = "jdbc:mysql://localhost:3306/";
    private static final String DATABASE_NAME = "Test";
    private static final String DATABASE_USER = "root";

    private static final String DATABASE_PASSWORD = "";
    private static final String JDBC_DRIVER = "com.mysql.jdbc.Driver";
     */
    String DATABASE_URL = "";
    String DATABASE_NAME = "";
    String DATABASE_USER = "";
    String DATABASE_PASSWORD = "";
    String JDBC_DRIVER = "";
    String DATA_TABLE_NAME = "";
    //private static final String DATA_TABLE_NAME = "data";

    // private static final String DATABASE_URL = Config.getInstance().getDATABASE_URL();
    //private static final String DATABASE_NAME =Config.getInstance().getDATABASE_NAME();
    //   private static final String DATABASE_USER =Config.getInstance().getDATABASE_USER();
//    private static final String DATABASE_PASSWORD =Config.getInstance().getDATABASE_PASSWORD();
//    private static final String JDBC_DRIVER = Config.getInstance().getJDBC_DRIVER();
    //public boolean STASTICS_CALC_ENABLE_FLAG=true;
    //public boolean STASTICS_CALC_ENABLE_FLAG=false;
    //public boolean STASTICS_CALC_ENABLE_FLAG=true;
    //public boolean STASTICS_CALC_ENABLE_FLAG=Config.getInstance().isSTASTICS_CALC_ENABLE();
    // Duration (in milliseconds) for which to collect samples.
    //private static final int SAMPLING_DURATION = 10*60000;
    //masa

    // This is how long we block waiting to read data on the
    // radio connection. Without a timeout, the host application
    // could run well beyond the duration specified above, e.g. if
    // there are no SPOTs transmitting sensor samples.
    //tailor
    //private static final int CONNECTION_TIMEOUT = 10000;
    private Statement stmt = null;
    private java.sql.Connection dbCon = null;

    //private RadiogramConnection rCon = null;

    //private void run() throws Exception {
    /*
    public void run()  {
    try {
    setUp();
    collectData();
    analyzeData();
    } catch (Exception e) {
    e.printStackTrace();
    } finally {

    tearDown1();

    }
    }
     * */
    public static DBConnectionModule getInstance() {

        if (dbmodule == null) {
            dbmodule = new DBConnectionModule();
        }
        return dbmodule;
    }

    private DBConnectionModule() {
        try {
            setUp();
        } catch (Exception ex) {
            Logger.getLogger(DBConnectionModule.class.getName()).log(Level.SEVERE, null, ex);
        }

    }

    private void setUp() throws Exception {


        DATABASE_URL = Config.getInstance().getDATABASE_URL();
        DATABASE_NAME = Config.getInstance().getDATABASE_NAME();
        DATABASE_USER = Config.getInstance().getDATABASE_USER();
        DATABASE_PASSWORD = Config.getInstance().getDATABASE_PASSWORD();
        JDBC_DRIVER = Config.getInstance().getJDBC_DRIVER();
        DATA_TABLE_NAME = Config.getInstance().getDATA_TABLE_NAME();


        System.out.println("Database demo application starting ... ");
        try {
            // Register the JDBC driver for mysql
            // This is typically found in a JAR file
            // named something like
            // mysql-connector-java-<version>-bin.jar
            // which should be in the classpath
            // See user.classpath in build.properties
            // for this Sun SPOT host application
            Class.forName(JDBC_DRIVER);

            // Define URL of database server for
            String url = DATABASE_URL + DATABASE_NAME;

            // Get a connection to the database for given user/password
            dbCon = DriverManager.getConnection(url, DATABASE_USER,
                    DATABASE_PASSWORD);

            // Display URL and connection information
            System.out.println("URL: " + url);
            System.out.println("Connection: " + dbCon);
        } catch (Exception e) {
            System.err.println("setUp caught " + e);
            System.err.println("Make sure that mySQL is installed properly \n" +
                    "and has a Test database accessible via the \n" +
                    "default administrator settings on localhost:3306\n");
            throw e;
        }

        try {
            // Get a Statement object
            stmt = dbCon.createStatement();

            // Delete the data collection table if left over
            // from a previous run. If no table exists, an
            // exception will be thrown.

            if (FLAG_DROP_TABLE) {
                try {

                    stmt.executeUpdate("DROP TABLE if exists " + DATA_TABLE_NAME);
                    System.out.println("Existing table deleted.");
                } catch (SQLException e) {
                    System.out.println(e.getMessage());
                    System.out.println(
                            "No existing table to delete.");
                }
            }

            if (FLAG_DROP_TABLE) {
                try {
                    stmt.executeUpdate(DBStatisticsHelper.getStmt5DropStatistics());
                    System.out.println("delated. Statistics");
                } catch (SQLException e) {
                    System.out.println(e.getMessage());
                    System.out.println(
                            "No existing table to delete.");
                }
            }


            // Create a table with three columns:
            // spotId    padded to 20 chars identifier for SPOT
            // timestamp YYYY-MM-DD hh:mm:ss string when reading was taken
            // reading   light sensor reading (4 is simply the display
            //           width but an unsigned smallint can store any value
            //           from 0 to 65535)


            CREATEDATABASE:
            {

                long defTimer = System.currentTimeMillis();

                String createDataTableStmtStr=DBStatisticsHelper.getStmt2CreateDataTable(DATA_TABLE_NAME);
                
                /*
                String createDataTableStmtStr = "CREATE TABLE IF NOT EXISTS " + DATA_TABLE_NAME +
                        "(`counter` bigint(20) NOT NULL auto_increment," +
                        "`sensorid` char(20) NOT NULL," +
                        "`timestamp` timestamp NOT NULL default CURRENT_TIMESTAMP," +
                        "`timer` long NOT NULL ," + //default"+defTimer+"
                        "`light` int(11) ," + //NOT NULL
                        "`temp` double ," +
                        "`ax` double ," +
                        "`ay` double ," +
                        "`az` double ," +
                        "`movement` int(11) ," +
                        "`battery` double ," +
                        "`frequency` int(11) ," +//NOT NULL
                        "PRIMARY KEY  (`counter`))" +
                        " ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1";
                        */

                try {
                    //System.out.println(createDataTableStmtStr);
                    stmt.executeUpdate(createDataTableStmtStr);

                } catch (SQLException e) {
                    System.out.println(e.getMessage());
                    System.out.println(
                            "No data Table creation.");
                }
            }

            try {
                stmt.executeUpdate(DBStatisticsHelper.getStmt2PreCreateView("v"));
            } catch (SQLException e) {
                System.out.println(
                        "precreation view table");
            }


            try {
                stmt.executeUpdate(DBStatisticsHelper.getStmt6createStatistics());
            } catch (SQLException e) {
                System.out.println(e.getMessage());
                System.out.println(
                        "No statistics Table creation.");
            }




            //stmt.executeUpdate("describe "+DATA_TABLE_NAME);


            // Let's also open up a server-side broadcast radiogram connection
            // on which to listen for sensor readings being sent by different
            // SPOTs
            //rCon = (RadiogramConnection) Connector.open("radiogram://:" +
            //        DATA_SINK_PORT);
            // wait a finite time for data to arrive whenever we call receive()
            //rCon.setTimeout(CONNECTION_TIMEOUT);
            //
            System.out.println("setUp completed successfully");
        } catch (Exception e) {
            System.err.println("setUp caught " + e.getMessage());
            throw e;
        }




    }


    
    public void savingData2AutoTxt(String sensorname) throws Exception {

        System.out.println(">DB2AUTO" + DBStatisticsHelper.getStmt9AutoSaving(sensorname));
        ResultSet rs = null;
        rs = stmt.executeQuery(DBStatisticsHelper.getStmt9AutoSaving(sensorname));

    }

    
    public void savingData2Txt(String sensorname) throws Exception {

        System.out.println(">DB2TXT" + DBStatisticsHelper.getStmt9BkupTxt(sensorname));
        ResultSet rs = null;
        rs = stmt.executeQuery(DBStatisticsHelper.getStmt9BkupTxt(sensorname));

    }

    public void collectDataFromOutside(SensorVals sval) throws Exception {
        int sampleCnt = 0;
        long startTimer = 0L;

        //System.out.println("Sampling for " + (SAMPLING_DURATION/1000) + " seconds ...\n");
        startTimer = System.currentTimeMillis();

        /*
        String  insertStmtStr="INSERT INTO " + DATA_TABLE_NAME +
        "(sensorid,timestamp,timer,light,temp,ax,ay,az,movement,battery)" +
        " VALUES(\'" + sval.getSensorName() + "\',\'"+ sval.getTimeStamp()+ "\',\'"+sval.getInternalCounter()
        + "\',\'" + sval.getLightSensorVal()
        + "\',\'" + sval.getTempSensorVal()
        + "\',\'" + sval.getAccelX()
        + "\',\'" + sval.getAccelY()
        + "\',\'" + sval.getAccelZ()
        + "\',\'" + sval.getAllMovementbyInteger()
        + "\',\'" + sval.getRemainingBattery()
        + "\')";
         */

        String insertStmtStr = sval.getSQLInsertStmt(DATA_TABLE_NAME);

        System.out.println(">DB");
        try {

            stmt.executeUpdate(insertStmtStr);
            //System.out.println(insertStmtStr);
            
            sampleCnt++;
        } catch (BatchUpdateException b) {
            System.err.println("Update counts of successful commands: " + b);
            int[] updateCounts = b.getUpdateCounts();
            for (int i = 0; i < updateCounts.length; i++) {
                System.err.print(updateCounts[i] + "  ");
            }
            System.err.println("");
        } catch (SQLException e) {
            System.err.println("Caught " + e + " while storing sensor vals: " + insertStmtStr);
            throw e;
        } catch (Exception e) {
            System.err.println("Caught " + e +
                    " while reading sensor samples.");
            throw e;
        }
        if (Config.getInstance().isSTASTICS_CALC_ENABLE()) {
            statisticsUpdate(sval);
        }

    }

    public void collectDataFromOutside(String id2, String ts2, int val2) throws Exception {

        String id = null;
        String ts = null;
        int val = 0;

        id = id2;
        ts = ts2;
        val = val2;

        int sampleCnt = 0;
        long startTimer = 0L;

        /*
        System.out.println("Sampling for " + (SAMPLING_DURATION/1000) +
        " seconds ...\n[Each * indicates one sample, ! implies" +
        " radio timed out waiting for a sample]");
         *
         * */
        startTimer = System.currentTimeMillis();
        //dg = rCon.newDatagram(rCon.getMaximumLength());

        // Main data collection loop
        try {
            // Read sensor sample received over the radio
            //rCon.receive(dg);

            /*//tailor
            id = dg.readUTF();  // read sender's Id
            ts = dg.readUTF();  // read time stamp for the reading
            val = dg.readInt(); // read the sensor value
             */
            System.out.println("*");
            stmt.executeUpdate("INSERT INTO " + DATA_TABLE_NAME +
                    "(spotId,timestamp,reading)" +
                    " VALUES(\'" + id + "\',\'" + ts + "\'," + val + ")");
            sampleCnt++;
        } catch (SQLException e) {
            System.err.println("Caught " + e +
                    " while storing sensor sample <" +
                    "\'" + id + "\',\'" + ts + "\'," + val + ">");
            throw e;
        } catch (Exception e) {
            System.err.println("Caught " + e +
                    " while reading sensor samples.");
            throw e;
        }


        System.out.println("\nDone! Collected " + sampleCnt + " samples.");
    }

    
    public void analyzeData() throws Exception {
        ResultSet rs = null;
        String id = null;
        String ts = null;
        int val = 0;

        try {
            // Display all results
            rs = stmt.executeQuery("SELECT * " +
                    "from " + DATA_TABLE_NAME +
                    " ORDER BY timestamp");
            System.out.println("Collected sensor readings:");
            System.out.println("\t+--------------------------------------" +
                    "-----------------+");
            System.out.println("\t|      spotId       \t      timestamp  " +
                    " \treading |");
            System.out.println("\t+--------------------------------------" +
                    "-----------------+");
            while (rs.next()) {
                id = rs.getString("spotId");
                ts = rs.getString("timestamp");
                val = rs.getInt("reading");
                System.out.println("\t " + id + "\t" + ts + "\t   " + val);
            }
            System.out.println("\t+--------------------------------------" +
                    "-----------------+");

            // Print the spotId and timestamp corresponding to the highest val
            rs = stmt.executeQuery("SELECT * " +
                    "from " + DATA_TABLE_NAME +
                    " ORDER BY reading DESC LIMIT 1");
            while (rs.next()) {
                id = rs.getString("spotId");
                ts = rs.getString("timestamp");
                val = rs.getInt("reading");
                System.out.println("\tMax: " + val +
                        " (recorded by SPOT " + id + " at " + ts + ")");
            }

            // Print the spotId and timestamp corresponding to the lowest val
            rs = stmt.executeQuery("SELECT * " +
                    "from " + DATA_TABLE_NAME +
                    " ORDER BY reading ASC LIMIT 1");
            while (rs.next()) {
                id = rs.getString("spotId");
                ts = rs.getString("timestamp");
                val = rs.getInt("reading");
                System.out.println("\tMin: " + val +
                        " (recorded by SPOT " + id + " at " + ts + ")");
            }

            // Print the average sensor reading across all samples
            rs = stmt.executeQuery("SELECT AVG(reading) AS avg FROM " +
                    DATA_TABLE_NAME);
            while (rs.next()) {
                val = rs.getInt("avg");
                System.out.println("\tAvg: " + val);
            }
        } catch (Exception e) {
            System.err.println("Caught " + e + " in analyzeData()");
            throw e;
        }
    }

    public void tearDown() throws Exception {

        if (dbCon != null) {
            dbCon.close();

        }
    //if (rCon != null) rCon.close();
    //    System.exit(0);
    }

    /**
     * Start up the host application.
     *
     * @param args any command line arguments
     */
    public static void main(String[] args) throws Exception {
        //DatabaseDemoHostApplication app = new DatabaseDemoHostApplication();
        //DatabaseHostModule.getInstance()
        //app.run();
    }

    private void statisticsUpdate(SensorVals sval) throws SQLException {


        try {
            stmt.executeUpdate(DBStatisticsHelper.getStmt2DropView("v"));
        } catch (SQLException ex) {
            Logger.getLogger(DBConnectionModule.class.getName()).log(Level.SEVERE, null, ex);
        }

        try {
            //stmt.clearBatch();
            //stmt.addBatch(DBStatisticsHelper.getStmtStatistics1());
            //int [] updateCounts = stmt.executeBatch();
            //stmt.executeQuery(DBStatisticsHelper.getStmtQuery1(2));

            stmt.executeUpdate(DBStatisticsHelper.getStmt3CreateViewLimited(sval.getSensorName(), NUMBER_OF_STANDALISATION));

            stmt.executeQuery(DBStatisticsHelper.getStmtQuery4VariableSetting());
            stmt.executeUpdate(DBStatisticsHelper.getStmt7insertStatistics(1));

        //System.out.println("^^^^^^^^^^^^^^^^^^^\n"+DBStatisticsHelper.getStmt8select1Statistics(sval.getSensorName()));



        } catch (SQLException ex) {
            Logger.getLogger(DBConnectionModule.class.getName()).log(Level.SEVERE, null, ex);
        }


    }

    //قƂ͂悭ȂB
    public double processStasticsOnDB(String sensorname, GuiSmallObj lightsmallobj, GuiSmallObj movementsmallobj, GuiSmallObj tempsmallobj) {


        double d = 0;
        try {

            //System.out.println("^^^^^^^^^^^^^^^^^^^\n"+DBStatisticsHelper.getStmt8select1Statistics(sensorname));
            ResultSet rs = stmt.executeQuery(DBStatisticsHelper.getStmt8select1Statistics(sensorname));
            // NG[sČʃZbg擾

            // ꂽs[v

            while (rs.next()) {
                lightsmallobj.setLowband((int) Math.floor(rs.getDouble("light_low_band")));
                lightsmallobj.setHighband((int) Math.ceil(rs.getDouble("light_high_band")));
                lightsmallobj.setAve((int) rs.getDouble("lightavg"));

                movementsmallobj.setLowband((int) Math.floor(rs.getDouble("movement_low_band")));
                movementsmallobj.setHighband((int) Math.ceil(rs.getDouble("movement_high_band")));
                movementsmallobj.setAve((int) rs.getDouble("movementavg"));

                //System.out.println("rs.getDoubletemp_low_band"+rs.getDouble("temp_low_band"));
                //System.out.println("rs.getDoubletemp_high_band"+rs.getDouble("temp_high_band"));
                //ߑł
                tempsmallobj.setLowband((int) Math.floor(rs.getDouble("temp_low_band")) * 10);
                tempsmallobj.setHighband((int) Math.ceil(rs.getDouble("temp_high_band")) * 10);
                tempsmallobj.setAve((int) rs.getDouble("tempavg") * 10);
            /*
            tempsmallobj.setLowband((int)Math.floor(rs.getDouble("temp_low_band")));
            tempsmallobj.setHighband((int)Math.ceil(rs.getDouble("temp_high_band")));
            tempsmallobj.setAve((int)rs.getDouble("tempavg"));
             * */

            }


        } catch (SQLException ex) {
            Logger.getLogger(DBConnectionModule.class.getName()).log(Level.SEVERE, null, ex);
        }
        return d;
    }
}
