package jp.osoite.tomu.spot.send;

import com.sun.spot.io.j2me.radiogram.RadiogramConnection;
import com.sun.spot.peripheral.Spot;
import com.sun.spot.sensorboard.EDemoBoard;
import com.sun.spot.sensorboard.io.IScalarInput;
import com.sun.spot.sensorboard.peripheral.ITemperatureInput;
import com.sun.spot.sensorboard.peripheral.ITriColorLED;
import com.sun.spot.util.Utils;
import com.sun.spot.sensorboard.peripheral.ISwitch;
import com.sun.spot.sensorboard.peripheral.ISwitchListener;

import javax.microedition.io.Connector;
import javax.microedition.io.Datagram;
import javax.microedition.midlet.MIDlet;
import javax.microedition.midlet.MIDletStateChangeException;

import java.io.IOException;
import java.util.Random;

public class Sender extends MIDlet implements ISwitchListener {

    private double PERIOD_SEC = 5.0*2;  // in milliseconds
    //private boolean isEnagySavingMode = true;
    private boolean isEnagySavingMode = false;
    
    public static final int MAX_LED_ST = 120;
    public static final int MAX_RAIDO_POWER = 31;
    //public static final int MAX_RAIDO_POWER = -32;
    public static final byte MSG_TYPE = 0x1;
    //private static final int COLOR_LEVEL = 80;
    //private static final int COLOR_MAXVAL = 75;
    private static final int LED_PORT_NUM_SENDING = 5;
    private static final int LED_PORT_NUM_SENDING_E = 1;
    private static final int LED_BLINK_TIMER = 3;
    private static final int RCON_HOST_PORT = 67;
    private ISwitch sw1,  sw2;      // Variables to hold the two switches.
    private ITriColorLED[] leds;
    private RadiogramConnection rCon = null;
    private Datagram dg = null;
    private ITemperatureInput tempSensor;
    private IScalarInput lightSensor;
    private int counter = 0;
    private int skipFlag;
    private boolean sendagain = false;

    //private int switchNum=0;
    private void ledsBlink() {
        ledsBlink(MAX_LED_ST, MAX_LED_ST, MAX_LED_ST);
    }

    public void ledsBlink(int r, int g, int b) {
        if (r > MAX_LED_ST || g > MAX_LED_ST || b > MAX_LED_ST) {
            r = r % MAX_LED_ST;
            g = g % MAX_LED_ST;
            b = b % MAX_LED_ST;
        } else if (r < 5 && g < 5 && b < 5) {
            //r=10;
            g = 10;
        //b=10;
        }
        Utils.sleep(5);
        for (int j = 0; j < 7; j++) {
            leds[j].setRGB(r, g, b);
            leds[j].setOn();
        }
        Utils.sleep(25);
        for (int j = 0; j < 7; j++) {
            leds[j].setOff();
        }
        Utils.sleep(25);
    }

    public void setups() {

        leds = EDemoBoard.getInstance().getLEDs();
        ledsBlink();

        Spot.getInstance().getRadioPolicyManager().setOutputPower(MAX_RAIDO_POWER);

        try {
            monitorSwitches();
        } catch (IOException ex) { //A problem in reading the sensors.
            ex.printStackTrace();
        }
        showPeriodinLEDS();

        tempSensor = EDemoBoard.getInstance().getADCTemperature();
        lightSensor = EDemoBoard.getInstance().getLightSensor();

        try {
            // Open up a broadcast connection to the host port
            // where the 'on Desktop' portion of this demo is listening
            rCon = (RadiogramConnection) Connector.open("radiogram://broadcast:" + RCON_HOST_PORT);
            dg = rCon.newDatagram(rCon.getMaximumLength());  // only sending 12 bytes of data

        } catch (Exception e) {
            System.err.println("Caught " + e + " in connection initialization.");
            System.exit(1);
        }

        /*
        Random rand = new Random();
        int colorR = rand.nextInt() % COLOR_MAXVAL;
        int colorG = rand.nextInt() % COLOR_MAXVAL;
        int colorB = rand.nextInt() % COLOR_MAXVAL;
        if ((colorR + colorG + colorB) < 15) {
        colorG = 30;
        }*/
        int colorR = 0;
        int colorB = 0;
        int colorG = 15;

        leds[LED_PORT_NUM_SENDING].setRGB(colorR, colorG, colorB);
        leds[LED_PORT_NUM_SENDING_E].setRGB(0, 30, 0);

    }

    protected void startApp() throws MIDletStateChangeException {
        setups();

        float moving = 0;

        float movingmin = 0;
        float movingmax = 0;
        float movingPre = 0;
        float battRemain = 0;


        float accelx = 0, accely = 0, accelz = 0;
        float tiltx = 0, tilty = 0, tiltz = 0;
        try {
            accelx = AccelerometerSingleton.getInstance().getAccelX();
            accely = AccelerometerSingleton.getInstance().getAccelY();
            accelz = AccelerometerSingleton.getInstance().getAccelZ();
            tiltx = AccelerometerSingleton.getInstance().getTiltX();
            tilty = AccelerometerSingleton.getInstance().getTiltY();
            tiltz = AccelerometerSingleton.getInstance().getTiltZ();

        } catch (IOException ex) {
            ex.printStackTrace();
        }


        String ourAddress = System.getProperty("IEEE_ADDRESS");
        //long loopStartTimer = 0L;
        long loopStartTimer = 0;

        //double tempVal=0.0;
        float tempVal = 0;
        float tempValPre = 0;


        int lightVal = 0;
        int lightValPre = 0;
        try {
            tempValPre = tempSensor.getValue();
            lightValPre = lightSensor.getValue();
        } catch (IOException ex) {
            ex.printStackTrace();
        }


        System.out.println("Starting sensor sampler application on " +
                ourAddress + " ...");

        int dur = 0;

        int PERIOD_SAMPLELING_MILLS = (int) (PERIOD_SEC * 1000);  // in milliseconds
        int skiptimer = 0;
        dur = PERIOD_SAMPLELING_MILLS;

        while (true) {
            try {

                // Get the current time and sensor reading
                loopStartTimer = System.currentTimeMillis();
                lightVal = (lightSensor.getValue() + lightValPre) / 2;
                //tempValPre=tempVal;
                //AccelerometerSingleton.getInstance().checkAccels();
                //AccelerometerSingleton.getInstance().checkAccelsRelative();
                accelx = AccelerometerSingleton.getInstance().getAccelX();
                accely = AccelerometerSingleton.getInstance().getAccelY();
                accelz = AccelerometerSingleton.getInstance().getAccelZ();
                tiltx = AccelerometerSingleton.getInstance().getTiltX();
                tilty = AccelerometerSingleton.getInstance().getTiltY();
                tiltz = AccelerometerSingleton.getInstance().getTiltZ();

                try {
                    tempVal = (float) tempSensor.getCelsius();
                } catch (IOException ex) {
                    ex.printStackTrace();
                }


                skipFlag = 0;
                if (isEnagySavingMode) {
                    moving = (1 * abs(accelx) + abs(accely) + abs(accelz) + abs(tiltx) + 1 * abs(tilty) + abs(tiltz));
                    if (movingmin > moving) {
                        movingmin = moving;
                    } else if (movingmax < moving) {
                        movingmax = moving;
                    }
                    //System.out.println("min=" + movingmin + ",max=" + (int) movingmax + ",range=" + abs(movingmax - movingmin));
                }


                if (isEnagySavingMode) {
                    if (abs(movingmax - movingmin) < (0.015 + 0.01)) {
                        skipFlag += 100;
                    }


                    if (skiptimer < 10) {
                        skipFlag += 5;
                    }

                    if (abs(lightVal - lightValPre) < 2.0 + 6.0 || lightVal > 350) {
                        skipFlag += 10;
                    }

                    if (abs(tempVal - tempValPre) < 0.49 || tempVal > 47) {
                        skipFlag += 20;
                    //System.out.println("tempVal=" + tempVal+",tempValPre=" + tempValPre);
                    }



                }

                System.out.println("skipFlag=" + skipFlag);
                
                if (skipFlag == 135 && sendagain == false) {

                    leds[LED_PORT_NUM_SENDING_E].setOn();
                    skiptimer++;
                    Utils.sleep(LED_BLINK_TIMER);
                    leds[LED_PORT_NUM_SENDING_E].setOff();

                } else {

                    leds[LED_PORT_NUM_SENDING].setOn();

                    if (isEnagySavingMode) {
                        movingmin = movingPre;
                        movingmax = movingPre;
                    }

                    battRemain = BatterySingleton.getInstance().getAvailableCapacity();

                    dg.reset();
                    dg.writeByte(MSG_TYPE);

                    dg.writeInt(counter);
                    counter++;
                    //dg.writeShort((lightVal + lightValPre) / 2);
                    dg.writeShort(lightVal);
                    dg.writeFloat(battRemain);

                    //dg.writeFloat((tempVal + tempValPre) / 2);
                    dg.writeFloat(tempVal);

                    dg.writeFloat(accelx);
                    dg.writeFloat(accely);
                    dg.writeFloat(accelz);

                    dg.writeFloat(tiltx);
                    dg.writeFloat(tilty);
                    dg.writeFloat(tiltz);

                    dg.writeInt(PERIOD_SAMPLELING_MILLS + skiptimer);

                    //jikken
                    //System.out.println(MSG_TYPE + ":" + counter + ":" + lightVal + ":" + battRemain + ":" + tempVal + ":" + accelx + ":" + tiltx + ":" + PERIOD_SAMPLELING_MILLS + skiptimer);

                    try {
                        //System.out.println("dg"+dg);
                        rCon.send(dg);

                    } catch (Exception e) {
                        System.err.println("Caught " + e + " while collecting/sending sensor sampling.");
                    }

                    skiptimer = 0;

                    if (0 < skipFlag && skipFlag < 100) {
                        sendagain = true;
                    } else {
                        sendagain = false;
                    }
                    Utils.sleep(LED_BLINK_TIMER);

                }//else end

                //System.out.println("Light value = " + lightVal);
                leds[LED_PORT_NUM_SENDING].setOff();

                lightValPre = (lightVal + lightValPre) / 2;
                tempValPre = tempVal;


                dur = (int) (PERIOD_SAMPLELING_MILLS - (System.currentTimeMillis() - loopStartTimer));

                if (dur < 250) {
                    System.out.println("the period is too shord to communicate dur" + dur);
                }
                // Go to sleep to conserve battery

                if (isEnagySavingMode) {
                    //PERIOD_SAMPLELING_MILLS=(int)(((int)(lightVal/100)+1)*PERIOD_SEC*1000);
                    PERIOD_SAMPLELING_MILLS = (int) (PERIOD_SEC * 1000);
                    //System.out.println("PERIOD_SAMPLELING_MILLS"+PERIOD_SAMPLELING_MILLS+",lightVal"+lightVal);
                    movingPre = moving;
                }

                Utils.sleep(dur);

            } catch (Exception e) {
                System.err.println("Caught " + e + " while collecting/sending sensor sampling.");
            }
        }
    }

    public void switchPressed(ISwitch sw) {
        int switchNum = (sw == sw1) ? 1 : 2;
        System.out.println("Switch " + switchNum + " closed.");
        if (sw == sw1) {

            if (PERIOD_SEC > 0.5) {
                PERIOD_SEC -= 0.5;
                ledsBlink(MAX_LED_ST, 0, 0);

            }
        } else {
            PERIOD_SEC += 0.5;
            ledsBlink(0, MAX_LED_ST, 0);

        }
    }

    public void switchReleased(ISwitch sw) {
        int switchNum = (sw == sw1) ? 1 : 2;
        System.out.println("Switch " + switchNum + " opened.");
    }

    private void showPeriodinLEDS() {
        int i = (int) (PERIOD_SEC + 0.5);
        while (i > 0) {
            ledsBlink();
            i--;
        }
    }

    private float abs(float x) {
        if (x < 0) {
            return x * -1;
        } else {
            return x;
        }
    }

    private void monitorSwitches() throws IOException {

        sw1 = EDemoBoard.getInstance().getSwitches()[EDemoBoard.SW1];
        sw2 = EDemoBoard.getInstance().getSwitches()[EDemoBoard.SW2];

        sw1.addISwitchListener(this);       // enable automatic notification of switches
        sw2.addISwitchListener(this);

        System.out.println("Please press switch 1(-) or 2(+) during the next 10 seconds");
        Utils.sleep(10000);     // sleep for 30 seconds

        System.out.println("Time's up.");

        sw1.removeISwitchListener(this);    // disable automatic notification for switch 1

        //manuallyMonitorSwitch1();
        System.out.println("configlation end");
    }

    protected void pauseApp() {
        // This will never be called by the Squawk VM
    }

    protected void destroyApp(boolean arg0) throws MIDletStateChangeException {
        // Only called if startApp throws any exception other than MIDletStateChangeException
    }
}
