package jp.osoite.tomu.spot.send;

import com.sun.spot.sensorboard.EDemoBoard;
import com.sun.spot.sensorboard.peripheral.IAccelerometer3D;
import java.io.IOException;

public class AccelerometerSingleton {
    private static AccelerometerSingleton accsingletone=null;
    private IAccelerometer3D accelerometer;

    private AccelerometerSingleton() {
        accelerometer = EDemoBoard.getInstance().getAccelerometer();
    }

    public static AccelerometerSingleton getInstance(){
        if(accsingletone==null){
            accsingletone=new AccelerometerSingleton();
        }
        return accsingletone;
    }

    public float getTiltX() throws IOException {
        return (float)accelerometer.getTiltX();
    }

    public float getTiltY() throws IOException {
        return (float)accelerometer.getTiltY();
    }

    public float getTiltZ() throws IOException {
        return (float)accelerometer.getTiltZ();
    }
    public float getAccelX() throws IOException {
        return (float)accelerometer.getAccelX();
    }

    public float getAccelY() throws IOException {
        return (float)accelerometer.getAccelY();
    }

    public float getAccelZ() throws IOException {
        return (float)accelerometer.getAccelZ();
    }

    public void checkAccels()  {
        try {
            
            System.out.println("ax,ay,az"+accelerometer.getAccelY() + ":" + accelerometer.getAccelX() + ":" + accelerometer.getAccelX());
            System.out.println("getAccel()"+accelerometer.getAccel());
            System.out.println("lax,lay,laz"+accelerometer.getRelativeAccelY() + ":" + accelerometer.getRelativeAccelX() + ":" + accelerometer.getRelativeAccelX());
            System.out.println("getRelativeAccel()"+accelerometer.getRelativeAccel());
            
        } catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void checkAccelsRelative()  {
        try {
            System.out.println("lax,lay,laz"+accelerometer.getRelativeAccelY() + ":" + accelerometer.getRelativeAccelX() + ":" + accelerometer.getRelativeAccelX());

        } catch (IOException ex) {
            ex.printStackTrace();
        }
    }
    
}
