package jp.osoite.tomu.xmpp.core;

import javax.xml.bind.JAXBException;
import jp.osoite.tomu.core.main.AnotherSfeerThread;
import jp.osoite.tomu.xml.jaxb.object.TomuMessage;
import jp.osoite.tomu.xml.jaxb.util.JAXBConverter;
import jp.osoite.tomu.xml.jaxb.util.TomuMessagePrinter;
import jp.osoite.tomu.xml.jaxb.util.TomuMessageSwitchManager;

/**
 *
 * @author Administrator
 */
public class XMPPMessageReceiverImple extends MessageReceiver {

    private TomuMessageSwitchManager switchManager;

    public XMPPMessageReceiverImple() {

        switchManager = new TomuMessageSwitchManager();
        switchManager.addUploadKito2Listener(new UploadKito2ListenerImple());
        switchManager.addUploadPedestrianListener(new UploadPedestrianListenerImple());
        switchManager.addUploadTScanListener(new UploadTScanListenerImple());
        if (!AnotherSfeerThread.IS_ENABLED) {
            switchManager.addInitRequestSfeerListener(new InitRequestSfeerMinimumSQL());
            switchManager.addRequestSfeerListener(new RequestSfeerMinimumSQL());
        }
    }

    @Override
    public void receive(String message) {
        if (message.contains("[Ping]")) {
            System.out.println(message);
            String account = message.substring(message.indexOf("#") + 1);
            //manager.send(account, " * Hello, " + setting.getAccount() + " received your ping message.");
        } else {
            try {
                TomuMessage tomuMsg = JAXBConverter.convertToObj(message);
                //TomuMessagePrinter.print(tomuMsg);
                TomuMessagePrinter.printMinimum(tomuMsg);
                switchManager.switchMessage(tomuMsg);
            } catch (JAXBException ex) {
                System.out.println("Error : " + message);
            }
        }
    }
}
