package jp.osoite.tomu.xmpp.core;

import jp.osoite.tomu.xmpp.util.XMPPSetting;

/**
 * 2010/7/7 shima修正
 * @author tailor
 */
public class XMPPManagersFactory {

    private final static XMPPManagersFactory FACTORY = new XMPPManagersFactory();
    private XMPPManager[] xmppmgr;
    private XMPPManager sfeerRecv;

    private XMPPManagersFactory() {
        xmppmgr = new XMPPManager[3];
    }

    public static XMPPManagersFactory getInstance() {
        return FACTORY;
    }

    public boolean isExist(int num) {
        if (xmppmgr[num] != null) {
            return true;
        } else {
            return false;
        }
    }

    public XMPPManager createXMPPManager(int num, MessageReceiver recv) {
        if (xmppmgr[num] == null) {
            XMPPSetting setting = new XMPPSetting("tomuxmpp" + (num + 1) + "@gmail.com", "osoiteTomu");
            xmppmgr[num] = new XMPPManager(setting, recv);
            return xmppmgr[num];
        } else {
            System.out.println("already exist");
            return null;
        }
    }

    public XMPPManager createSfeerReceiverManager(MessageReceiver recv) {
        XMPPSetting setting = new XMPPSetting("tomusfeerrecv@gmail.com", "osoiteTomu");
        sfeerRecv = new XMPPManager(setting, recv);
        return sfeerRecv;
    }

    public XMPPManager getXMPPManager(int num) {
        if (xmppmgr[num] == null) {
            System.out.println("errr not created : " + num);
            return null;
        }
        return xmppmgr[num];
    }

    public XMPPManager getSfeerReceiverManager(int num) {
        if(sfeerRecv == null){
            throw new NullPointerException();
        }
        return sfeerRecv;
    }

}
