package jp.osoite.tomu.xmpp.core;

import jp.osoite.tomu.core.db.DBConnectionModule;
import jp.osoite.tomu.core.db.mysql.builder.PedestrianInsertSQLBuilder;
import jp.osoite.tomu.net.mail.JavaMailSend;
import jp.osoite.tomu.net.mail.MailScheduleManager;
import jp.osoite.tomu.util.TimeConverter;
import jp.osoite.tomu.xml.jaxb.wrapper.UploadPedestrianWrapper;
import jp.osoite.tomu.xml.jaxb.wrapper.listener.UploadPedestrianListener;

public class UploadPedestrianListenerImple implements UploadPedestrianListener {

    private PedestrianInsertSQLBuilder builder;

    public UploadPedestrianListenerImple() {
        try {
            builder = new PedestrianInsertSQLBuilder(DBConnectionModule.getInstance().getConnection(), "data_ped");
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void receiveUploadPedestrian(UploadPedestrianWrapper wrapper) {


        DBTABASE_insert:
        {
            //MainController.getInstance().addPedestrianWrapper(wrapper);
            long startTimer = System.currentTimeMillis();
            try {
                builder.excecute(wrapper);
            } catch (Exception e) {
                e.printStackTrace();
            }
            /**
            String insertStmtStrPed = PedestrianDBHelper.getPEDSQLInsertStmtwithWrapper(wrapper, DBConnectionModule.PEDESTRIAN_DATA_TABLE_NAME);
            try {
            DBConnectionModule.getInstance().getStatement().executeUpdate(insertStmtStrPed);
            } catch (SQLException ex) {
            Logger.getLogger(UploadPedestrianListenerImple.class.getName()).log(Level.SEVERE, null, ex);
            }
             */
            System.out.println(">>> \"data_ped\" table inserted\n");
        }

        GUI:
        {
        }

        MAIL:
        {
            MailScheduleManager.getInstance().stop(wrapper.getSensorId());
            String aMsg = "The Latest Pedestrian data is : ID=" + wrapper.getSensorId() + " \n get time =" + TimeConverter.convertToString(wrapper.getSensedTime()) + "\n";
            MailScheduleManager.getInstance().start(JavaMailSend.TO_MAIL_ADDRESS_PED, wrapper.getSensorId(), 3 * 60 * 1000 + 100, aMsg);
        }

    }
}
