/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package jp.osoite.tomu.xmpp.core;

import java.util.logging.Level;
import java.util.logging.Logger;
import jp.osoite.tomu.xml.jaxb.wrapper.listener.UploadKito2Listener;
import jp.osoite.tomu.xml.jaxb.wrapper.UploadKito2Wrapper;
import jp.osoite.tomu.core.db.DBConnectionModule;
import jp.osoite.tomu.net.mail.JavaMailSend;
import jp.osoite.tomu.net.mail.MailScheduleManager;
import jp.osoite.tomu.util.TimeConverter;

/**
 *
 * @author tailor
 */
public class UploadKito2ListenerImple implements UploadKito2Listener {

    //List<UploadKito2Wrapper> kito2ResultList = new ArrayList<UploadKito2Wrapper>();

    public void receiveUploadKito2(UploadKito2Wrapper kito2obj) {
        inserttoDB(kito2obj);
    }

    private void inserttoDB(UploadKito2Wrapper kito2obj) {

        long timer_test=System.currentTimeMillis();


        try {            
            DBConnectionModule.getInstance().receiveKito2wobjFromSensorSource(kito2obj);
            //System.out.println("経過時間K1:"+(System.currentTimeMillis()-timer_test));

            MailScheduleManager.getInstance().stop(kito2obj.getSensorId());

            //System.out.println("経過時間K2:"+(System.currentTimeMillis()-timer_test));
            String aMsg= "The Latest Kito2 data is : ID=" + kito2obj.getSensorId() + " \n get time =" + TimeConverter.convertToString(kito2obj.getSensedTime()) + "\n";
            MailScheduleManager.getInstance().start(JavaMailSend.TO_MAIL_ADDRESS_KITO2,kito2obj.getSensorId(),20 * 60 * 1000 + 100,aMsg);

            //System.out.println("経過時間K3:"+(System.currentTimeMillis()-timer_test));

            
        } catch (Exception ex) {
            Logger.getLogger(UploadKito2ListenerImple.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}
