package jp.osoite.tomu.xmpp.core;

import javax.xml.bind.JAXBException;
import jp.osoite.tomu.xml.jaxb.object.TomuMessage;
import jp.osoite.tomu.xml.jaxb.util.JAXBConverter;
import jp.osoite.tomu.xml.jaxb.util.TomuMessagePrinter;
import jp.osoite.tomu.xml.jaxb.util.TomuMessageSwitchManager;

/**
 *
 * @author shima
 */
public class SfeerMessageReceiver extends MessageReceiver {

    private TomuMessageSwitchManager switchManager;

    public SfeerMessageReceiver() {
        switchManager = new TomuMessageSwitchManager();
        switchManager.addInitRequestSfeerListener(new InitRequestSfeerMinimumSQL());
        switchManager.addRequestSfeerListener(new RequestSfeerMinimumSQL());
    }

    @Override
    public void receive(String message) {
        try {
            TomuMessage tomuMsg = JAXBConverter.convertToObj(message);
            TomuMessagePrinter.printMinimum(tomuMsg);
            switchManager.switchMessage(tomuMsg);
        } catch (JAXBException ex) {
            System.out.println("Error : " + message);
        }
    }
}
