package jp.osoite.tomu.xmpp.core;

import java.net.URL;
import java.sql.Timestamp;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.GregorianCalendar;
import java.util.List;

import jp.osoite.tomu.core.db.DBConnectionModule;
import jp.osoite.tomu.core.db.sqlbuilder.ItreeSQLBuilder.ITreeTableItem;
import jp.osoite.tomu.net.xmpp.XMPPDeamonRunnable;
import jp.osoite.tomu.util.TimeConverter;
import jp.osoite.tomu.xml.jaxb.object.TomuMessage;
import jp.osoite.tomu.xml.jaxb.util.JAXBConverter;
import jp.osoite.tomu.xml.jaxb.util.builder.AppsResponseBuilder;
import jp.osoite.tomu.xml.jaxb.wrapper.Axis;
import jp.osoite.tomu.xml.jaxb.wrapper.Axis.Direction;
import jp.osoite.tomu.xml.jaxb.wrapper.TScanValue;

/**
 *
 * @author shima
 */
public class RequestITreeImpl {

    private XMPPManager manager;
    private PreparedStatement selectTScanData;
    private PreparedStatement selectPedestrianData;
    private PreparedStatement selectKito2Data;
    private AppsResponseBuilder builder;
    private int sfeerRequestSeq = 0;
    private Axis preAxis;
    private double preTemp = 0;
    private int preRegNum = 0;
    private static final boolean DEBUG = true;

    public RequestITreeImpl() {
        try {
            Connection con = DBConnectionModule.getInstance().getConnection();
            selectTScanData = con.prepareStatement("SELECT * FROM data_tscan WHERE tscan_id = ? AND sensed_time = ?");
            selectPedestrianData = con.prepareStatement("SELECT * FROM data_ped WHERE sensorid = ? AND timestamp = ?");
            selectKito2Data = con.prepareStatement("SELECT * FROM data_kito2 WHERE sensorid = ? AND timestamp = ?");
        } catch (SQLException ex) {
            if (DEBUG) {
                ex.printStackTrace();
            }
        }
    }

    public void initBuilder(String srcId, String destId, long mesId) {
        builder = new AppsResponseBuilder(srcId, destId, mesId, sfeerRequestSeq++);
    }

    public void send(){
        TomuMessage msg = builder.build();
        sendMessage(msg);
    }

    public void receive(List<ITreeTableItem> list) {
        for (ITreeTableItem item : list) {
            String type = item.getSensorType();
            System.out.println("---------- Type : " + type);
            if (type.equals("TSCAN")) {
                searchTScanSensor(item.getSensorId(), item.getSensedTime(), builder);
            } else if (type.equals("KITO2")) {
                searchKito2Sensor(Long.parseLong(item.getSensorId()), item.getSensedTime(), builder);
            } else if (type.equals("PEDESTRIAN")) {
                searchPedestrianSensor(Long.parseLong(item.getSensorId()), item.getSensedTime(), builder);
            }
        }
    }

    private void searchTScanSensor(String id, Timestamp time, AppsResponseBuilder builder) {
        long currentTime = System.currentTimeMillis();
        try {
            selectTScanData.setString(1, id);
            selectTScanData.setTimestamp(2, time);
            ResultSet resultSet = selectTScanData.executeQuery();
            while (resultSet.next()) {
                TScanValue val = new TScanValue(
                        resultSet.getString("tscan_id"),
                        resultSet.getTimestamp("sensed_time").getTime(),
                        resultSet.getDouble("temperature"),
                        resultSet.getDouble("humidity"),
                        resultSet.getInt("lqi"),
                        resultSet.getInt("voltage"));
                if (DEBUG) {
                    System.out.println("* Add TScan = ID : " + id + " Temp : " + val.getTemperature() + " Time : " + TimeConverter.convertToString(val.getSensedTime()));
                }
                preTemp = val.getTemperature();
                if (preTemp > 60) {
                    continue;
                }
                currentTime = val.getSensedTime();
                break;
            }
            builder.addTemperatureSensor(System.currentTimeMillis(), preTemp, currentTime);
        } catch (Exception e) {
            if (DEBUG) {
                e.printStackTrace();
            }
        }
    }

    private void searchPedestrianSensor(long id, Timestamp time, AppsResponseBuilder builder) {
        long currentTime = System.currentTimeMillis();
        try {
            selectPedestrianData.setLong(1, id);
            selectPedestrianData.setTimestamp(2, time);
            ResultSet resultSet = selectPedestrianData.executeQuery();
            if (resultSet.next()) {
                if (DEBUG) {
                    System.out.println("Search Ped : " + id);
                }
                preAxis = new Axis();
                preAxis.setValue(resultSet.getInt("chief_plus_compass"),
                        resultSet.getInt("chief_plus_num"),
                        resultSet.getDouble("chief_plus_speed"),
                        Direction.PLUS);
                preAxis.setValue(resultSet.getInt("chief_minus_compass"),
                        resultSet.getInt("chief_minus_num"),
                        resultSet.getDouble("chief_minus_speed"),
                        Direction.MINUS);
                currentTime = resultSet.getTimestamp("timestamp").getTime();
                preRegNum = resultSet.getInt("residence_num");
                if (DEBUG) {
                    System.out.println("* Add Ped = ID : " + id + " Axis : " + preAxis + " Time : " + TimeConverter.convertToString(resultSet.getTimestamp("timestamp").getTime()));
                    System.out.println(" Resi : " + preRegNum);
                    System.out.println(" Axis Plus : " + preAxis.getCompass(Direction.PLUS) + " " + preAxis.getFlowValue(Direction.PLUS) + " " + preAxis.getAverageSpeed(Direction.PLUS));
                    System.out.println(" Axis Minus : " + preAxis.getCompass(Direction.MINUS) + " " + preAxis.getFlowValue(Direction.MINUS) + " " + preAxis.getAverageSpeed(Direction.MINUS));
                }
            }
            builder.addPedestrianSensor(id, currentTime, 60, preRegNum, preAxis);
        } catch (Exception e) {
            if (DEBUG) {
                e.printStackTrace();
            }
        }
    }

    private void searchKito2Sensor(long id, Timestamp time, AppsResponseBuilder builder) {
        try {
            selectKito2Data.setLong(1, id);
            selectKito2Data.setTimestamp(2, time);
            ResultSet resultSet = selectKito2Data.executeQuery();
            while (resultSet.next()) {
                builder.addImageSensor(Long.toString(id),
                        resultSet.getTimestamp("timestamp").getTime(),
                        resultSet.getInt("compass"),
                        resultSet.getDouble("latitude"),
                        resultSet.getDouble("longitude"),
                        new URL(resultSet.getString("url")),
                        new URL(resultSet.getString("thumbnail_url")));
            }
        } catch (Exception e) {
            if (DEBUG) {
                e.printStackTrace();
            }
        }
    }

    private void sendMessage(TomuMessage msg) {
        try {
            if (manager == null) {
                manager = XMPPManagersFactory.getInstance().getXMPPManager(XMPPDeamonRunnable.DEF_TOMU_NUM);
            }
            String xml = JAXBConverter.convertToXml(msg);
            manager.send(msg.getHead().getMsgDest(), xml);
            if (DEBUG) {
                System.out.println("> Send Message : " + msg.getHead().getMsgDest());
            }
        } catch (Exception e) {
            if (DEBUG) {
                e.printStackTrace();
                System.out.println("SfeerRequest sending message: ERR " + msg.getHead().getMsgDest());
            }
        }
    }
}
