/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package jp.osoite.tomu.xmpp.core;

import java.sql.BatchUpdateException;
import jp.osoite.tomu.xml.jaxb.object.TomuMessage;
import jp.osoite.tomu.xml.jaxb.util.builder.DummyTomuMessageFactory;
import jp.osoite.tomu.xml.jaxb.util.builder.DummyTomuMessageFactory.DummyMessageType;
import jp.osoite.tomu.xml.jaxb.wrapper.UploadKito2Wrapper;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import jp.osoite.tomu.usml.Config;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import jp.osoite.tomu.util.TimeConverter;
import jp.osoite.tomu.xml.jaxb.util.TomuMessageType;
import jp.osoite.tomu.xml.jaxb.util.builder.JAXBConstructor;

/**
 *
 * @author tomu
 */
public class KodamaKito2DummyInsert {

    String DATABASE_URL = "";
    String DATABASE_NAME = "";
    String DATABASE_USER = "";
    String DATABASE_PASSWORD = "";
    String JDBC_DRIVER = "";
    String SPOT_DATA_TABLE_NAME = "";
    String KITO2_DATA_TABLE_NAME = "data_kito2";
    private Statement statement = null;
    private java.sql.Connection dbCon = null;
    private String insertStmtStr;
    List<UploadKito2Wrapper> kito2ResultList = new ArrayList<UploadKito2Wrapper>();

    public void insertTesting() {
        System.out.println("Kito2DummyInsert");

        DATABASE_URL = Config.getInstance().getDATABASE_URL();
        DATABASE_NAME = Config.getInstance().getDATABASE_NAME();
        DATABASE_USER = Config.getInstance().getDATABASE_USER();
        DATABASE_PASSWORD = Config.getInstance().getDATABASE_PASSWORD();
        JDBC_DRIVER = Config.getInstance().getJDBC_DRIVER();
        SPOT_DATA_TABLE_NAME = Config.getInstance().getDATA_TABLE_NAME();
        System.out.println("Database demo application starting ... ");
        try {
            // Register the JDBC driver for mysql
            // This is typically found in a JAR file
            // named something like
            // mysql-connector-java-<version>-bin.jar
            // which should be in the classpath
            // See user.classpath in build.properties
            // for this Sun SPOT host application
            Class.forName(JDBC_DRIVER);
            // Define URL of database server for
            String url = DATABASE_URL + DATABASE_NAME;
            // Get a connection to the database for given user/password
            dbCon = DriverManager.getConnection(url, DATABASE_USER, DATABASE_PASSWORD);
            // Display URL and connection information
            System.out.println("URL: " + url);
            System.out.println("Connection: " + dbCon);
            System.out.println(">DB");


            try {
                // Get a Statement object
                statement = dbCon.createStatement();
            } catch (Exception e) {
                System.err.println("dbSetUp stmt: caught " + e.getMessage());
                throw e;
            }


            TomuMessage tomumsgobj;

            UploadKito2Wrapper kito2obj;

            for (int j = 0; j < 99; j++) {

                tomumsgobj = DummyTomuMessageFactory.getSourceUpload(DummyMessageType.IMAGE);
                kito2obj = new UploadKito2Wrapper(tomumsgobj);

                System.out.println("SensorId : " + kito2obj.getSensorId());
                System.out.println("timestamp : " + kito2obj.getSensedTime());
                System.out.println("compass : " + kito2obj.getCompass());
                System.out.println("latitude : " + kito2obj.getLatitude());
                System.out.println("longitude : " + kito2obj.getLongitude());
                System.out.println("dpi : " + kito2obj.getDpi());
                System.out.println("url : " + kito2obj.getImageUrl());
                System.out.println("thumbnail_url : " + kito2obj.getThumbnailUrl());

                String insertKito2Str = "INSERT INTO " + KITO2_DATA_TABLE_NAME + " " +
                        "(sensorid,timestamp,timer,compass,latitude,longitude,dpi,url,thumbnail_url)" +
                        " VALUES(\'" + kito2obj.getSensorId() + "\',\'" + TimeConverter.convertToString(kito2obj.getSensedTime()) + "\',\'0\',\'" + kito2obj.getCompass() + "\',\'" + kito2obj.getLatitude() + "\',\'" + kito2obj.getLongitude() + "\',\'" + kito2obj.getDpi() + "\',\'" + kito2obj.getImageUrl() + "\',\'" + kito2obj.getThumbnailUrl() + (j + 1) + "\')";


                try {
                    statement.executeUpdate(insertKito2Str);
                } catch (BatchUpdateException b) {
                    System.err.println("Update counts of successful commands: " + b);
                    int[] updateCounts = b.getUpdateCounts();
                    for (int i = 0; i < updateCounts.length; i++) {
                        System.err.print(updateCounts[i] + "  ");
                    }
                    System.err.println("");
                } catch (SQLException e) {
                    System.err.println("Caught " + e + " while storing kito2 vals: " + insertStmtStr);
                    throw e;
                } catch (Exception e) {
                    System.err.println("Caught " + e +
                            " while reading kito2 samples.");
                    throw e;
                }
            }

        } catch (Exception e) {
            System.err.println("setUp caught " + e);
            System.err.println("Make sure that mySQL is installed properly \n" + "and has a Test database accessible via the \n" + "default administrator settings on localhost:3306\n");
        //throw e;
        }
    }
    /*

    public class Kito2Comparator implements Comparator {

        double mLat, mLon;

        public Kito2Comparator(double latitude, double longitude) {
            mLat = latitude;
            mLon = longitude;
        }

        public int compare(Object ukw1, Object ukw2) {
            return (int) Math.round(getDistance(mLat, mLon, ((UploadKito2Wrapper) ukw1).getLatitude(), ((UploadKito2Wrapper) ukw1).getLongitude()) - getDistance(mLat, mLon, ((UploadKito2Wrapper) ukw2).getLatitude(), ((UploadKito2Wrapper) ukw2).getLongitude()));
        }

        private double getDistance(double lat1, double lon1, double lat2, double lon2) {
            return Math.sqrt(Math.pow((lon1 - lon2) * Math.cos((lat1 + lat2) / 2 / 180 * Math.PI), 2) + Math.pow(lat1 - lat2, 2));
        //http://oshiete.goo.ne.jp/qa/249931.html
        }
    }*/
}
