package jp.osoite.tomu.xmpp.core;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.osoite.tomu.core.db.DBConnectionModule;
import jp.osoite.tomu.net.xmpp.XMPPDeamonRunnable;
import jp.osoite.tomu.xml.jaxb.object.InitPedestrian;
import jp.osoite.tomu.xml.jaxb.object.InitTemperature;
import jp.osoite.tomu.xml.jaxb.object.TomuMessage;
import jp.osoite.tomu.xml.jaxb.util.JAXBConverter;
import jp.osoite.tomu.xml.jaxb.util.builder.SfeerInitResponseBuilder;
import jp.osoite.tomu.xml.jaxb.wrapper.AreaSetting;
import jp.osoite.tomu.xml.jaxb.wrapper.InitRequestSfeerWrapper;
import jp.osoite.tomu.xml.jaxb.wrapper.TScanValue;
import jp.osoite.tomu.xml.jaxb.wrapper.listener.InitRequestSfeerListener;

/**
 *
 * @author shima
 */
public class InitRequestSfeerMinimumSQL implements InitRequestSfeerListener {

    private static Map<Long, String> sensorIdMap;
    private XMPPManager manager;
    private PreparedStatement selectTScanId;
    private PreparedStatement selectTScanData;
    private PreparedStatement selectPedestrianId;
    private PreparedStatement selectPedestrianData;
    private static final boolean DEBUG = false;

    public InitRequestSfeerMinimumSQL() {
        try {
            Connection con = DBConnectionModule.getInstance().getConnection();
            selectTScanId = con.prepareStatement("SELECT * FROM location_tscan");
            selectPedestrianId = con.prepareStatement("SELECT * FROM location_ped");
            selectTScanData = con.prepareStatement("SELECT * FROM data_tscan WHERE tscan_id = ? ORDER BY sensed_time DESC LIMIT 100");
            selectPedestrianData = con.prepareStatement("SELECT * FROM data_ped WHERE sensorid = ? ORDER BY timestamp DESC LIMIT 5");
        } catch (SQLException ex) {
            ex.printStackTrace();
        }
    }

    public static Map<Long, String> getSensorIdMap() {
        if (sensorIdMap == null) {
            sensorIdMap = new HashMap<Long, String>();
        }
        return sensorIdMap;
    }

    public void receiveInitRequestSfeer(InitRequestSfeerWrapper wrapper) {
        if (DEBUG) {
            System.out.println("> Received SfeerInitRequest");
        }
        SfeerInitResponseBuilder builder = new SfeerInitResponseBuilder(wrapper.getSourceId(), "tomuxmpp1@gmail.com", wrapper.getMessageId());
        List<AreaSetting> list = wrapper.getAreaSettingList();
        for (AreaSetting area : list) {
            if (DEBUG) {
                System.out.println("===== SfeerInitRequest: AreaID " + area.getAreaId());
            }
            InitTemperature initTemp = getInitTemperature(area, builder);
            InitPedestrian initPed = getInitPedestrian(area, builder);
            builder.addArea(area.getAreaId(), initTemp, initPed);
            if (DEBUG) {
                System.out.println("SfeerInitRequest: InitTemp " + initTemp);
                System.out.println("SfeerInitRequest: InitPed " + initPed);
            }
        }
        TomuMessage msg = builder.build();
        sendMessage(msg);
    }

    private InitTemperature getInitTemperature(AreaSetting area, SfeerInitResponseBuilder builder) {
        InitTemperature result = null;
        try {
            double dist = 0;
            double preDist = Double.MAX_VALUE;
            String nearestTscanId = null;
            long nearestSensorId = 0;
            ResultSet resultSet = selectTScanId.executeQuery();
            sensorIdMap = new HashMap<Long, String>();
            while (resultSet.next()) {
                dist = CoordsCalculater.calcDistHubeny(area.getLat(), area.getLon(), resultSet.getDouble("latitude"), resultSet.getDouble("longitude"));
                String tscanId = resultSet.getString("tscan_id");
                long sensorId = resultSet.getLong("sensor_id");
                sensorIdMap.put(sensorId, tscanId);
                if (nearestTscanId == null || dist < preDist) {
                    preDist = dist;
                    nearestTscanId = tscanId;
                    nearestSensorId = sensorId;
                }
            }
            if (DEBUG) {
                System.out.println("TScan ID : " + nearestTscanId);
                System.out.println("Sensor ID : " + nearestSensorId);
            }

            selectTScanData.setString(1, nearestTscanId);
            resultSet = selectTScanData.executeQuery();
            List<TScanValue> list = new ArrayList<TScanValue>();
            if (DEBUG) {
                System.out.print("Init Temp : ");
            }
            while (resultSet.next()) {
                TScanValue val = new TScanValue(
                        resultSet.getString("tscan_id"),
                        resultSet.getTimestamp("sensed_time").getTime(),
                        resultSet.getDouble("temperature"),
                        resultSet.getDouble("humidity"),
                        resultSet.getInt("lqi"),
                        resultSet.getInt("voltage"));
                list.add(val);
                if (DEBUG) {
                    System.out.print(val.getTemperature() + " ");
                }
            }
            if (DEBUG) {
                System.out.println();
            }

            double[] fiveValue = new double[5];
            double max = 0.0;
            double min = 0.0;
            double avg = 0.0;
            if (!list.isEmpty()) {
                max = Double.MIN_VALUE;
                min = Double.MAX_VALUE;
                double preData = 0;
                avg = 0.0;
                int i = 0;
                for (TScanValue val : list) {
                    preData = val.getTemperature();
                    if (preData < 60) {
                        if (i < fiveValue.length) {
                            fiveValue[i] = preData;
                        }
                        if (preData > max) {
                            max = preData;
                        }
                        if (preData < min) {
                            min = preData;
                        }
                        avg += preData;
                        i++;
                    }
                }
                avg = avg / i;
                result = builder.getInitTemperature(nearestSensorId, fiveValue[0], max, min, avg, fiveValue);
            } else {
                result = builder.getInitTemperature(nearestSensorId, 0, max, min, avg, fiveValue);
            }
        } catch (Exception e) {
            if (DEBUG) {
                e.printStackTrace();
            }
        }
        return result;
    }

    private InitPedestrian getInitPedestrian(AreaSetting area, SfeerInitResponseBuilder builder) {
        InitPedestrian result = null;
        try {
            double dist = 0;
            double preDist = Double.MAX_VALUE;
            long nearestPedId = -1;
            ResultSet resultSet = selectPedestrianId.executeQuery();
            while (resultSet.next()) {
                dist = CoordsCalculater.calcDistHubeny(area.getLat(), area.getLon(), resultSet.getDouble("latitude"), resultSet.getDouble("longitude"));
                long sensorId = resultSet.getLong("sensor_id");
                if (nearestPedId == -1 || dist < preDist) {
                    preDist = dist;
                    nearestPedId = sensorId;
                }
            }
            selectPedestrianData.setLong(1, nearestPedId);
            ResultSet pedResult = selectPedestrianData.executeQuery();
            if (pedResult.next()) {
                int crrFlow = pedResult.getInt("sum_num_of_pedestrians");
                int crrReg = pedResult.getInt("residence_num");
                double avg = pedResult.getDouble("chief_plus_speed");
                result = builder.getInitPedestrian(nearestPedId, crrFlow, crrReg, avg);
            } else {
                result = builder.getInitPedestrian(nearestPedId, 0, 0, 0);
            }
        } catch (Exception e) {
            if (DEBUG) {
                e.printStackTrace();
            }
            result = null;
        }
        return result;
    }

    private void sendMessage(TomuMessage msg) {
        try {
            manager = XMPPManagersFactory.getInstance().getXMPPManager(XMPPDeamonRunnable.DEF_TOMU_NUM);
            String xml = JAXBConverter.convertToXml(msg);
            manager.send(msg.getHead().getMsgDest(), xml);
            if (DEBUG) {
                System.out.println("> Send Message : " + msg.getHead().getMsgDest());
            }
        } catch (Exception e) {
            if (DEBUG) {
                e.printStackTrace();
                System.out.println("SfeerInitRequest sending message: ERR " + msg.getHead().getMsgDest());
            }
        }
    }
}
