package jp.osoite.tomu.xmpp.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class GroupBroadcastReceiver extends MessageReceiver {

    private List<MessageReceiver> list;

    public GroupBroadcastReceiver() {
        list = Collections.synchronizedList(new ArrayList<MessageReceiver>());
    }

    public void addMessageReceiver(MessageReceiver recv){
        list.add(recv);
    }

    public void removeMessageReceiver(MessageReceiver recv){
        list.remove(recv);
    }

    @Override
    public void receive(String message) {
        for(MessageReceiver recv : list){
            recv.receive(message);
        }
    }

}
