package jp.osoite.tomu.xmpp.core;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;

import java.util.Random;
import jp.osoite.tomu.xml.jaxb.object.InitPedestrian;
import jp.osoite.tomu.xml.jaxb.object.InitTemperature;
import jp.osoite.tomu.xml.jaxb.object.TomuMessage;
import jp.osoite.tomu.xml.jaxb.util.JAXBConverter;
import jp.osoite.tomu.util.TimeConverter;
import jp.osoite.tomu.xml.jaxb.util.TomuMessageSwitchManager;
import jp.osoite.tomu.xml.jaxb.util.builder.AppsResponseBuilder;
import jp.osoite.tomu.xml.jaxb.util.builder.SfeerInitResponseBuilder;
import jp.osoite.tomu.xml.jaxb.wrapper.AreaSetting;
import jp.osoite.tomu.xml.jaxb.wrapper.Axis;
import jp.osoite.tomu.xml.jaxb.wrapper.Axis.Direction;
import jp.osoite.tomu.xml.jaxb.wrapper.InitRequestSfeerWrapper;
import jp.osoite.tomu.xml.jaxb.wrapper.Location;
import jp.osoite.tomu.xml.jaxb.wrapper.RequestSfeerWrapper;
import jp.osoite.tomu.xml.jaxb.wrapper.TomuMessageWrapper;
import jp.osoite.tomu.xml.jaxb.wrapper.UploadKito2Wrapper;
import jp.osoite.tomu.xml.jaxb.wrapper.UploadPedestrianWrapper;
import jp.osoite.tomu.xml.jaxb.wrapper.listener.InitRequestSfeerListener;
import jp.osoite.tomu.xml.jaxb.wrapper.listener.RequestSfeerListener;
import jp.osoite.tomu.xml.jaxb.wrapper.listener.UploadKito2Listener;
import jp.osoite.tomu.xml.jaxb.wrapper.listener.UploadPedestrianListener;
import jp.osoite.tomu.xmpp.core.MessageReceiver;
import jp.osoite.tomu.xmpp.core.XMPPManager;
import jp.osoite.tomu.xmpp.util.XMPPSetting;

/**
 *
 * @author shima
 */
public class DummyTomuRunner extends MessageReceiver
        implements
        InitRequestSfeerListener,
        RequestSfeerListener,
        UploadPedestrianListener,
        UploadKito2Listener {

    private TomuMessageSwitchManager switchManager;
    private XMPPSetting xmppSetting;
    private XMPPManager xmppManager;
    private static final double[] TEMPS = {31.3, 31.0, 31.8, 31.7, 31.7, 30.1, 29.8, 29.4, 29.5, 28.9, 29.5, 29.8, 30.3};
    private int tempsIndex = 0;
    private static final int[] PEDESTRIANS = {1, 3, 5, 3, 2, 2, 6, 4, 4, 3, 0, 8, 4};
    private int pedsIndex = 0;
    private int sfeerRequestSeq = 0;
    private static final Random RANDOM = new Random();
    private int[] areaIds;

    public DummyTomuRunner() {
        xmppSetting = new XMPPSetting("tomuxmpp1@gmail.com", "osoiteTomu");
        xmppManager = new XMPPManager(xmppSetting, this);
        switchManager = new TomuMessageSwitchManager();
        switchManager.addInitRequestSfeerListener(this);
        switchManager.addRequestSfeerListener(this);
        switchManager.addUploadKito2Listener(this);
        switchManager.addUploadPedestrianListener(this);
    }

    public void start() {
        if (xmppManager.login()) {
            System.out.println("Start DummyTomu : Stop command \"exit\"");
            BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
            try {
                while (!reader.readLine().equals("exit")) {
                }
            } catch (Exception e) {
            }
            xmppManager.logoff();
            System.out.println("Goodbye");
        } else {
            System.out.println("Exception");
        }
    }

    @Override
    public void receive(String message) {
        try {
            System.out.println("## Receive XML Message");
            System.out.println(" Received Time : " + TimeConverter.convertToString(System.currentTimeMillis()));
            TomuMessage msg = JAXBConverter.convertToObj(message);
            switchManager.switchMessage(msg);
        } catch (Exception e) {
            System.out.println("> JAXB Exception");
        }
    }

    private void sendMessage(TomuMessage msg) {
        try {
            String xml = JAXBConverter.convertToXml(msg);
            xmppManager.send(msg.getHead().getMsgDest(), xml);
            System.out.println("> Send Message : " + msg.getHead().getMsgDest());
        } catch (Exception e) {
        }
    }

    public void receiveInitRequestSfeer(InitRequestSfeerWrapper wrapper) {
        System.out.println("> Received SfeerInitRequest");
        printHeader(wrapper);
        SfeerInitResponseBuilder builder = new SfeerInitResponseBuilder(wrapper.getSourceId(), xmppSetting.getAccount(), wrapper.getMessageId());
        long sensorId = System.currentTimeMillis();
        List<AreaSetting> list = wrapper.getAreaSettingList();
        areaIds = new int[list.size()];
        int i = 0;
        for (AreaSetting area : list) {
            areaIds[i++] = area.getAreaId();
            sensorId += 1000;
            InitTemperature initTemp = builder.getInitTemperature(sensorId, 31.3, 32.5, 29.9, 30.6, new double[]{31.3, 31.0, 31.8, 31.7, 31.7});
            sensorId += 1000;
            InitPedestrian initPed = builder.getInitPedestrian(sensorId, 6, 11, 7.5);
            builder.addArea(area.getAreaId(), initTemp, initPed);
        }
        TomuMessage msg = builder.build();
        sendMessage(msg);
    }

    public void receiveRequestSfeer(RequestSfeerWrapper wrapper) {
        System.out.println("> Received SfeerRequest");
        printHeader(wrapper);
        AppsResponseBuilder builder = new AppsResponseBuilder(wrapper.getSourceId(), xmppSetting.getAccount(), wrapper.getMessageId(), sfeerRequestSeq++);

        long[] ids = wrapper.getTemperatureSensorIdList();
        for (long id : ids) {
            if (tempsIndex >= TEMPS.length) {
                tempsIndex = 0;
            }
            builder.addTemperatureSensor(id, TEMPS[tempsIndex++], System.currentTimeMillis());
        }

        ids = wrapper.getPedestrianSensorIdList();
        for (long id : ids) {
            Axis mainAxis = new Axis();
            if (++pedsIndex >= PEDESTRIANS.length) {
                pedsIndex = 0;
            }
            mainAxis.setValue(RANDOM.nextInt(359), PEDESTRIANS[pedsIndex], PEDESTRIANS[pedsIndex] + RANDOM.nextInt(5), Direction.PLUS);
            if (++pedsIndex >= PEDESTRIANS.length) {
                pedsIndex = 0;
            }
            mainAxis.setValue(RANDOM.nextInt(359), PEDESTRIANS[pedsIndex], PEDESTRIANS[pedsIndex] + RANDOM.nextInt(5), Direction.MINUS);
            builder.addPedestrianSensor(id, System.currentTimeMillis(), 60, PEDESTRIANS[pedsIndex] * 2, mainAxis);
        }

        Location[] locs = wrapper.getLocationList();
        for (Location loc : locs) {
            try {
                URL url = new URL("http://sfeer.osoite.jp:8080/SfeerServer2/testimage/001.jpg");
                for (int id : areaIds) {
                    builder.addImageSensor(String.valueOf(id), System.currentTimeMillis(), RANDOM.nextInt(359), loc.getLat(), loc.getLon(), url, url);
                }
            } catch (MalformedURLException ex) {
            }
        }

        TomuMessage msg = builder.build();
        sendMessage(msg);
    }

    public void receiveUploadPedestrian(UploadPedestrianWrapper wrapper) {
        System.out.println("> Received PedestrianUpload");
        printHeader(wrapper);
        System.out.println("SensorID : " + wrapper.getSensorId());
        System.out.println("SensedTime : " + wrapper.getSensedTime());
        System.out.println("MeasurementTime : " + wrapper.getMeasurementTime());
        System.out.println("Residence : " + wrapper.getResidence());
        Axis axis = wrapper.getChiefAxis();
        System.out.println("Plus Axis : ");
        System.out.println("(Compass) " + axis.getCompass(Direction.PLUS));
        System.out.println("(Num) " + axis.getFlowValue(Direction.PLUS));
        System.out.println("(AvgSp) " + axis.getAverageSpeed(Direction.PLUS));
        System.out.println("Minus Axis : ");
        System.out.println("(Compass) " + axis.getCompass(Direction.MINUS));
        System.out.println("(Num) " + axis.getFlowValue(Direction.MINUS));
        System.out.println("(AvgSp) " + axis.getAverageSpeed(Direction.MINUS));
    }

    public void receiveUploadKito2(UploadKito2Wrapper wrapper) {
        System.out.println("> Received Kito2Upload");
        printHeader(wrapper);
        System.out.println("SensorID : " + wrapper.getSensorId());
        System.out.println("SensedTime : " + wrapper.getSensedTime());
        System.out.println("Compass : " + wrapper.getCompass());
        System.out.println("Lat : " + wrapper.getLatitude());
        System.out.println("Lon : " + wrapper.getLongitude());
        System.out.println("DPI : " + wrapper.getDpi());
        System.out.println("URL : " + wrapper.getImageUrl());
        System.out.println("Thumbnail : " + wrapper.getThumbnailUrl());
    }

    private void printHeader(TomuMessageWrapper wrapper) {
        System.out.println("MsgID : " + wrapper.getMessageId());
        System.out.println("MsgSrc : " + wrapper.getSourceId());
        System.out.println("MsgType : " + wrapper.getMessageType());
    }

    public static void main(String[] args) {
        DummyTomuRunner runner = new DummyTomuRunner();
        runner.start();
        System.exit(0);
    }
}
