package jp.osoite.tomu.xml.jaxb.wrapper;

import jp.osoite.tomu.xml.jaxb.object.StaticSensorData;
import jp.osoite.tomu.xml.jaxb.object.StreetPedestrianFlowValue;
import jp.osoite.tomu.xml.jaxb.object.TomuMessage;
import jp.osoite.tomu.xml.jaxb.util.SensorType;

/**
 *
 * @author shima
 */
public class UploadPedestrianWrapper extends TomuMessageWrapper {

    private StaticSensorData ssd;
    private SensorType type;
    private StreetPedestrianFlowValue value;

    public UploadPedestrianWrapper(TomuMessage msg) {
        super(msg);
        ssd = msg.getUpload().getSensorSourceDataSet().getStaticSensorData().get(0);
        type = (ssd.getType().equals("PEDESTRIAN")) ? SensorType.PEDESTRIAN : SensorType.INTER_PEDESTRIAN;
        value = ssd.getValue().getStreetPedestrianFlowValue();
    }

    public SensorType getType() {
        return type;
    }

    public long getSensorId() {
        return ssd.getStaticSensorID().longValue();
    }

    public long getSensedTime() {
        return ssd.getSensedTime().longValue();
    }

    public long getMeasurementTime() {
        return value.getMeasurementTimeSec().longValue();
    }

    public Axis getChiefAxis() {
        return new Axis(value.getChiefAxis());
    }

    public Axis getSubAxis() {
        if (type == SensorType.PEDESTRIAN) {
            throw new NullPointerException("This TomuMessage is PEDESTRIAN");
        }
        return new Axis(value.getSubAxis());
    }

    public int getResidence() {
        return value.getResidence().intValue();
    }

    public int getFrequency() {
        return value.getMeasurementTimeSec().intValue();
    }
    public int getAllNumber() {
        int result = 0;
        result = value.getChiefAxis().getMinus().getNum().intValue();
        result += value.getChiefAxis().getPlus().getNum().intValue();
        if (type == SensorType.INTER_PEDESTRIAN) {
            result += value.getSubAxis().getMinus().getNum().intValue();
            result += value.getSubAxis().getPlus().getNum().intValue();
        }
        result += value.getResidence().intValue();
        return result;
    }
}
