package jp.osoite.tomu.usml;

import org.xml.sax.*;
//import org.xml.sax.Attributes;
//import org.xml.sax.SAXException;
import org.xml.sax.helpers.*;
//import org.xml.sax.helpers.DefaultHandler;

public class USMLSAXHandler extends DefaultHandler {

//    private Config config;

    private String attribute;
    private String elname;

    public void startDocument() throws SAXException {

      System.out.println("Document start");

    }

    public void endDocument() throws SAXException
    {
        System.out.println("Document end");
    }


    public void startElement(String uri, String localName,
			      String qName, Attributes attributes) throws SAXException
    {
        if( qName.equals("filter") )
        {
            for( int i = 0; i < attributes.getLength(); i++ )
            {
                if( attributes.getLocalName(i).equals("type") )
                {
                    attribute = attributes.getValue(i);
                }
            }
        }
//        System.out.println("_elementName : " + localName + "  start>>>");
        this.elname = qName;
    }


    public void endElement(String uri,
        String elname,
        String qualifiedName)
    {
//        System.out.println("_elementName : " + elname + "  <<<end ");

        this.elname = "";
    }

    public void characters(char[] ch, int start, int length)
    {
        String word = new String(ch, start, length);
        if( elname.equals("STASTICS_CALC_ENABLE_FLAG"))
        {
            System.out.println( elname+ ";" + word);
            Config.getInstance().setSTASTICS_CALC_ENABLE_FLAG( Boolean.parseBoolean(word) );
        }
        else if( elname.equals("SOCK_FOWARDING_HOST_NAME"))
        {
            System.out.println( elname+ ";" + word);
            Config.getInstance().setSOCK_FOWARDING_HOST_NAME(word);
        }
        else if( elname.equals("SOCK_FOWARDING_HOST_PORT"))
        {
            System.out.println( elname+ ";" + word);
            Config.getInstance().setSOCK_FOWARDING_HOST_PORT( Integer.parseInt(word) );
        }
        else if( elname.equals("RCON_HOST_RECEIVE_PORT"))
        {
            System.out.println( elname+ ";" + word);
            Config.getInstance().setRCON_HOST_RECEIVE_PORT( Integer.parseInt(word) );
        }
        else if( elname.equals("ISRconReceiverActive"))
        {
            System.out.println( elname+ ";" + word);
            Config.getInstance().setISRconReceiverActive( Boolean.parseBoolean(word) );
        }
        else if( elname.equals("ISSocketReceriverActive"))
        {
            System.out.println( elname+ ";" + word);
            Config.getInstance().setISSocketReceriverActive( Boolean.parseBoolean(word) );
        }
        else if( elname.equals("ISSocketSensingActive"))
        {
            System.out.println( elname+ ";" + word);
            Config.getInstance().setISSocketReceriverActive( Boolean.parseBoolean(word) );
        }
        else if( elname.equals("LOCAL_DB_URI"))
        {
            System.out.println( elname+ ";" + word);
            Config.getInstance().setDATABASE_URL(word);
        }
        else if( elname.equals("LOCAL_DB_NAME"))
        {
            System.out.println( elname+ ";" + word);
            Config.getInstance().setDATABASE_NAME(word);
        }
        else if( elname.equals("LOCAL_DB_USERNAME"))
        {
            System.out.println( elname+ ";" + word);
            Config.getInstance().setDATABASE_USER(word);
        }
        else if( elname.equals("LOCAL_DB_PASSWORD"))
        {
            System.out.println( elname+ ";" + word);
            Config.getInstance().setDATABASE_PASSWORD(word);
        }
        else if( elname.equals("LOCAL_DB_JDBC_DRIVER"))
        {
            System.out.println( elname+ ";" + word);
            Config.getInstance().setJDBC_DRIVER(word);
        }
        else if( elname.equals("LOCAL_DB_DATA_TABLE_NAME"))
        {
            System.out.println( elname+ ";" + word);
            Config.getInstance().setDATA_TABLE_NAME(word);
        }
        else if( elname.equals("drawSpeedFromFile") )
        {
            System.out.println( elname+ ";" + word);
            Config.getInstance().setDrawSpeedFromFile( Integer.parseInt(word) );
        }
        else if( elname.equals("filter") )
        {
            if( attribute.equals("radio") )
            {
                Config.getInstance().addFilterSensorNodeNamesListRadio(word);
            }
            else if( attribute.equals("TCP") )
            {
                Config.getInstance().addFilterSensorNodeNamesListTCP(word);
            }
            System.out.println( elname+ ";" + attribute + ";" + word);
        }
    }

}