package jp.osoite.tomu.sensor.tscan.socks;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;

/**
 * 
 * @author shima
 */
public class StringSocketServer implements Runnable {

    private List<Transporter> connection;
    private volatile boolean isRunning;
    private ServerSocket srvSocket;
    private int port;
    private final Object lock = new Object();

    public StringSocketServer(int port) {
        connection = new ArrayList<Transporter>();
        this.port = port;
        isRunning = false;
    }

    public void run() {
        synchronized (lock) {
            if (isRunning) {
                return;
            }
            isRunning = true;
        }
        try {
            srvSocket = new ServerSocket();
            srvSocket.setReuseAddress(true);
            srvSocket.bind(new InetSocketAddress(port));
            while (isRunning) {
                Socket client = srvSocket.accept();
                Transporter transpoter = new Transporter(client);
                connection.add(transpoter);
                new Thread(transpoter).start();
            }
        } catch (IOException e) {
        } finally {
            isRunning = false;
        }
    }

    private void disconnect(Transporter trans) {
        connection.remove(trans);
    }

    private void transport(Socket socket, String mes) {
        for (Transporter trans : connection) {
            if (trans.socket != socket) {
                trans.output(mes);
            }
        }
    }

    public void stop() {
        isRunning = false;
        try {
            srvSocket.close();
        } catch (IOException ex) {
        }
    }

    //==============================================
    private class Transporter implements Runnable {

        Socket socket;
        volatile boolean isRunning = false;
        BufferedReader input;
        PrintWriter output;

        public Transporter(Socket socket) throws IOException {
            this.socket = socket;
            output = new PrintWriter(socket.getOutputStream());
            input = new BufferedReader(new InputStreamReader(socket.getInputStream()));
        }

        public void run() {
            isRunning = true;
            try {
                while (isRunning) {
                    if (socket.isClosed()) {
                        break;
                    }
                    transport(this.socket, input.readLine());
                }
            } catch (Exception e) {
            } finally {
                stop();
            }
        }

        public void output(String message) {
            output.println(message);
            output.flush();
        }

        public void stop() {
            isRunning = false;
            try {
                socket.close();
            } catch (IOException ex) {
            }
            disconnect(this);
        }
    }
}
