package jp.osoite.tomu.net.xmpp.utils;

//import java.io.*;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.util.regex.*;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.*;
import org.xml.sax.helpers.DefaultHandler;

public abstract class KskXMLParser extends DefaultHandler{
	
	public KskXMLParser(){}

	public String getTagContent(String msg, String tag){
		String patternStr = new String("<" + tag + ">.*</" + tag + ">");
		Pattern pattern = Pattern.compile(patternStr, Pattern.DOTALL | Pattern.CASE_INSENSITIVE);
		Matcher matcher = pattern.matcher(msg);
		return (matcher.find()) ? matcher.group() : null;
	}

	//public void parseMessage(Object obj, String msg){}

	public void parseMessage(File file){
		try{
			SAXParserFactory spfactory = SAXParserFactory.newInstance();
			SAXParser parser = spfactory.newSAXParser();
			//parser.parse(new ByteArrayInputStream(str.getBytes()),new KskXMLParser());
			parser.parse(file,this);
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	public void parseMessage(String str){
		try{
			SAXParserFactory spfactory = SAXParserFactory.newInstance();
			SAXParser parser = spfactory.newSAXParser();
			//parser.parse(new ByteArrayInputStream(str.getBytes()),new KskXMLParser());
			parser.parse(new ByteArrayInputStream(str.getBytes()),this);
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	public abstract void startDocument();
	public abstract void startElement(String uri, String localName, String qName, Attributes attributes);
	public abstract void characters(char[] ch, int offset, int length);
	public abstract void endElement(String uri, String localName, String qName);
	public abstract void endDocument();

}

	//private TomuMessage tomuMsg;
	//private Stack<StringBuffer> msgStack;
	//private StringBuffer buffer;
/*
	public void parseMessage(TomuMessage tomuMsg, String msg){
		this.tomuMsg = tomuMsg;
		parseMessage(msg);
	}
*/
	//public abstract void startDocument(){
		//System.out.println("Start Document!!");
		//msgStack = new Stack<StringBuffer>();
	//}
	//public abstract void startElement(String uri, String localName, String qName, Attributes attributes){
/*
		System.out.println("Start Element: " + uri);
		System.out.println("Start Element: " + localName);
		System.out.println("Start Element: " + qName);
		System.out.println("Start Element: " + attributes);

		buffer = new StringBuffer();
		//msgStack.push(buffer);
*/
	//}
	//public abstract void characters(char[] ch, int offset, int length){
/*
		System.out.println("Text Data: " + new String(ch, offset, length));

		buffer.append(new String(ch, offset, length));
*/
	//}
	//public abstract void endElement(String uri, String localName, String qName){
/*
		System.out.println("End Element: " + uri);
		System.out.println("End Element: " + localName);
		System.out.println("End Element: " + qName);

		if(qName.equals("msg_code")){ tomuMsg.setMsgCode(buffer.toString()); }
		else if(qName.equals("msg_id")){ tomuMsg.setMsgID(buffer.toString()); }
		else if(qName.equals("dst")){ tomuMsg.setDst(buffer.toString()); }
		else if(qName.equals("src")){ tomuMsg.setSrc(buffer.toString()); }
*/
	//}
	//public abstract void endDocument(){
/*
		System.out.println("End Document!!");
*/
	//}
