package jp.osoite.tomu.core.main;

import java.util.logging.Level;
import java.util.logging.Logger;
import jp.osoite.tomu.core.db.DBConnectionModule;
import jp.osoite.tomu.core.gui.GuiDataWindow;
import jp.osoite.tomu.core.gui.GuiControlOuterFrame;
import java.awt.Color;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import jp.osoite.tomu.net.mail.JavaMailSend;
import jp.osoite.tomu.net.mail.MailScheduleManager;
import jp.osoite.tomu.net.socks.SocketClientSenderOnceLoop;
import jp.osoite.tomu.usml.Config;
//import com.sun.spot.util.IEEEAddress;
//import jp.osoite.tomu.sensor.ISensorValue;
import jp.osoite.tomu.sensor.pedestrian.PedestrianFlowValue;
import jp.osoite.tomu.util.TimeConverter;
import jp.osoite.tomu.xml.jaxb.wrapper.UploadPedestrianWrapper;

public class MainController {

    public final boolean IsSockSensingActive = Config.getInstance().isSockSensingActive();
    // Broadcast port on which we listen for sensor samples
    //private static final int SOCK_RECEIVING_PORT = 67;
    private JTextArea status;
    private long[] addresses = new long[20];
    private GuiDataWindow[] plots = new GuiDataWindow[20];
    private static MainController mcontroller = null;
    private static GuiControlOuterFrame fr;

    //private static final int CONNECTION_TIMEOUT = 2*10*1000;
    public static MainController getInstance() {


        if (mcontroller == null) {
            mcontroller = new MainController();
            try {
                Thread.sleep(15);
            } catch (InterruptedException ex) {
                Logger.getLogger(MainController.class.getName()).log(Level.SEVERE, null, ex);
            }
            return mcontroller;
        }
        if (mcontroller == null) {
            mcontroller = new MainController();
        }
        return mcontroller;
    }
    private IConnection iConDB;
    private IConnection iConSock;

    private MainController() {
        setup();
    }

    public void setup() {

        if (fr != null) {
            System.err.println("setup double called at main control panel");
            System.exit(1);
        }

        fr = new GuiControlOuterFrame("GuiCrtlMainFrame", this);

        status = new JTextArea();
        JScrollPane sp = new JScrollPane(status);
        JButton jb = new JButton();

        JButton jb2 = new JButton();
        jb2.setText("X");

        JPanel jp = new JPanel();
        jp.add(new JButton("load files"));

        jp.setBackground(Color.black);
        jp.setSize(200, 1200);


        jb.addActionListener(
                new java.awt.event.ActionListener() {

                    public void actionPerformed(java.awt.event.ActionEvent evt) {
                        activateAllWindow();
                    }
                });

        jb2.addActionListener(
                new java.awt.event.ActionListener() {

                    public void actionPerformed(java.awt.event.ActionEvent evt) {
                        closeOp();
                        System.exit(1);
                    }
                });
        jp.addMouseListener(
                new MouseAdapter() {

                    public void mouseClicked(MouseEvent e) {
                        System.out.println("clicked");
                        activateAllWindow();
                    }
                });

        fr.setLayout(new java.awt.BorderLayout());

        fr.add(jp, java.awt.BorderLayout.NORTH);
        fr.add(sp, java.awt.BorderLayout.CENTER);
        fr.add(jb, java.awt.BorderLayout.SOUTH);
        fr.add(jb2, java.awt.BorderLayout.EAST);
        //fr.add(sp);
        fr.setSize(360, 200);
        fr.validate();
        fr.setVisible(true);
        for (int i = 0; i < addresses.length; i++) {
            addresses[i] = 0;
            plots[i] = null;
        }
    }

    public void append(String str) {
        status.append(str);
    }

    public void activateAllWindow() {
        for (int i = 0; i < addresses.length; i++) {
            if (plots[i] != null) {
                plots[i].setVisible(true);
            }
        }
    }

    private GuiDataWindow findPlot(long addrLng, String sname) {
        //private GuiDataWindow findPlot(long addrLng) {
        for (int i = 0; i < addresses.length; i++) {
            if (addresses[i] == 0) {

                /*
                String ieee = IEEEAddress.toDottedHex(addrLng);
                status.append("Received packet from SPOT: " + ieee + "\n");
                 */

                status.append("Received packet from SPOT: " + addrLng + "\n");
                addresses[i] = addrLng;
                //plots[i] = new GuiDataWindow(ieee);
                plots[i] = new GuiDataWindow(sname);
                final int ii = i;
                java.awt.EventQueue.invokeLater(new Runnable() {

                    public void run() {
                        plots[ii].setVisible(true);
                    }
                });
                return plots[i];
            }
            if (addresses[i] == addrLng) {





                //if(plots[i]==null)
                return plots[i];
            }
        }
        return plots[0];
    }



    public void addPedestrianSensorValue(PedestrianFlowValue psvalue) {

        //System.out.println("@@isensorvalue2:"+psvalue);
        try {
            DBConnectionModule.getInstance().receivePerFlowValFromSensorSource(psvalue);
            //System.out.println("@@isensorvalue3:"+psvalue);

            GuiDataWindow dwindow = findPlot(psvalue.getSensorID(), "Human" + psvalue.getSensorID());
            dwindow.addSensorVals(psvalue);

            MailScheduleManager.getInstance().stop(psvalue.getSensorID());
            String aMsg= "The Latest Human data is : ID=" + psvalue.getSensorID() + " \n get time =" + TimeConverter.convertToString(psvalue.getTime()) + "\n";
            MailScheduleManager.getInstance().start(JavaMailSend.TO_MAIL_ADDRESS_PED,psvalue.getSensorID(),3 * 60 * 1000 + 100,aMsg);
            //MailScheduleManager.getInstance().start(3 * 60 * 1000 + 100);


        } catch (Exception ex) {
            Logger.getLogger(MainController.class.getName()).log(Level.SEVERE, null, ex);
        }

    }

    public void addSensorVals(SensorVals sval) throws Exception {

        DBConnectionModule.getInstance().receiveDataFromSunSpot(sval);

        GuiDataWindow dwindow = findPlot(sval.getFromAddrLong(), sval.getSensorName());
        //GuiDataWindow dwindow = findPlot(sval.getFromAddrLong(),sval.getShortSensorName());
        System.out.println("@@@@@@@@@@@@@@@sval.getSensorName()" + sval.getSensorName());

        int omitidx = dwindow.addSensorVals(sval);
        if (omitidx % 5 == 0 && IsSockSensingActive) {
            int freq = 5 * sval.getFreq();
            sval.setFreq(freq);


            SocketClientSenderOnceLoop socksenderOne = new SocketClientSenderOnceLoop(sval);
            new Thread(socksenderOne).start();

        }


    }

    //
    public void addDatabaseConnectionsListener(IConnection iCon) {
        this.iConDB = iCon;
    }

    public void addSockConnectionsColoseListener(IConnection iCon) {
        this.iConSock = iCon;
    }

    public void closeOp() {
        try {
            //CloseListener
            //RconReceiver
            if (iConDB != null) {
                iConDB.closeOp();
            }
            if (iConSock != null) {
                iConSock.closeOp();
            }

        } catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    /**
     * Start up the host application.
     *
     * @param args any command line arguments
     */
    public static void main(String[] args) throws Exception {
        MainController app = new MainController();
        app.setup();
    // app.addSensorVals(new SensorVals());
    }
}
