/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package jp.osoite.tomu.core.gui;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;

/**
 *
 * @author tailor
 */
public class GuiSmallObj {

    Graphics2D g2;
    private long internalcounter;
    private String sensorTypeLabel;
    private int value;
    private int ave;
    private int highband;
    private int lowband;
    private double vscale = -0.5325;
    private final int margin = 5;
    private Color color = Color.gray;
    private Color backgroundColor = Color.pink;
    private int y0 = 10;
    private Color bandColor;

    public GuiSmallObj() {
        //this.internalcounter=0;
        this.sensorTypeLabel = "";
        this.value = 0;
    }
    /*
    public GuiSmallObj (int internalcounter,String sensorTypeLabel,int value){
    this.internalcounter=internalcounter;
    this.sensorTypeLabel=sensorTypeLabel;
    this.value=value;
    }*/

    //public GuiSmallObj (long internalcounter,String sensorTypeSTR,int value,Color color){
    public GuiSmallObj(String sensorTypeSTR, int value, Color color) {
        //this.internalcounter=internalcounter;
        this.sensorTypeLabel = sensorTypeSTR;
        this.value = value;
        this.color = color;
    }

    public void setGraphics2D(Graphics2D g2) {
        this.g2 = g2;
    }

    public void drawLineofAvg(int xp, int vp, int x) {
        //   System.out.println("line :xp,"+xp+"vp,"+vp+"x "+x+"getAVG() "+this.getAvg());

        if (g2 == null) {
            System.err.println("g2 is null:@ dreawLabel");
        }
        g2.setColor(Color.pink);
        g2.drawLine(xp, vp, x, this.getAvg());
    }

    public void drawLineofHBScale(int xp, int vp, int x) {
        //   System.out.println("line :xp,"+xp+"vp,"+vp+"x "+x+"getLowband() "+getHighband());

        if (g2 == null) {
            System.err.println("g2 is null:@ dreawHighband");
        }
        g2.setColor(bandColor);
        g2.drawLine(xp, vp, x, this.getHighband());
    }

    public void drawLineofLBScale(int xp, int vp, int x) {
        // System.out.println("line :xp,"+xp+"vp,"+vp+"x "+x+"getHighband() "+getLowband());

        if (g2 == null) {
            System.err.println("g2 is null:@ dreawLabel");
        }
        g2.setColor(bandColor);
        g2.drawLine(xp, vp, x, this.getLowband());
    }

    public void drawLineofVS(int xp, int vp, int x) {
        // System.out.println("line :xp,"+xp+"vp,"+vp+"x "+x+"getVS() "+getVS());
        if (g2 == null) {
            System.err.println("g2 is null:@ dreawLabel");
        }
        g2.setColor(color);
        g2.setStroke(new BasicStroke(2));
        g2.drawLine(xp, vp, x, getVScale());
    }

    public void drawLabel(int x) {
        if (g2 == null) {
            System.err.println("g2 is null:@ dreawLabel");
        }
        g2.setColor(color);
        g2.drawString(this.getSensorTypeLabel(), x + margin, this.getVScale());
    }

    public void eraseLabel(int xp) {
        if (g2 == null) {
            System.err.println("g2 is null:@ ereaseLabel");
        }
        g2.setColor(backgroundColor);
        g2.drawString(this.getSensorTypeLabel(), xp + margin, this.getVScale());
    }

    /**
     * @return the sensorTypeLabel
     */
    public String getSensorTypeLabel() {
        return sensorTypeLabel;
    }

    /**
     * @return the vallue
     */
    public int getValue() {
        return value;
    }

    private int calcScale(int v) {
        return y0 + (int) (v * vscale);
    }

    public int getVScale() {
        return this.calcScale(value);
    }

    /**
     * @param vallue the vallue to set
     */
    public void setValue(int value) {
        this.value = value;
    }

    /**
     * @return the vscale
     */
    public double getVscale() {
        return vscale;
    }

    /**
     * @param vscale the vscale to set
     */
    public void setVscale(double vscale, int y0) {
        this.vscale = vscale;
        this.y0 = y0;

    }

    /**
     * @return the color
     */
    public Color getColor() {
        return color;
    }

    /**
     * @param color the color to set
     */
    public void setColor(Color color) {
        this.color = color;
    }

    /**
     * @return the y0
     */
    public int getY0() {
        return y0;
    }

    /**
     * @return the getBackgroundColor
     */
    public Color getGetBackgroundColor() {
        return backgroundColor;
    }

    /**
     * @param getBackgroundColor the getBackgroundColor to set
     */
    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public void setBandColor(Color bandColor) {
        this.bandColor = bandColor;
    }

    /**
     * @return the ave
     */
    public int getAvg() {
        return this.calcScale(ave);
    }

    /**
     * @param ave the ave to set
     */
    public void setAve(int ave) {
        this.ave = ave;

    }

    /**
     * @return the highband
     */
    public int getHighband() {
        return this.calcScale(highband);
    }

    /**
     * @param highband the highband to set
     */
    public void setHighband(int highband) {
        this.highband = highband;
    }

    /**
     * @return the lowband
     */
    public int getLowband() {
        return this.calcScale(lowband);
    }

    /**
     * @param lowband the lowband to set
     */
    public void setLowband(int lowband) {
        this.lowband = lowband;
    }
}
