package jp.osoite.tomu.core.gui;

import javax.swing.JTextArea;
import jp.osoite.tomu.core.main.SensorVals;
import java.awt.Color;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.TimeZone;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import jp.osoite.tomu.core.db.DBConnectionModule;
import jp.osoite.tomu.core.main.UtilSensorID;
import jp.osoite.tomu.sensor.pedestrian.PedestrianFlowValue;
import jp.osoite.tomu.usml.Config;
import jp.osoite.tomu.util.TimeConverter;
import jp.osoite.tomu.xml.jaxb.wrapper.Axis.Direction;

/**
 * Create a new window to graph the sensor readings in.
 *
 * @author Ron Goldman
 */
public class GuiDataWindow extends JFrame {// implements ChangeListener//implements ActionListener

    JCheckBox ck[] = new JCheckBox[11];
    //private static int MAX_SAMPLES = 5000;
    private static int MAX_SAMPLES = 3000;
    //private static int TH_SAMPLES = 450;
    //for tatebayashi
    private static int TH_SAMPLES = 120;
    int sumdex = 0;
    private int index = 0;
    public long[] time = new long[MAX_SAMPLES];
    GuiDWGraphPanel plotPanel;
    public GuiSmallObj[][] objs = new GuiSmallObj[11][MAX_SAMPLES];
    public boolean sensorsVisible[] = new boolean[11];
    public String sensorname;
    private JTextArea dataTextArea2;
    private String starttimer;

    public GuiDataWindow() {
    }

    public static String getCurrDateFormatted() {

        SimpleDateFormat sdf1 = new SimpleDateFormat("MM/dd HH:mm:ss");//yyyyMMdd_HHmmss_Z
        TimeZone tz1 = TimeZone.getTimeZone("Asia/Tokyo");
        Calendar cal1 = Calendar.getInstance(tz1);
        return sdf1.format(cal1.getTime()).toString();
    }

    public GuiDataWindow(String sensorname) {

        starttimer = getCurrDateFormatted();

        initComponents2();
        this.sensorname = sensorname;

        //setTitle(sensorname);SensorVals.getShortSensorName(sensorname)
        setTitle(sensorname + " : [" + starttimer + "-" + getCurrDateFormatted() + "] :" + this.sumdex + "/" + TH_SAMPLES + "times");
        setSize(3 * 360, 200 + 400);
        setVisible(true);

    }

    private void clearIndex() {
        //plotPanel.removeAll();

        getContentPane().remove(jScrollPane1);
        jScrollPane1.removeAll();
        jScrollPane1 = new javax.swing.JScrollPane();
        jScrollPane1.setVerticalScrollBarPolicy(javax.swing.ScrollPaneConstants.VERTICAL_SCROLLBAR_ALWAYS);
        jScrollPane1.setMinimumSize(new java.awt.Dimension(1500, 200));
        jScrollPane1.setPreferredSize(new java.awt.Dimension(1500, 200));

        Color bkc = UtilColor.getBlightRandomColor();

        dataTextArea2 = new javax.swing.JTextArea();
        dataTextArea2.setText("---------------\n");
        dataTextArea2.setColumns(125);
        dataTextArea2.setEditable(true);
        dataTextArea2.setRows(220);

        dataTextArea.removeAll();
        dataTextArea = dataTextArea2;


        jScrollPane1.setBackground(bkc);

        jScrollPane1.setViewportView(dataTextArea);

        plotPanel.setBackground(bkc);
        plotPanel.setMinimumSize(new java.awt.Dimension(1500, 450));
        plotPanel.setPreferredSize(new java.awt.Dimension(1500, 450));
        getContentPane().add(jScrollPane1, java.awt.BorderLayout.SOUTH);

        for (int i = 0; i < index; i++) {
            time[i] = 0;

            for (int j = 0; j < 11; j++) {
                objs[j][i] = null;
            }

        }

        indexZero();
        setTitle(sensorname + "@" + starttimer + "-" + getCurrDateFormatted() + ":" + this.sumdex + "/TH_SAMPLES:" + TH_SAMPLES + "times");
        pack();

    }

    private void indexZero() {
        index = 0;
    }

    private void initComponents2() {

        for (int i = 0; i < 11; i++) {
            sensorsVisible[i] = true;
        }

        JPanel upper = new JPanel();
        upper.setSize(100, 20);
        upper.setBackground(Color.red);

        JButton jb0set = new JButton("set");
        JButton jb1save = new JButton("save to txt");
        JButton jb2filer = new JButton("filter");
        JButton jb3stast = new JButton("ststcs");

        jb0set.addActionListener(
                new java.awt.event.ActionListener() {

                    public void actionPerformed(java.awt.event.ActionEvent evt) {
                        JButton jb = (JButton) evt.getSource();
                        if (jb.getText().equals("set")) {

                            for (int i = 0; i < 11; i++) {
                                System.out.println("@" + i + ":" + ck[i].isSelected() + ",");
                                sensorsVisible[i] = ck[i].isSelected();
                            }

                        }
                    }
                });
        jb1save.addActionListener(
                new java.awt.event.ActionListener() {

                    public void actionPerformed(java.awt.event.ActionEvent evt) {
                        JButton jb = (JButton) evt.getSource();
                        if (jb.getText().equals("save to txt")) {
                            try {
                                DBConnectionModule.getInstance().savingData2Txt(sensorname);
                            } catch (Exception ex) {
                                ex.printStackTrace();
                            }
                        }
                    }
                });

        jb2filer.addActionListener(
                new java.awt.event.ActionListener() {

                    public void actionPerformed(java.awt.event.ActionEvent evt) {
                        JButton jb = (JButton) evt.getSource();
                        if (jb.getText().equals("filter")) {
                            try {
//                                Config.getInstance().addFilterSensoeName(sensorname.substring(15));
                                //Config.getInstance().addFilterSensorNodeNamesListRadio(sensorname.substring(15));
                                if (UtilSensorID.isIEEE(sensorname)) {
                                    Config.getInstance().addFilterSensorNodeNamesListRadio(sensorname.substring(15));
                                }

                            } catch (Exception ex) {
                                ex.printStackTrace();
                            }
                        }
                    }
                });


        jb3stast.addActionListener(
                new java.awt.event.ActionListener() {

                    public void actionPerformed(java.awt.event.ActionEvent evt) {
                        JButton jb = (JButton) evt.getSource();
                        if (jb.getText().equals("ststcs")) {
                            try {
                                Config.getInstance().reverseSTASTICS_CALC_ENABLE();
                                System.out.println("Ststcs changed");
                            } catch (Exception ex) {
                                ex.printStackTrace();
                            }
                        }
                    }
                });

        for (int i = 0; i < 11; i++) {
            ck[i] = new JCheckBox();
            ck[i].setSelected(true);
            upper.add(ck[i]);
        }

        upper.add(jb0set);
        upper.add(jb1save);
        upper.add(jb2filer);
        upper.add(jb3stast);

        ck[0].setText(SensorVals.SN_LIGHT);
        ck[1].setText(SensorVals.SN_AX);
        ck[2].setText(SensorVals.SN_AY);
        ck[3].setText(SensorVals.SN_AZ);
        ck[4].setText(SensorVals.SN_TX);
        ck[5].setText(SensorVals.SN_TY);
        ck[6].setText(SensorVals.SN_TZ);
        ck[7].setText(SensorVals.SN_MOVE);
        ck[8].setText(SensorVals.SN_TEMP);
        ck[9].setText(SensorVals.SN_BATT);
        ck[10].setText(SensorVals.SN_RSSI);

        plotPanel = new GuiDWGraphPanel(this);
        jScrollPane1 = new javax.swing.JScrollPane();

        dataTextArea = new javax.swing.JTextArea();

        plotPanel.setBackground(new java.awt.Color(255, 255, 255));
        plotPanel.setMinimumSize(new java.awt.Dimension(400, 250));
        plotPanel.setPreferredSize(new java.awt.Dimension(400, 250));


        getContentPane().add(plotPanel, java.awt.BorderLayout.CENTER);

        jScrollPane1.setVerticalScrollBarPolicy(javax.swing.ScrollPaneConstants.VERTICAL_SCROLLBAR_ALWAYS);
        jScrollPane1.setMinimumSize(new java.awt.Dimension(400, 100));
        jScrollPane1.setPreferredSize(new java.awt.Dimension(400, 100));

        dataTextArea.setColumns(125);
        dataTextArea.setEditable(true);
        dataTextArea.setRows(220);
        jScrollPane1.setViewportView(dataTextArea);

        getContentPane().add(jScrollPane1, java.awt.BorderLayout.SOUTH);
        getContentPane().add(upper, java.awt.BorderLayout.NORTH);

        pack();
    }

    public int addSensorVals(PedestrianFlowValue ps) {
        System.out.print(">id=" + ps.getSensorID() + ", time=" + TimeConverter.convertToString(ps.getTime()) + ", main.p.num=" + ps.getChiefAxis().getFlowValue(Direction.PLUS) + " :index:" + index + " ");
        String _tail = ":";

        time[index] = ps.getMeasurementTime();

        objs[SensorVals.INT_LIGHT][index] = new GuiSmallObj(SensorVals.SN_HMP_N + _tail + ps.getChiefAxis().getFlowValue(Direction.PLUS), ps.getChiefAxis().getFlowValue(Direction.PLUS) * 10, Color.red);//red
        objs[SensorVals.INT_TEMP][index] = new GuiSmallObj(SensorVals.SN_HMP_S + _tail + ps.getChiefAxis().getAverageSpeed(Direction.PLUS), (int)ps.getChiefAxis().getAverageSpeed(Direction.PLUS) + 300, Color.red);//blue
        objs[SensorVals.INT_MOVE][index] = new GuiSmallObj(SensorVals.SN_HMM_N + _tail + ps.getChiefAxis().getFlowValue(Direction.MINUS), ps.getChiefAxis().getFlowValue(Direction.MINUS) * 10, Color.blue);//darkGray
        objs[SensorVals.INT_AX][index] = new GuiSmallObj(SensorVals.SN_HMM_S + _tail + ps.getChiefAxis().getAverageSpeed(Direction.MINUS), (int)ps.getChiefAxis().getAverageSpeed(Direction.MINUS) + 300, Color.blue);//orange
        objs[SensorVals.INT_AY][index] = new GuiSmallObj(SensorVals.SN_HREG + _tail + ps.getResidence(), ps.getResidence() * 10, Color.orange);

        _tail = "###";
        objs[SensorVals.INT_AZ][index] = new GuiSmallObj(SensorVals.SN_AZ + _tail, -100, Color.black);//black
        objs[SensorVals.INT_TX][index] = new GuiSmallObj(SensorVals.SN_TX + _tail, -100, Color.red);//orange
        objs[SensorVals.INT_TY][index] = new GuiSmallObj(SensorVals.SN_TY + _tail, -100, Color.blue);
        objs[SensorVals.INT_TZ][index] = new GuiSmallObj(SensorVals.SN_TZ + _tail, -100, Color.black);
        objs[SensorVals.INT_BATT][index] = new GuiSmallObj(SensorVals.SN_BATT + _tail, -100, Color.gray);//black
        objs[SensorVals.INT_RSSI][index] = new GuiSmallObj(SensorVals.SN_RSSI + _tail, -100, Color.orange);//black


        try {


            dataTextArea.append(index + ":" + ps.printPedestrian());
            dataTextArea.append("\n");
            dataTextArea.setCaretPosition(dataTextArea.getText().length());
        } catch (Exception e) {

            e.printStackTrace();
            System.err.println("dataTextArea:" + dataTextArea);
            System.err.println("GuiDataWindows getText");
        }

        index++;
        int len = (ps.getFrequency()) / 100;
        //1000:
        if (len > 150) {
            len = 150;
        } else if (len < 10) {
            len = 10;
        }
        //50:400
        //25:800

        //TH_SAMPLES = 20000 / len + 50;
        //TH_SAMPLES = 80;
        TH_SAMPLES = 40;
        if (index > TH_SAMPLES) {
            sumdex += index;
            this.clearIndex();
        }

        repaint();

        return (index - 1);
    }

    public int addSensorVals(SensorVals s) {

        System.out.println(s.getSensorName() + ":index:" + index);


        /*
        val1[index] = s.getLightSensorVal();
        val2[index] = s.getTempSensorValbyIngeter();
        val3[index] = s.getAllMovementbyInteger();
        val4[index] = s.getRemainingBatterybyInteger();

        this.str1=s.SN_LIGHT;
        this.str2=s.SN_TEMP;
        this.str3=s.SN_MOVE;
        this.str4=s.SN_BATT;
         */

        String _tail = "";

        //s.getInternalCounter()        
        //long timer = System.currentTimeMillis();
        //time[index] = timer;//s.getInternalCounter();
        time[index] = s.getDataArrivedTimer();//timer;//s.getInternalCounter();

        //timer=0;
        //masa chuo
        /*
        objs[SensorVals.INT_LIGHT][index] = new GuiSmallObj(s.getInternalCounter(), s.SN_LIGHT + _tail, s.getLightSensorVal(), Color.red);//red
        objs[SensorVals.INT_TEMP][index] = new GuiSmallObj(s.getInternalCounter(), s.SN_TEMP + _tail, s.getTempSensorValbyIngeter(), Color.blue);//blue
        objs[SensorVals.INT_MOVE][index] = new GuiSmallObj(s.getInternalCounter(), s.SN_MOVE + _tail, s.getAllMovementbyInteger(), Color.gray);//darkGray
        objs[SensorVals.INT_AX][index] = new GuiSmallObj(s.getInternalCounter(), s.SN_AX + _tail, s.getAccelXbyInteger(), Color.red);//orange
        objs[SensorVals.INT_AY][index] = new GuiSmallObj(s.getInternalCounter(), s.SN_AY + _tail, s.getAccelYbyInteger(), Color.blue);
        objs[SensorVals.INT_AZ][index] = new GuiSmallObj(s.getInternalCounter(), s.SN_AZ + _tail, s.getAccelZbyInteger(), Color.black);//black
        objs[SensorVals.INT_TX][index] = new GuiSmallObj(s.getInternalCounter(), s.SN_TX + _tail, s.getTiltXbyInteger(), Color.red);//orange
        objs[SensorVals.INT_TY][index] = new GuiSmallObj(s.getInternalCounter(), s.SN_TY + _tail, s.getTiltYbyInteger(), Color.blue);
        objs[SensorVals.INT_TZ][index] = new GuiSmallObj(s.getInternalCounter(), s.SN_TZ + _tail, s.getTiltZbyInteger(), Color.black);
        objs[SensorVals.INT_BATT][index] = new GuiSmallObj(s.getInternalCounter(), s.SN_BATT + _tail, s.getRemainingBatterybyInteger(), Color.gray);//black
        objs[SensorVals.INT_RSSI][index] = new GuiSmallObj(s.getInternalCounter(), s.SN_RSSI + _tail, s.getRssiByInteger(), Color.orange);//black
         * */
        objs[SensorVals.INT_LIGHT][index] = new GuiSmallObj(SensorVals.SN_LIGHT + _tail, s.getLightSensorVal(), Color.red);//red
        objs[SensorVals.INT_TEMP][index] = new GuiSmallObj(SensorVals.SN_TEMP + _tail, s.getTempSensorValbyIngeter(), Color.blue);//blue
        objs[SensorVals.INT_MOVE][index] = new GuiSmallObj(SensorVals.SN_MOVE + _tail, s.getAllMovementbyInteger(), Color.gray);//darkGray
        objs[SensorVals.INT_AX][index] = new GuiSmallObj(SensorVals.SN_AX + _tail, s.getAccelXbyInteger(), Color.red);//orange
        objs[SensorVals.INT_AY][index] = new GuiSmallObj(SensorVals.SN_AY + _tail, s.getAccelYbyInteger(), Color.blue);
        objs[SensorVals.INT_AZ][index] = new GuiSmallObj(SensorVals.SN_AZ + _tail, s.getAccelZbyInteger(), Color.black);//black
        objs[SensorVals.INT_TX][index] = new GuiSmallObj(SensorVals.SN_TX + _tail, s.getTiltXbyInteger(), Color.red);//orange
        objs[SensorVals.INT_TY][index] = new GuiSmallObj(SensorVals.SN_TY + _tail, s.getTiltYbyInteger(), Color.blue);
        objs[SensorVals.INT_TZ][index] = new GuiSmallObj(SensorVals.SN_TZ + _tail, s.getTiltZbyInteger(), Color.black);
        objs[SensorVals.INT_BATT][index] = new GuiSmallObj(SensorVals.SN_BATT + _tail, s.getRemainingBatterybyInteger(), Color.gray);//black
        objs[SensorVals.INT_RSSI][index] = new GuiSmallObj(SensorVals.SN_RSSI + _tail, s.getRssiByInteger(), Color.orange);//black


        //////////////
        //timer,String str,int value
        //if(Config.getInstance().isSTASTICS_CALC_ENABLE())
        DBConnectionModule.getInstance().processStasticsOnDB(s.getSensorName(), objs[SensorVals.INT_LIGHT][index], objs[SensorVals.INT_MOVE][index], objs[SensorVals.INT_TEMP][index]);

        try {

            dataTextArea.append(index + ":" + s.toStringByAllIntVal());
            dataTextArea.append("\n");
            dataTextArea.setCaretPosition(dataTextArea.getText().length());

        } catch (Exception e) {

            e.printStackTrace();
            System.err.println("dataTextArea:" + dataTextArea);
            System.err.println("GuiDataWindows getText");
        }


        index++;
        int len = (s.getFreq()) / 100;
        //1000:
        if (len > 150) {
            len = 150;
        } else if (len < 10) {
            len = 10;
        }
        //50:400
        //25:800
        //TH_SAMPLES = 20000 / len + 50;
        TH_SAMPLES = 120;
        if (index > TH_SAMPLES) {
            sumdex += index;
            this.clearIndex();
        }

        repaint();

        return (index - 1);
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     * @SuppressWarnings("unchecked")
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        dataPanel = new javax.swing.JPanel();
        jScrollPane1 = new javax.swing.JScrollPane();
        dataTextArea = new javax.swing.JTextArea();

        dataPanel.setBackground(new java.awt.Color(255, 255, 255));
        dataPanel.setMinimumSize(new java.awt.Dimension(400, 250));
        dataPanel.setPreferredSize(new java.awt.Dimension(400, 250));
        getContentPane().add(dataPanel, java.awt.BorderLayout.CENTER);

        jScrollPane1.setVerticalScrollBarPolicy(javax.swing.ScrollPaneConstants.VERTICAL_SCROLLBAR_ALWAYS);
        jScrollPane1.setMinimumSize(new java.awt.Dimension(400, 100));
        jScrollPane1.setPreferredSize(new java.awt.Dimension(400, 100));

        dataTextArea.setColumns(20);
        dataTextArea.setEditable(false);
        dataTextArea.setRows(4);
        jScrollPane1.setViewportView(dataTextArea);

        getContentPane().add(jScrollPane1, java.awt.BorderLayout.SOUTH);

        pack();
    }// </editor-fold>//GEN-END:initComponents

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JPanel dataPanel;
    private javax.swing.JTextArea dataTextArea;
    private javax.swing.JScrollPane jScrollPane1;
    // End of variables declaration//GEN-END:variables
    //private javax.swing.JScrollPane jScrollPane2;

    /**
     * @return the index
     */
    public int getIndex() {
        return index;
    }
}
