package jp.osoite.tomu.core.db.sqlbuilder;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;

/**
 *
 * @author shima
 */
public final class ItreeSQLBuilder {

    private String tableName;
    private Connection connection;
    private PreparedStatement createStat;
    private PreparedStatement insertStat;
    private PreparedStatement selectStat;

    public ItreeSQLBuilder(Connection connection, String tableName) {
        this.tableName = tableName;
        this.connection = connection;
    }

    public void dropTable() {
        try {
            connection.createStatement().execute("DROP TABLE " + tableName);
        } catch (SQLException ex) {
        }
    }

    public void createTable() throws SQLException {
        if (createStat == null) {
            StringBuilder strBuilder = new StringBuilder();
            strBuilder.append("CREATE TABLE IF NOT EXISTS ");
            strBuilder.append(tableName);
            strBuilder.append(" (`data_id` BIGINT(20) NOT NULL, `timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP, `sensor_type` varchar(50) NOT NULL, `sensor_id` varchar(50) NOT NULL, `latitude` double , `longitude` double)");
            createStat = connection.prepareStatement(strBuilder.toString());
        }
        createStat.execute();
    }

    public void insert(long id, long time, String sensorType, String sensorId, double lat, double lon) throws SQLException {
        if (insertStat == null) {
            StringBuilder strBuilder = new StringBuilder();
            strBuilder.append("INSERT INTO ");
            strBuilder.append(tableName);
            strBuilder.append(" VALUES(?, ?, ?, ?, ?, ?)");
            insertStat = connection.prepareStatement(strBuilder.toString());
        }
        insertStat.setLong(1, id);
        insertStat.setTimestamp(2, new Timestamp(time));
        insertStat.setString(3, sensorType);
        insertStat.setString(4, sensorId);
        insertStat.setDouble(5, lat);
        insertStat.setDouble(6, lon);
        try {
            insertStat.execute();
        } catch (Exception e) {
            createTable();
            insertStat.execute();
        }
    }

    public List<ITreeTableItem> select(long id) throws SQLException {
        if (selectStat == null) {
            StringBuilder strBuilder = new StringBuilder();
            strBuilder.append("SELECT * FROM ");
            strBuilder.append(tableName);
            strBuilder.append(" WHERE data_id = ?");
            selectStat = connection.prepareStatement(strBuilder.toString());
        }
        selectStat.setLong(1, id);
        ResultSet resultSet = selectStat.executeQuery();
        List<ITreeTableItem> result = new ArrayList<ITreeTableItem>();
        while (resultSet.next()) {
            ITreeTableItem item = new ITreeTableItem(
                    resultSet.getString("sensor_id"),
                    resultSet.getString("sensor_type"),
                    resultSet.getTimestamp("timestamp"));
            result.add(item);
        }
        return result;
    }

    public static final class ITreeTableItem {

        private String id;
        private String type;
        private Timestamp sensedTime;

        private ITreeTableItem(String id, String type, Timestamp sensedTime) {
            this.id = id;
            this.type = type;
            this.sensedTime = sensedTime;
        }

        public String getSensorId() {
            return id;
        }

        public String getSensorType() {
            return type;
        }

        public Timestamp getSensedTime(){
            return sensedTime;
        }
    }
}
