package jp.osoite.tomu.core.db.mysql.builder;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import jp.osoite.tomu.xml.jaxb.wrapper.TScanValue;

/**
 *
 * @author shima
 */
public final class TScanSelectSQLExecuter {

    private PreparedStatement selectIdStat;
    private PreparedStatement selectOnlyOneStat;
    private PreparedStatement convertSensorIdStat;
    private PreparedStatement convertTScanIdStat;
    private NearestPointSortingSQLBuilder nearestBuilder;
    private static final String TSCAN_DATA_TABLE = "data_tscan";
    private static final String TSCAN_LOCATION_TABLE = "location_tscan";

    public TScanSelectSQLExecuter(Connection connection) throws SQLException {
        selectIdStat = connection.prepareStatement("SELECT * FROM " + TSCAN_DATA_TABLE + " WHERE tscan_id = ? && (sensed_time BETWEEN ? AND ?) ORDER BY sensed_time DESC");
        selectOnlyOneStat = connection.prepareStatement("SELECT * FROM " + TSCAN_DATA_TABLE + " WHERE tscan_id = ? ORDER BY sensed_time DESC LIMIT 1");
        convertSensorIdStat = connection.prepareStatement("SELECT * FROM " + TSCAN_LOCATION_TABLE + " WHERE tscan_id = ?");
        convertTScanIdStat = connection.prepareStatement("SELECT * FROM " + TSCAN_LOCATION_TABLE + " WHERE sensor_id = ?");
        nearestBuilder = new NearestPointSortingSQLBuilder(connection, TSCAN_LOCATION_TABLE);
    }

    public List<TScanValue> getSensedDataSet(String tscanId) throws SQLException {
        long current = System.currentTimeMillis();
        GregorianCalendar cal = new GregorianCalendar();
        cal.set(Calendar.HOUR_OF_DAY, 0);
        cal.set(Calendar.MINUTE, 0);
        cal.set(Calendar.SECOND, 0);
        selectIdStat.setString(1, tscanId);
        selectIdStat.setTimestamp(2, new Timestamp(cal.getTimeInMillis()));
        selectIdStat.setTimestamp(3, new Timestamp(current));
        List<TScanValue> list = new ArrayList<TScanValue>();
        ResultSet rsultSet = selectIdStat.executeQuery();
        while (rsultSet.next()) {
            TScanValue val = new TScanValue(
                    rsultSet.getString("tscan_id"),
                    rsultSet.getTimestamp("sensed_time").getTime(),
                    rsultSet.getDouble("temperature"),
                    rsultSet.getDouble("humidity"),
                    rsultSet.getInt("lqi"),
                    rsultSet.getInt("voltage"));
            list.add(val);
        }
        return list;
    }

    public TScanValue getCurrentData(long sensorId) throws SQLException {
        String tscanId = convertToTScanId(sensorId);
        selectOnlyOneStat.setString(1, tscanId);
        ResultSet rsultSet = selectOnlyOneStat.executeQuery();
        TScanValue result = null;
        if (rsultSet.next()) {
            result = new TScanValue(rsultSet.getString("tscan_id"),
                    rsultSet.getTimestamp("sensed_time").getTime(),
                    rsultSet.getDouble("temperature"),
                    rsultSet.getDouble("humidity"),
                    rsultSet.getInt("lqi"),
                    rsultSet.getInt("voltage"));
        }
        return result;
    }

    public long convertToSensorId(String tscanId) throws SQLException {
        convertSensorIdStat.setString(1, tscanId);
        ResultSet set = convertSensorIdStat.executeQuery();
        long result = -1;
        if (set.next()) {
            result = set.getLong("sensor_id");
        }
        return result;
    }

    public String convertToTScanId(long sensorId) throws SQLException {
        convertTScanIdStat.setLong(1, sensorId);
        ResultSet set = convertTScanIdStat.executeQuery();
        String result = null;
        if (set.next()) {
            result = set.getString("tscan_id");
        }
        return result;
    }

    public String getNearestId(double lat, double lon) throws SQLException {
        String result = null;
        ResultSet set = nearestBuilder.excecute(lat, lon);
        if (set.next()) {
            result = set.getString("tscan_id");
        }
        return result;
    }
}
