package jp.osoite.tomu.core.db.mysql.builder;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.List;
import jp.osoite.tomu.util.TimeConverter;
import jp.osoite.tomu.xml.jaxb.wrapper.TScanValue;
import jp.osoite.tomu.xml.jaxb.wrapper.UploadTScanWrapper;

/**
 *
 * @author shima
 */
public final class TScanInsertSQLBuilder {

    private PreparedStatement preStat;

    public TScanInsertSQLBuilder(Connection connection, String tableName) throws SQLException {
        StringBuilder strBuilder = new StringBuilder();
        strBuilder.append("INSERT INTO ");
        strBuilder.append(tableName);
        strBuilder.append(" (tscan_id, sensed_time, temperature, humidity, lqi, voltage) VALUES(?, ?, ?, ?, ?, ?)");
        preStat = connection.prepareStatement(strBuilder.toString());
    }

    public void excecute(UploadTScanWrapper wrapper) throws SQLException {
        List<TScanValue> list = wrapper.getTScanValueList();
        for (TScanValue val : list) {
            preStat.setString(1, val.getTscanId());
            preStat.setTimestamp(2, new Timestamp(val.getSensedTime()));
            preStat.setDouble(3, val.getTemperature());
            preStat.setDouble(4, val.getHumidity());
            preStat.setInt(5, val.getLqi());
            preStat.setInt(6, val.getVoltage());
            preStat.execute();
        }
    }

    public static String build(String tableName, TScanValue val) {
        StringBuilder strBuilder = new StringBuilder();
        strBuilder.append("INSERT INTO ");
        strBuilder.append(tableName);
        strBuilder.append(" (tscan_id, sensed_time, temperature, humidity, lqi, voltage) VALUES(\'");
        strBuilder.append(val.getTscanId());
        strBuilder.append("\',\'");
        strBuilder.append(TimeConverter.convertToString(val.getSensedTime()));
        strBuilder.append("\',\'");
        strBuilder.append(val.getTemperature());
        strBuilder.append("\',\'");
        strBuilder.append(val.getHumidity());
        strBuilder.append("\',\'");
        strBuilder.append(val.getLqi());
        strBuilder.append("\',\'");
        strBuilder.append(val.getVoltage());
        strBuilder.append("\')");
        return strBuilder.toString();
    }
}
