package jp.osoite.tomu.core.db.mysql.builder;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

/**
 *
 * @author shima
 */
public final class PedestrianSelectSQLExecuter {

    private PreparedStatement selectIdStat;
    private NearestPointSortingSQLBuilder nearestBuilder;
    private static final String PED_DATA_TABLE = "data_ped";
    private static final String PED_LOCATION_TABLE = "location_ped";

    public PedestrianSelectSQLExecuter(Connection connection) throws SQLException {
        selectIdStat = connection.prepareStatement("SELECT * FROM " + PED_DATA_TABLE + " WHERE sensor_id = ? ORDER BY sensed_time DESC LIMIT 1");
        nearestBuilder = new NearestPointSortingSQLBuilder(connection, PED_LOCATION_TABLE);
    }

    public ResultSet getSensedDataSet(long sensorId) throws SQLException {
        selectIdStat.setLong(1, sensorId);
        return selectIdStat.executeQuery();
    }

    public long getNearestId(double lat, double lon) throws SQLException {
        long result = -1;
        ResultSet set = nearestBuilder.excecute(lat, lon);
        if (set.next()) {
            result = set.getLong("sensor_id");
        }
        return result;
    }
}
