package jp.osoite.tomu.core.db.mysql.builder;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import jp.osoite.tomu.util.TimeConverter;
import jp.osoite.tomu.xml.jaxb.wrapper.Axis.Direction;
import jp.osoite.tomu.xml.jaxb.wrapper.UploadPedestrianWrapper;

/**
 *
 * @author shima
 */
public final class PedestrianInsertSQLBuilder {

    private PreparedStatement preStat;

    public PedestrianInsertSQLBuilder(Connection connection, String tableName) throws SQLException {
        StringBuilder strBuilder = new StringBuilder();
        strBuilder.append("INSERT INTO ");
        strBuilder.append(tableName);
        strBuilder.append("(sensorid,timestamp,timer,sum_num_of_pedestrians,chief_plus_num,chief_plus_compass,chief_plus_speed,chief_minus_num,chief_minus_compass,chief_minus_speed,residence_num,frequency)");
        strBuilder.append(" VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, \'30\')");
        preStat = connection.prepareStatement(strBuilder.toString());
    }

    public boolean excecute(UploadPedestrianWrapper wrapper) throws SQLException {
        preStat.setLong(1, wrapper.getSensorId());
        preStat.setTimestamp(2, new Timestamp(wrapper.getSensedTime()));
        preStat.setLong(3, wrapper.getSensedTime());
        preStat.setInt(4, wrapper.getAllNumber());
        preStat.setInt(5, wrapper.getChiefAxis().getFlowValue(Direction.PLUS));
        preStat.setInt(6, wrapper.getChiefAxis().getCompass(Direction.PLUS));
        preStat.setDouble(7, wrapper.getChiefAxis().getAverageSpeed(Direction.PLUS));
        preStat.setInt(8, wrapper.getChiefAxis().getFlowValue(Direction.MINUS));
        preStat.setInt(9, wrapper.getChiefAxis().getCompass(Direction.MINUS));
        preStat.setDouble(10, wrapper.getChiefAxis().getAverageSpeed(Direction.MINUS));
        preStat.setInt(11, wrapper.getResidence());
        return preStat.execute();
    }

    public static String build(String tableName, UploadPedestrianWrapper wrapper) {
        StringBuilder strBuilder = new StringBuilder();
        strBuilder.append("INSERT INTO ");
        strBuilder.append(tableName);
        strBuilder.append("(sensorid,timestamp,timer,sum_num_of_pedestrians,chief_plus_num,chief_plus_compass,chief_plus_speed,chief_minus_num,chief_minus_compass,chief_minus_speed,residence_num,frequency) VALUES(\'");
        strBuilder.append(wrapper.getSensorId());
        strBuilder.append("\',\'");
        strBuilder.append(TimeConverter.convertToString(wrapper.getSensedTime()));
        strBuilder.append("\',\'");
        strBuilder.append(wrapper.getSensedTime());
        strBuilder.append("\',\'");
        strBuilder.append(wrapper.getAllNumber());
        strBuilder.append("\',\'");
        strBuilder.append(wrapper.getChiefAxis().getFlowValue(Direction.PLUS));
        strBuilder.append("\',\'");
        strBuilder.append(wrapper.getChiefAxis().getCompass(Direction.PLUS));
        strBuilder.append("\',\'");
        strBuilder.append(wrapper.getChiefAxis().getAverageSpeed(Direction.PLUS));
        strBuilder.append("\',\'");
        strBuilder.append(wrapper.getChiefAxis().getFlowValue(Direction.MINUS));
        strBuilder.append("\',\'");
        strBuilder.append(wrapper.getChiefAxis().getCompass(Direction.MINUS));
        strBuilder.append("\',\'");
        strBuilder.append(wrapper.getChiefAxis().getAverageSpeed(Direction.MINUS));
        strBuilder.append("\',\'");
        strBuilder.append(wrapper.getResidence());
        strBuilder.append("\',\'");
        strBuilder.append(30);
        strBuilder.append("\')");
        return strBuilder.toString();
    }
}
