package jp.osoite.tomu.core.db.mysql.builder;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

/**
 *
 * @author shima
 */
public final class NearestPointSortingSQLBuilder {

    private PreparedStatement preStat;

    public NearestPointSortingSQLBuilder(Connection connection, String tableName) throws SQLException {
        StringBuilder strBuilder = new StringBuilder();
        strBuilder.append("SELECT * FROM ");
        strBuilder.append(tableName);
        strBuilder.append(" ORDER BY SQRT(POWER(((? - longitude)/180*3.141592)COS((35 + latitude) / 2 / 180 * 3.141592), 2) + POWER((? -latitude)/180*3.141592, 2)) ASC LIMIT 100");
        preStat = connection.prepareStatement(strBuilder.toString());
    }

    public ResultSet excecute(double latx, double lonx) throws SQLException {
        preStat.setDouble(1, latx);
        preStat.setDouble(2, lonx);
        return preStat.executeQuery();
    }

    public static String build(String tableName, double latx, double lonx) {
        StringBuilder strBuilder = new StringBuilder();
        strBuilder.append("SELECT * FROM ");
        strBuilder.append(tableName);
        strBuilder.append(" ORDER BY SQRT(POWER(((");
        strBuilder.append(latx);
        strBuilder.append(" - longitude)/180*3.141592)COS((35 + latitude) / 2 / 180 * 3.141592), 2) + POWER((");
        strBuilder.append(lonx);
        strBuilder.append(" -latitude)/180*3.141592, 2)) ASC LIMIT 100");
        return strBuilder.toString();
    }
}
