package jp.osoite.tomu.core.db.mysql.builder;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import jp.osoite.tomu.util.TimeConverter;
import jp.osoite.tomu.xml.jaxb.wrapper.UploadKito2Wrapper;

/**
 *
 * @author shima
 */
public final class Kito2InsertSQLBuilder {

    private PreparedStatement preStat;

    public Kito2InsertSQLBuilder(Connection connection, String tableName) throws SQLException {
        StringBuilder strBuilder = new StringBuilder();
        strBuilder.append("INSERT INTO ");
        strBuilder.append(tableName);
        strBuilder.append(" (sensorid,timestamp,timer,compass,latitude,longitude,dpi,url,thumbnail_url) VALUES(?, ?, \'0\', ?, ?, ?, ?, ?, ?)");
        preStat = connection.prepareStatement(strBuilder.toString());
    }

    public boolean excecute(UploadKito2Wrapper kito2obj) throws SQLException {
        preStat.setLong(1, kito2obj.getSensorId());
        preStat.setTimestamp(2, new Timestamp(kito2obj.getSensedTime()));
        preStat.setInt(3, kito2obj.getCompass());
        preStat.setDouble(4, kito2obj.getLatitude());
        preStat.setDouble(5, kito2obj.getLongitude());
        preStat.setInt(6, kito2obj.getDpi());
        preStat.setString(7, kito2obj.getImageUrl());
        preStat.setString(8, kito2obj.getThumbnailUrl());
        return preStat.execute();
    }

    public static String build(String tableName, UploadKito2Wrapper kito2obj) {
        StringBuilder strBuilder = new StringBuilder();
        strBuilder.append("INSERT INTO ");
        strBuilder.append(tableName);
        strBuilder.append(" (sensorid,timestamp,timer,compass,latitude,longitude,dpi,url,thumbnail_url) VALUES(\'");
        strBuilder.append(kito2obj.getSensorId());
        strBuilder.append("\',\'");
        strBuilder.append(TimeConverter.convertToString(kito2obj.getSensedTime()));
        strBuilder.append("\',\'0\',\'");
        strBuilder.append(kito2obj.getCompass());
        strBuilder.append("\',\'");
        strBuilder.append(kito2obj.getLatitude());
        strBuilder.append("\',\'");
        strBuilder.append(kito2obj.getLongitude());
        strBuilder.append("\',\'");
        strBuilder.append(kito2obj.getDpi());
        strBuilder.append("\',\'");
        strBuilder.append(kito2obj.getImageUrl());
        strBuilder.append("\',\'");
        strBuilder.append(kito2obj.getThumbnailUrl());
        strBuilder.append("\')");
        return strBuilder.toString();
    }
}
