package jp.osoite.tomu.core.db.mysql;

import jp.osoite.tomu.util.TimeConverter;
import jp.osoite.tomu.xml.jaxb.wrapper.UploadKito2Wrapper;

/**
 *
 * @author Kodama
 */
public class Kito2DBHelper {

    public static String getSQLStmtCreateTable(String datatablename2) {
        /*
        System.out.println("@@@@ Kito2 db is called :" + datatablename2);
        String stmtStatistics3_create_kito2 = "CREATE TABLE IF NOT EXISTS " + datatablename2 +
        "(`counter` bigint(20) NOT NULL auto_increment," +
        "`sensorid` char(20) NOT NULL," +
        "`timestamp` timestamp NOT NULL default CURRENT_TIMESTAMP," +
        "`timer` long NOT NULL ," + //default"+defTimer+"
        "`compass` int ," +
        "`latitude` double ," +
        "`longitude` double ," +
        "`dpi` int ," +
        "`url` text ," +
        "`thumbnail_url` text ," +
        "PRIMARY KEY  (`counter`))" +
        " ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1";
        return stmtStatistics3_create_kito2;*/

        String stmt_create_kito2 = "CREATE TABLE IF NOT EXISTS " + datatablename2
                + "(`counter` bigint(20) NOT NULL auto_increment,"
                + "`sensorid` char(20) NOT NULL,"
                + "`timestamp` timestamp NOT NULL default CURRENT_TIMESTAMP,"
                + "`timer` long NOT NULL ,"
                + "`compass` int ,"
                + "`latitude` double ,"
                + "`longitude` double ,"
                + "`dpi` int ,"
                + "`url` text ,"
                + "`thumbnail_url` text ,"
                + "PRIMARY KEY  (`counter`))"
                + "ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1;";

        return stmt_create_kito2;

    }

    public static String getKiot2SortedSmt(String datatablename, double latx, double lonx) {
        String str_smt = "SELECT * FROM " + datatablename + " ORDER BY SQRT(POWER(((latx - longitude)/180*3.141592)"
                + "COS((35 + latitude) / 2 / 180 * 3.141592), 2) + POWER((lonx -latitude)/180*3.141592, 2)) ASC LIMIT 100";
        return str_smt;
    }

    public static String getKito2SQLInsertStmt(UploadKito2Wrapper kito2obj, String KITO2_DATA_TABLE_NAME) {
        /* kodama
        String insertStmtStr = "INSERT INTO " + KITO2_TABLE_NAME +
        //"(sensorid,timestamp,internalCounter,light,temp,ax,ay,az,movement,battery,frequency)" +
        "(sensorid,timestamp,timer," +
        " sum_num_of_pedestrians, " +
        "chief_plus_num,  chief_plus_compass,  chief_plus_speed,  " +
        "chief_minus_num,  chief_minus_compass,  chief_minus_speed,  " +
        "residence_num,  " +
        "frequency)" +
        " VALUES(\'" + Long.toString(ukwval.getSensorId())//+"@@"
        + "\',\'" + TimeConverter.convertToString(ukwval.getTime()) + "\',\'" + pval.getMeasurementTime() + "\',\'" + pval.getAllNumber() + "\',\'" + pval.getChiefAxis().getFlowValue(Direction.PLUS) + "\',\'" + pval.getChiefAxis().getCompass(Direction.PLUS) + "\',\'" + pval.getChiefAxis().getAverageSpeed(Direction.PLUS) + "\',\'" + pval.getChiefAxis().getFlowValue(Direction.MINUS) + "\',\'" + pval.getChiefAxis().getCompass(Direction.MINUS) + "\',\'" + pval.getChiefAxis().getAverageSpeed(Direction.MINUS) + "\',\'" + pval.getResidence() + "\',\'" + pval.getFrequency() + "\')";
         */

        System.out.println("@sensed itme kit2"+kito2obj.getSensedTime());
        System.out.println("@sensed itme curre2"+System.currentTimeMillis());

        String insertKito2Str = "INSERT INTO " + KITO2_DATA_TABLE_NAME + " "
                + "(sensorid,timestamp,timer,compass,latitude,longitude,dpi,url,thumbnail_url)"
                + " VALUES(\'"
                + kito2obj.getSensorId() + "\',\'"
                + TimeConverter.convertToString(kito2obj.getSensedTime()) + "\',\'0\',\'"
                + kito2obj.getCompass() + "\',\'"
                + kito2obj.getLatitude() + "\',\'"
                + kito2obj.getLongitude() + "\',\'"
                + kito2obj.getDpi() + "\',\'"
                + kito2obj.getImageUrl() + "\',\'"
                + kito2obj.getThumbnailUrl() + "\')";

        return insertKito2Str;

    }

    /*
    public static String getSQLStmt9BkupHumanFileColums(String PED_TABLE_NAME) {
    SimpleDateFormat sdf1 = new SimpleDateFormat("yyyyMMdd_HHmmss");//yyyyMMdd_HHmmss_Z
    TimeZone tz1 = TimeZone.getTimeZone("Asia/Tokyo");
    Calendar cal1 = Calendar.getInstance(tz1);

    String stripid = "Colums";
    String tailstr = "_" + stripid + "_" + sdf1.format(cal1.getTime());//sdf1.format(date1);//System.currentTimeMillis();


    String str = "show COLUMNS from ";
    //String saving="INTO OUTFILE \'c:/SunSPOT/Human_tatebayashi_data" + tailstr + ".csv\' FIELDS TERMINATED BY \',\'";
    return str + PED_TABLE_NAME;
    }

    public static String getSQLStmt9BkupHumanFile(String sensorname, String PED_TABLE_NAME) {

    SimpleDateFormat sdf1 = new SimpleDateFormat("yyyyMMdd_HHmmss");//yyyyMMdd_HHmmss_Z
    TimeZone tz1 = TimeZone.getTimeZone("Asia/Tokyo");
    Calendar cal1 = Calendar.getInstance(tz1);

    String stripid = "";
    if (UtilSensorID.isHuman(sensorname)) {
    stripid = sensorname.substring("Human".length(), "Human1271543717046".length());


    }
    String tailstr = "_" + stripid + "_" + sdf1.format(cal1.getTime());//sdf1.format(date1);//System.currentTimeMillis();

    String stmtbk9 = "";
    stmtbk9 = "SELECT * FROM " + PED_TABLE_NAME + " where sensorid=\'" + stripid + "\' ORDER BY 1 INTO OUTFILE \'c:/SunSPOT/Human_tatebayashi_data" + tailstr + ".csv\' FIELDS TERMINATED BY \',\'";//ORDER BY 1 LIMIT 5,30

    return stmtbk9;

    }
     */
}
