package jp.osoite.tomu.xmpp.core;

import javax.xml.bind.JAXBException;
import jp.osoite.tomu.jaxb.object.TomuMessage;
import jp.osoite.tomu.jaxb.util.JAXBConverter;
import org.jivesoftware.smack.Chat;
import org.jivesoftware.smack.MessageListener;
import org.jivesoftware.smack.packet.Message;

/**
 * XMPP経由で受信したメッセージを受けるためのリスナです．
 * メッセージを受信しても特に何もしない場合は，本クラスのオブジェクトを
 * XMPPManager(XMPPSetting setting, MessageReceiver recv)に渡してください．
 * @author shima
 */
public class MessageReceiver implements MessageListener {

    /**
     * メッセージを受信すると，このメソッドの引数にメッセージが渡されます．
     * 受信メッセージに対するイベントを発生させる場合は，
     * 本メソッドをオーバーライドしてください．
     * @param message String型メッセージ
     */
    public void receive(String message) {
    }

    /**
     * メッセージを受信すると，このメソッドの引数にメッセージが渡されます．
     * 受信メッセージに対するイベントを発生させる場合は，
     * 本メソッドをオーバーライドしてください．
     * @param tomuMsg TomuMessageオブジェクト
     */
    public void receive(TomuMessage tomuMsg) {
    }

    @Override
    public final void processMessage(Chat chat, Message msg) {
        String message = msg.getBody();
        if (message != null) {
            message = WordReplacer.reverseDotAndHttp(message);
            try {
                receive(JAXBConverter.convertToObj(message));
            } catch (JAXBException ex) {
            }
            receive(message);
        }
    }
}
