package jp.osoite.tomu.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public final class TimeConverter {

    public final static String DEFAULT_SYNTAX = "yyyy-MM-dd HH:mm:ss";
    private static SimpleDateFormat DATE_FORMAT = new SimpleDateFormat(DEFAULT_SYNTAX);
    private SimpleDateFormat instancesFormat;

    public TimeConverter(String syntax) {
        instancesFormat = new SimpleDateFormat(syntax);
    }

    public String convert(long time) {
        Date date = new Date(time);
        return instancesFormat.format(date);
    }

    public long convert(String time) {
        long result = 0;
        try {
            result = instancesFormat.parse(time).getTime();
        } catch (ParseException ex) {
        }
        return result;
    }

    public static void setDateSyntax(String syntax) throws IllegalArgumentException {
        try {
            DATE_FORMAT = new SimpleDateFormat(syntax);
        } catch (Exception e) {
            throw new IllegalArgumentException("Invalid Syntax : " + syntax);
        }
    }

    public static String convertToString(long time) {
        Date date = new Date(time);
        return DATE_FORMAT.format(date);
    }

    public static long convertToLong(String time) {
        long result = 0;
        try {
            result = DATE_FORMAT.parse(time).getTime();
        } catch (ParseException ex) {
        }
        return result;
    }
}
