package jp.osoite.tomu.util;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class PatternMatcher {

    private PatternMatcher() {
    }

    public static String get(String str, String patternStr) {
        return get(str, patternStr, 1);
    }

    public synchronized static String get(String str, String patternStr, int group) {
        Pattern pattern = Pattern.compile(patternStr, Pattern.DOTALL | Pattern.CASE_INSENSITIVE);
        Matcher matcher = pattern.matcher(str);
        return (matcher.find()) ? matcher.group(group) : null;
    }

    public static List<String> getStrings(String str, String patternStr) {
        return getStrings(str, patternStr, 1);
    }

    public synchronized static List<String> getStrings(String str, String patternStr, int group) {
        Pattern pattern = Pattern.compile(patternStr, Pattern.DOTALL | Pattern.CASE_INSENSITIVE);
        Matcher matcher = pattern.matcher(str);
        ArrayList<String> list = new ArrayList<String>();
        while (matcher.find()) {
            list.add(matcher.group(group));
        }
        return list;
    }

    public static String remove(String str, String patternStr) {
        return replace(str, "", patternStr);
    }

    public synchronized static String replace(String str, String replace, String patternStr) {
        Pattern pattern = Pattern.compile(patternStr, Pattern.DOTALL | Pattern.CASE_INSENSITIVE);
        Matcher matcher = pattern.matcher(str);
        return matcher.replaceAll(replace);
    }
}
