package jp.osoite.tomu.upload;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import jp.osoite.tomu.upload.jaxb.config.Element;
import jp.osoite.tomu.upload.jaxb.config.SensorConfiguration;
import jp.osoite.tomu.xmpp.core.XMPPSetting;

/**
 *
 * @author shima
 */
public final class SensorDataUploaderSetting {

    private static SensorDataUploaderSetting SETTING = null;
    private SensorConfiguration config;
    private Map<Integer, String> csvMap;
    private XMPPSetting xmppSetting;
    private int csvLength;

    private SensorDataUploaderSetting() {
        try {
            readConfigurationFile();
        } catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        printSetting();
        initialXmppSetting();
        if (isEnabledCsv()) {
            initialCsv();
        }
        System.out.println("!! Init Done !!");
    }

    private void readConfigurationFile() throws JAXBException {
        JAXBContext jaxbc = JAXBContext.newInstance("jp.osoite.tomu.upload.jaxb.config");
        Unmarshaller unmConf = jaxbc.createUnmarshaller();
        config = (SensorConfiguration) unmConf.unmarshal(new File("./configs/UploadConfiguration.xml"));
        System.out.println("Read : ./configs/UploadConfiguration.xml");
    }

    private void printSetting() {
        System.out.println("Sensor Type : " + config.getSensorType());
        System.out.println("Use CSV : " + config.isUseCSV());
        System.out.println("Use XML : " + config.isUseXML());
        System.out.println("Print Console : " + config.isPrintConsoleMessage());
        System.out.println("Buffer size : " + config.getBufferSize());
        System.out.println("XMPP Account : " + config.getXmppSetting().getAccount());
        System.out.println("XMPP Host : " + config.getXmppSetting().getHost());
        System.out.println("XMPP Port : " + config.getXmppSetting().getPort());
        System.out.println("XMPP Connect to : " + config.getXmppSetting().getConnection());
    }

    private void initialXmppSetting() {
        xmppSetting = new XMPPSetting(config.getXmppSetting().getAccount(),
                config.getXmppSetting().getPass(),
                config.getXmppSetting().getHost(),
                config.getXmppSetting().getPort().intValue(),
                config.getXmppSetting().getService());
    }

    private void initialCsv() {
        csvLength = 0;
        csvMap = new HashMap<Integer, String>();
        List<Element> list = config.getCSVSchema().getElement();
        for (Element e : list) {
            csvMap.put(e.getColumn().intValue(), e.getValue());
            csvLength++;
        }
    }

    public static SensorDataUploaderSetting getInstance() {
        if (SETTING == null) {
            SETTING = new SensorDataUploaderSetting();
        }
        return SETTING;
    }

    public XMPPSetting getXMPPSetting() {
        return xmppSetting;
    }

    public String getConnectAccount() {
        return config.getXmppSetting().getConnection();
    }

    public String getSensorType() {
        return config.getSensorType();
    }

    public String getColumnName(int index) {
        return csvMap.get(index);
    }

    public int getBufferSize() {
        return config.getBufferSize().intValue();
    }

    public int getCsvLength() {
        return csvLength;
    }

    public boolean isEnabledXml() {
        return config.isUseXML();
    }

    public boolean isEnabledCsv() {
        return config.isUseCSV();
    }

    public boolean isEnabledPrintConsole() {
        return config.isPrintConsoleMessage();
    }
}
