package jp.osoite.tomu.upload;

import java.io.IOException;
import java.util.StringTokenizer;
import jp.osoite.tomu.jaxb.object.Head;
import jp.osoite.tomu.jaxb.util.HeadBuilder;
import jp.osoite.tomu.jaxb.util.JAXBConverter;
import jp.osoite.tomu.jaxb.util.SensorDataBuilder;
import jp.osoite.tomu.jaxb.util.UploadBuilder;
import jp.osoite.tomu.util.NullChecker;
import jp.osoite.tomu.xmpp.core.XMPPManager;

/**
 *
 * @author shima
 */
public class DefaultSensorDataUploader {

    private XMPPManager xmppManager;
    private SensorDataUploaderSetting setting;
    private UploadBuilder uploadBuilder;
    private StringBuilder xmlBuilder;
    private volatile long seqNumber;
    private volatile int addedItemCounter;

    public DefaultSensorDataUploader() throws IOException {
        seqNumber = 0;
        setting = SensorDataUploaderSetting.getInstance();
        xmppManager = new XMPPManager(setting.getXMPPSetting());
        xmppManager.login();
        xmppManager.addAccount(setting.getConnectAccount());
    }

    public void send(String text) {
        if (setting.isEnabledCsv()) {
            if (!NullChecker.isNull(text)) {
                buildTomuMessage(text);
            }
        } else if (setting.isEnabledXml()) {
            synchronized (this) {
                if (text.contains("<TomuMessage type=\"SOURCE_UPLOAD\">")) {
                    xmlBuilder = new StringBuilder(text);
                } else {
                    xmlBuilder.append(text);
                }
                if (text.contains("</TomuMessage>")) {
                    xmppManager.send(setting.getConnectAccount(), xmlBuilder.toString());
                }
            }
        } else {
            printConsole("Use Type : all false");
        }
    }

    private void printConsole(String mes) {
        if (setting.isEnabledPrintConsole()) {
            System.out.println(mes);
        }
    }

    private synchronized void buildTomuMessage(String csv) {
        if (uploadBuilder == null) {
            Head head = HeadBuilder.build(System.currentTimeMillis(),
                    seqNumber++,
                    setting.getConnectAccount(),
                    setting.getXMPPSetting().getAccount());
            uploadBuilder = new UploadBuilder(head);
            addedItemCounter = 0;
        }
        StringTokenizer token = new StringTokenizer(csv, ",");
        try {
            SensorDataBuilder sdBuilder = new SensorDataBuilder(
                    setting.getSensorType(),
                    Long.parseLong(token.nextToken()),
                    Long.parseLong(token.nextToken()),
                    Double.parseDouble(token.nextToken()),
                    Double.parseDouble(token.nextToken()));
            for (int i = 4, length = setting.getCsvLength(); i < length; i++) {
                sdBuilder.addValue(setting.getColumnName(i), token.nextToken());
            }
            uploadBuilder.addSensorData(sdBuilder.getSensorData());
            if (++addedItemCounter >= setting.getBufferSize()) {
                printConsole(">> send data");
                xmppManager.send(setting.getConnectAccount(), JAXBConverter.convertToXml(uploadBuilder.getTomuMessage()));
                uploadBuilder = null;
            }
        } catch (Exception e) {
            printConsole("Received invalid csv : " + csv);
        }
    }
}
